#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = gcc
#FC                  = @F77@
CXX                 = 
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c 
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /usr
exec_prefix         = ${prefix}
ARCH                = i686-pc-linux-gnu
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/grass-6.3.0

PLAT_OBJS           = 
STRIPFLAG           = 
CC_SEARCH_FLAGS     = -Wl,-rpath-link,${LIB_RUNTIME_DIR}
LD_SEARCH_FLAGS     = -Wl,-rpath-link,${LIB_RUNTIME_DIR}
LD_LIBRARY_PATH_VAR = LD_LIBRARY_PATH
LIB_RUNTIME_DIR     = $(ARCH_LIBDIR)

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = gcc -shared
SHLIB_LD_EXTRAS     = 
SHLIB_LD_FLAGS      = 
SHLIB_LD_LIBS       = ${LIBS}
SHLIB_CFLAGS        = -fPIC
SHLIB_SUFFIX        = .so
EXE                 = 


# GRASS dirs
GRASS_HOME          = /expo/Build/grass/grass-6.3.0
RUN_GISBASE         = /expo/Build/grass/grass-6.3.0/dist.i686-pc-linux-gnu
RUN_GISRC           = ${ARCH_DISTDIR}/demolocation/.grassrc${GRASS_VERSION_MAJOR}${GRASS_VERSION_MINOR}

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            = 
CFLAGS1             = -O2 -march=i586 
CXXFLAGS1           = 
INCLUDE_DIRS        = 

COMPILE_FLAGS       = $(CPPFLAGS) $(CFLAGS1) $(INCLUDE_DIRS)
COMPILE_FLAGS_CXX   = $(CPPFLAGS) $(CXXFLAGS1) $(INCLUDE_DIRS)
LINK_FLAGS          =  -Wl,--export-dynamic

DLLIB               = -ldl
XCFLAGS             =  -I/usr/X11R7/include
XMINC               = 
XLIBPATH            =  -L/usr/X11R7/lib
XLIB                =  -lSM -lICE -lX11
XTLIB               = -lXt
XMLIB               = 
XEXTRALIBS          = 
USE_X11             = 1

COMPATLIB           = -lbsd-compat
CURSES              = -lncurses $(COMPATLIB)
USE_CURSES          = 1
MATHLIB             = -lm 
XDRLIB              =     -lz 
ICONVLIB            = 
INTLLIB             = 
SOCKLIB             = 

#ZLIB:
ZLIB                =    -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#DBM:
#DBMINCPATH          = @DBMINCPATH@
#DBMLIBPATH          = @DBMLIBPATH@
#DBMLIB              = @DBMLIB@
DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         = 
HISTORYLIB          = 

#PostgreSQL:
PQINCPATH           =  -I/opt/pgsql/include
PQLIBPATH           =  -L/opt/pgsql/lib
PQLIB               =  -lpq 

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB            = 

#SQLite:
SQLITEINCPATH        = 
SQLITELIBPATH        = 
SQLITELIB            =  -lsqlite3 

#FFMPEG
FFMPEGINCPATH        = 
FFMPEGLIBPATH        = 
FFMPEGLIB            = 

#ODBC:
ODBCINC             = 
ODBCLIB             = 

#Image formats:
PNGINC              = 
PNGLIB              =  -lpng  -lz  -lm
USE_PNG             = 1

JPEGINCPATH         = 
JPEGLIBPATH         = 
JPEGLIB             =  -ljpeg 

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLWINC          = 
OPENGLLIB           = 
OPENGLULIB          = 
OPENGLWM            = 
#USE_GLWM            = @USE_GLWM@
OPENGL_X11          = 
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 

#tcl/tk stuff
TCLINCDIR           = 
TKINCDIR            = 
TCLTKLIBPATH        = 
TCLTKLIBS           =  -ltk8.4 -lm  -ltcl8.4 -lm

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 -lm

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = 
BLASINC				= 
LAPACKLIB           = 
LAPACKINC			= 

#GDAL/OGR
GDALLIBS            = -L/usr/lib -lgdal
GDALCFLAGS          = -I/usr/include
USE_GDAL            = 1
USE_OGR             = 1

#FreeType:
FTINC               =  -I/usr/include/freetype2
FTLIB               =  -lfreetype 

#PROJ.4:
PROJINC             =  $(GDALCFLAGS)
PROJLIB             =  -lproj 
NAD2BIN             = /usr/bin/nad2bin
PROJSHARE           = /usr/share/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#Python
PYTHONINC           = -I/usr/include/python2.6 -I/usr/include/python2.6
PYTHONCFLAGS        = -I/usr/include/python2.6 -I/usr/include/python2.6 -fno-strict-aliasing -DNDEBUG -g -fwrapv -O3 -Wall -Wstrict-prototypes
PYTHONLDFLAGS       = -lpthread -ldl -lutil -lm -lpython2.6
SWIG                = /usr/bin/swig
USE_PYTHON          = 1

#wxWidgets
WXVERSION           = 
WXWIDGETSCXXFLAGS   = 
WXWIDGETSCPPFLAGS   = 
WXWIDGETSLIB        = 
USE_WXWIDGETS       = 

#i18N
HAVE_NLS            = 

#Large File Support (LFS)
USE_LARGEFILES      = 

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
MACOSX_APP	    = 

# Cross compilation
CROSS_COMPILING =  
