/* Copyright (c) 2006-2008 MetaCarta, Inc., published under the Clear BSD
 * license.  See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * @requires OpenLayers/Lang.js
 */

/**
 * Namespace: OpenLayers.Lang["sv-SE"]
 * Dictionary for swedish (Sweden).  Keys for entries are used in calls to
 *     <OpenLayers.Lang.translate>.  Entry bodies are normal strings or
 *     strings formatted for use with <OpenLayers.String.format> calls.
 */
OpenLayers.Lang["sv-SE"] = {

    'unhandledRequest': "Ej hanterad frga retur ${statusText}",

    'permalink': "Permalnk",

    'overlays': "Kartlager",

    'baseLayer': "Bakgrundskarta",

    'sameProjection':
        "versiktskartan fungerar endast nr den har samma projektion som huvudkartan",

    'readNotImplemented': "Lsning ej implementerad.",

    'writeNotImplemented': "Skrivning ej implementerad.",

    'noFID': "Kan ej uppdatera feature (objekt) fr vilket FID saknas.",

    'errorLoadingGML': "Fel i laddning av GML-fil ${url}",

    'browserNotSupported':
        "Din webblsare stder inte vektorvisning. Fr nrvarande stds fljande visning:\n${renderers}",

    'componentShouldBe': "addFeatures : komponenten skall vara en ${geomType}",

    // console message
    'getFeatureError':
        "getFeatureFromEvent anropad fr lager utan utritning. Detta betyder oftast att man " +
        "raderat ett lager, men inte en hanterare som r knuten till lagret.",

    // console message
    'minZoomLevelError':
        "Egenskapen minZoomLevel r endast avsedd att anvndas " +
        "med lager med FixedZoomLevels. Att detta WFS-lager " +
        "kontrollerar minZoomLevel r en relik frn ldre versioner. " +
        "Vi kan dock inte ta bort det utan att riskera att " +
        "OL-baserade tillmpningar som anvnder detta slutar " +
        "fungera. Drfr r det satt som deprecated, minZoomLevel " +
        "kommer att tas bort i version 3.0. Anvnd i stllet " +
        "instllning av min/max resolution som beskrivs hr: " +
        "http://trac.openlayers.org/wiki/SettingZoomLevels",

    'commitSuccess': "WFS-transaktion: LYCKADES ${response}",

    'commitFailed': "WFS-transaktion: MISSLYCKADES ${response}",

    'googleWarning':
        "Google-lagret kunde inte laddas korrekt.<br><br>" + 
        "Fr att slippa detta meddelande, vlj en annan bakgrundskarta " +
        "i lagervljaren i vre hgra hrnet.<br><br>" +
        "Sannolikt beror felet p att Google Maps-biblioteket " + 
        "inte r inkluderat p webbsidan eller p att sidan " +
        "inte anger korrekt API-nyckel fr webbplatsen.<br><br>" +
        "Utvecklare: hjlp fr att tgrda detta, " +
        "<a href='http://trac.openlayers.org/wiki/Google' " +
        "target='_blank'>klicka hr</a>.",

    'getLayerWarning':
        "${layerType}-lagret kunde inte laddas korrekt.<br><br>" + 
        "Fr att slippa detta meddelande, vlj en annan bakgrundskarta " +
        "i lagervljaren i vre hgra hrnet.<br><br>" +
        "Sannolikt beror felet p att ${layerLib}-biblioteket " + 
        "inte r inkluderat p webbsidan.<br><br>" +
        "Utvecklare: hjlp fr att tgrda detta, " +
        "<a href='http://trac.openlayers.org/wiki/${layerLib}' " +
        "target='_blank'>klicka hr</a>.",

    'scale': "<strong>Skala</strong> 1 : ${scaleDenom}",

    // console message
    'layerAlreadyAdded':
        "Du frskte lgga till lagret: ${layerName} p kartan, men det har lagts till tidigare",

    // console message
    'reprojectDeprecated':
        "Du anvnder instllningen 'reproject' p lagret ${layerName}. " +
        "Denna instllning markerad som deprecated: den var avsedd " +
        "att anvndas fr att stdja visning av kartdata p kommersiella " +
        "bakgrundskartor, men nu br man i stllet " +
        "anvnda Spherical Mercator-std fr den funktionaliteten. " +
        "Mer information finns " +   
        "p http://trac.openlayers.org/wiki/SphericalMercator.",

    // console message
    'methodDeprecated':
        "Denna metod r markerad som deprecated och kommer att tas bort i 3.0. " +
        "Anvnd ${newMethod} i stllet.",

    // console message
    'boundsAddError': "Du mste skicka bde x- och y-vrde till funktionen add.",

    // console message
    'lonlatAddError': "Du mste skicka bde lon- och lat-vrde till funktionen add.",

    // console message
    'pixelAddError': "Du mste skicka bde x- och y-vrde till funktionen add.",

    // console message
    'unsupportedGeometryType': "Std saknas fr geometritypen: ${geomType}",

    // console message
    'pagePositionFailed':
        "OpenLayers.Util.pagePosition misslyckades: elementet med id ${elemId} kan placeras fel.",
                    
    'end': ''
};
