#!/bin/bash
# phpPgAdmin	(http://phpldapadmin.sourceforge.net/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-14
# require:
#	httpd-2.2
#	php-5.2.6
#	openldap-2.4
#
VERSION="1.1.0.5"
PAC_NAME=phpldapadmin-${VERSION}
SRC_FILE=${PAC_NAME}.zip
SRC_URI="http://downloads.sourceforge.net/phpldapadmin/${SRC_FILE}"
#SRC_URI="http://nchc.dl.sourceforge.net/sourceforge/phpldapadmin/${SRC_FILE}"

REL=P1
CPU=noname
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.5/WWW/PHPAppli
BUILD_DIR=$PLAMO/phpldapadmin
CUSTOM_DIR=$BUILD_DIR/Custom
#PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


unzip $SRC_DIR/$SRC_FILE
cd $PAC_NAME
if [ "$PAT_FILE" != "" ]; then
  patch < $CUSTOM_DIR/$PAT_FILE
fi

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
      TRANSLATORS TODO LICENSE INSTALL HISTORY FAQ DEVELOPERS \
	CREDITS BUGS $WORK/$DOC_DIR
#nkf -ed readme.txt >  $WORK/$DOC_DIR/readme.txt
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

cd ..

DESTDIR=$WORK/opt/htdocs/
mkdir -p $DESTDIR
mv $PAC_NAME $DESTDIR


mkdir -p $WORK/opt/htdocs/AppList
TYP=2
cat >> $WORK/opt/htdocs/AppList/$TYP.$PAC_NAME.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://phpldapadmin.sourceforge.net/
DOC	/usr/share/doc/${PAC_NAME}
EXE	/phpldapadmin/
REM	LDAP Web󥿡ե
__EOCL__


cd $WORK
mkdir -p install
sed -e "s/_VERSION_/$VERSION/g" $CUSTOM_DIR/doinst.sh > install/doinst.sh

tar cvfz $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz opt/htdocs/${PAC_NAME} opt/htdocs/AppList/* ${DOC_DIR} install/doinst.sh

echo "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz ... done"
cd $CWD
