#!/bin/bash
# PHP-5.2	(http://www.php.net)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-12-09
# require:
HTTPD_VER=2.2.10
HTTPD=httpd-$HTTPD_VER
#	postgresql-8.3.x
#	re2c-0.12.2
#PHP
VERSION=5.2.8
#VERSION=5.2.7RC4
#SUHOSIN
# ex. http://download.suhosin.org/suhosin-0.9.27.tgz
SUHOSIN=suhosin-0.9.27
# ex. http://download.suhosin.org/suhosin-patch-5.2.7-0.9.6.3.patch.gz
PAT_VER=
#PAT_VER=0.9.6.3
DOC_ONLY=
#DOC_ONLY=-1	# -1: php binary package only
#DOC_ONLY=1	# 1: document package only

if [ -f /var/log/packages/php ]; then
  echo "/var/log/packages/php existed."
  exit
fi

PAC_NAME=php-${VERSION}
SRC_FILE=${PAC_NAME}.tar.gz
SRC_URI="http://jp.php.net/get/$SRC_FILE/from/this/mirror"
#SRC_URI=http://downloads.php.net/ilia/$SRC_FILE

if [ "$PAT_VER" != "" ]; then
  PAT_FILE=suhosin-patch-${VERSION}-${PAT_VER}.patch.gz
  PAT_URI="http://download.suhosin.org//$PAT_FILE"
  #http://download.suhosin.org/
  #suhosin-patch-5.2.7-0.9.6.3.patch.gz
fi
#MBPAT_FILE=mbstring-jpr-25298-20050414.patch.diff.gz
#MBPAT_URI=http://www.voltex.jp/patches/$MBPAT_FILE

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php
PAC_DIR=$PLAMO/Packages/4.5/09_webdb/03_PHP.tgz/
BUILD_DIR=$PLAMO/php52
CUSTOM_DIR=$BUILD_DIR/Custom
CUSTOM_PAT=php-5.2.6-strict-session.patch
# http://wiki.ohgaki.net/index.php?plugin=attach&refer=PHP%2Fpatch%2FStrictSession&openfile=php-5.2.6-strict-session.patch
# which include http://www.suspekt.org/session_strict_mode.patch

#PREFIX=usr
PREFIX=opt/php5
#DESTDIR=opt/$PAC_NAME
#CONFIG=etc
CONFIG=$PREFIX/etc

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  echo $SRC_URI
  ( cd $SRC_DIR; wget $SRC_URI )
fi
if [ "x$PAT_VER" != "x" ]; then
  if [ ! -f $SRC_DIR/$PAT_FILE ]; then
    (cd $SRC_DIR; wget $PAT_URI);
  fi
fi

DOC_DIR=usr/share/doc/$PAC_NAME
DOC_FILE=php_manual_ja.tar.gz
DOC_URI="http://jp.php.net/get/$DOC_FILE/from/this/mirror"


if [ "x$PAT_VER" = "x" ]; then
  PACKAGE=01_${PAC_NAME}-${SYS_NAME}
else
  PACKAGE=01_${PAC_NAME}_${PAT_VER}-${SYS_NAME}
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/$PREFIX/bin


if [ "$DOC_ONLY" != "1" ]; then

if [ -d $PAC_NAME ]; then
 rm -f ${PAC_NAME}/ext/standard/crypt_blowfish.*
 rm -f ${PAC_NAME}/ext/standard/sha256.*
 rm -f ${PAC_NAME}/ext/varfilter/*
 rm -f ${PAC_NAME}/main/harden*
 rm -f ${PAC_NAME}/Zend/zend_canary.*
 rm -rf ${PAC_NAME}/doc-pak/
fi

tar xvfz $SRC_DIR/$SRC_FILE
# exit
cd ${PAC_NAME}
if [ "x$PAT_VER" != "x" ]; then
  zcat $SRC_DIR/$PAT_FILE | patch -p1
fi
if [ -f $CUSTOM_DIR/$CUSTOM_PAT ]; then
  cat $CUSTOM_DIR/$CUSTOM_PAT | patch -p1
fi
#	if `false`; then
./configure  --prefix=/$PREFIX --with-config-file-path=/$CONFIG \
  --with-apxs2=/opt/httpd/bin/apxs --with-pear \
  --enable-zend-multibyte --enable-mbstring --enable-mbregex \
  --enable-exif --enable-soap --enable-sockets --enable-dbx --with-zlib \
  --enable-sysvmsg --enable-sysvsem --enable-sysvshm --enable-shmop \
  --with-readline --enable-ftp --with-openssl \
  --with-pgsql  --with-pdo-pgsql=/opt/pgsql \
  --enable-sqlite-utf8

  #--with-config-file-scan-dir

make
mv /opt/httpd/conf/httpd.conf /opt/httpd/conf/httpd.conf.orig
make install
mv /opt/httpd/conf/httpd.conf.orig /opt/httpd/conf/httpd.conf

mkdir -p $WORK/opt/htdocs

export PATH=/$PREFIX/bin:$PATH

pear install --alldeps DB
pear install --alldeps Auth
pear install --alldeps Auth_SASL
pear install --alldeps HTML_Template_IT
#pear install HTML_Common HTML_QuickForm HTML_QuickForm_Controller
pear install --alldeps HTML_QuickForm HTML_QuickForm_Controller
#pear install XML_Parser XML_Util Config
pear install --alldeps Config
pear install --alldeps DB
pear install --alldeps Mail_Mime
#pear install Net_Socket HTTP_Request
pear install --alldeps HTTP_Request
pear install --alldeps -f Net_URL
pear install --alldeps -f SOAP
# pear install Date Calendar
pear install --alldeps -f Calendar


pear upgrade-all

ZTS=`sh ./scripts/php-config --extension-dir`

# make extentions
 cp -f /dev/null ext/extpkg.lis

 cd ext/gd
   phpize
   LIBS=" -lz -lm " ./configure --enable-gd-native-ttf --enable-gd-jis-conv --with-freetype-dir=/usr/X11R7 --with-xpm-dir=/usr/X11R7 --with-jpeg-dir=/usr --with-png-dir=/usr  --with-zlib-dir=/usr

   make; make install
   cat >> ../extpkg.lis<<__EOFgd
$ZTS/gd.so
__EOFgd

# cd ../exif
#   phpize
#   ./configure
#   make; makeinstall
#   cat >> ../extpkg.lis<<__EOFexif
#$ZTS/exif.so
#__EOFexif

# cd ../pdo
#   phpize 
#   ./configure --with-pdo-pgsql=/opt/pgsql 
#   make; make install
#   cat >> ../extpkg.lis<<__EOFpdo_pgsql
#$ZTS/pdo_pgsql.so
#__EOFpdo_pgsql

# cd ../pdo_pgsql/
#   phpize 
#   ./configure --with-pdo-pgsql=/opt/pgsql 
#   make; make install
#   cat >> ../extpkg.lis<<__EOFpdo_pgsql
#$ZTS/pdo_pgsql.so
#__EOFpdo_pgsql


# cd ../pgsql
#   phpize
#   ./configure --with-pgsql=/opt/pgsql
#   make; make install
#   cat >> ../extpkg.lis<<__EOFpgsql
#$ZTS/pgsql.so
#__EOFpgsql

 cd ../bz2
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFbz2
$ZTS/bz2.so
__EOFbz2

 cd ../calendar
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFcalendar
$ZTS/calendar.so
__EOFcalendar

 cd ../ctype
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFctype
$ZTS/ctype.so
__EOFctype

 cd ../curl
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFcurl
$ZTS/curl.so
__EOFcurl


 cd ../dba
   phpize
   ./configure --with-gdbm=/usr --with-db4=/usr
   make; make install
   cat >> ../extpkg.lis<<__EOFdba
$ZTS/dba.so
__EOFdba


 cd ../dbase
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFdbase
$ZTS/dbase.so
__EOFdbase


 cd ../gettext
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFgettext
$ZTS/gettext.so
__EOFgettext


 cd ../mcrypt
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFmcrypt
$ZTS/mcrypt.so
__EOFmcrypt

 cd ../mhash
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFmhash
$ZTS/mhash.so
__EOFmhash

 cd ../ncurses
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFncurses
$ZTS/ncurses.so
__EOFncurses

# require net-snmp
 cd ../snmp
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFsnmp
$ZTS/snmp.so
__EOFsnmp

# require openldap
 cd ../ldap
   phpize
   ./configure
   make; make install
   cat >> ../extpkg.lis<<__EOFldap
$ZTS/ldap.so
__EOFldap

# require alpine(imap)
 cd ../imap
   phpize
   ./configure --with-imap-ssl=/usr
   make; make install
   cat >> ../extpkg.lis<<__EOFimap
$ZTS/imap.so
__EOFimap


 cd ../varfilter
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFvarfilter
$ZTS/varfilter.so
__EOFvarfilter


# XMLReader
 cd ../xmlreader/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFxmlreader
$ZTS/xmlreader.so
__EOFxmlreader

# XMLWriter
 cd ../xmlwriter/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFxmlwriter
$ZTS/xmlwriter.so
__EOFxmlwriter

# XMLRPC
 cd ../xmlrpc/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFxmlrpc
$ZTS/xmlrpc.so
__EOFxmlrpc

# XSL
 cd ../xsl/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFxsl
$ZTS/xsl.so
__EOFxsl

# PCNTL
 cd ../pcntl/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFpcntl
$ZTS/pcntl.so
__EOFpcntl

# POSIX
 cd ../posix/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFposix
$ZTS/posix.so
__EOFposix


# ZIP
 cd ../zip/
   phpize 
   ./configure 
   make; make install
   cat >> ../extpkg.lis<<__EOFzip
$ZTS/zip.so
__EOFzip


# require mysql
if [ -d /opt/mysql/lib/mysql ] & [ -f /opt/mysql/bin/mysql_config ]; then
 cd ../mysql
   phpize
   ./configure  --with-mysql=/opt/mysql
   make; make install
   cat >> ../extpkg.lis<<__EOFmysql
$ZTS/mysql.so
__EOFmysql
 cd ../mysqli
   phpize
   ./configure --with-mysqli=/opt/mysql/bin/mysql_config
   make; make install
   cat >> ../extpkg.lis<<__EOFmysqli
$ZTS/mysqli.so
__EOFmysqli
fi

#
# Extra PECLs
#
 mkdir -p ../../modules/
 cd ../../modules/

# RADIUS
  pecl download radius
  tar xvfz radius-*.tgz
  ls radius-*.tgz
  #mv radius-1.*.tgz  $SRC_DIR/modules/
  cd radius-1.*
  phpize
  ./configure
  make; make install
   cat >> ../../ext/extpkg.lis<<__EOFxmlwriter
$ZTS/xmlwriter.so
__EOFxmlwriter
   cd ..

# APC3
 pecl download APC
 tar xvfz APC-3.*.tgz
 cd APC-3.*/
 phpize
  ./configure --enable-apc-mmap=yes --with-apxs=/opt/httpd/bin/apxs
  make; make install
  cp -p apc.php $WORK/opt/htdocs/
  cat >> ../../ext/extpkg.lis<<__EOFapc
$ZTS/apc.so
__EOFapc
   cd ..

# APD
 pecl install apd
 cat >> ../../ext/extpkg.lis<<__EOFapd
$ZTS/apd.so
__EOFapd


# Namazu
wget -N http://osdn.dl.sourceforge.jp/php-i18n/14174/namazu-2.3.1.tgz
tar xvfz namazu-2.3.1.tgz
cd namazu-2.3.1/
 phpize
  ./configure
  make; make install
  cat >> ../../ext/extpkg.lis<<__EOFnamazu
$ZTS/namazu.so
__EOFnamazu

   cd ..


if [ "$SUHOSIN" != "" ]; then
#curl -o $SUHOSIN.tgz http://www.hardened-php.net/suhosin/_media/$SUHOSIN.tgz\?id=download&cache=cache
wget http://download.suhosin.org/$SUHOSIN.tgz
tar xvfz $SUHOSIN.tgz
cd $SUHOSIN/
  phpize 
  ./configure 
  make; make  install
  cat >> ../../ext/extpkg.lis<<__EOFsuhosin
$ZTS/suhosin.so
__EOFsuhosin

  cd ..
fi #SUHOSIN

# UplaodProgress
  pecl install -f uploadprogress
  cat >> ../../ext/extpkg.lis<<__EOFuploadprogress
$ZTS/uploadprogress.so
__EOFuploadprogress

# BCompiler
  pecl install -f bcompiler
  cat >> ../../ext/extpkg.lis<<__EOFbcompiler
$ZTS/bcompiler.so
__EOFbcompiler


  cd ..
cd ..


mkdir -p $WORK/$DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
      CODING_STANDARDS CREDITS EXTENSIONS INSTALL LICENSE UPGRADING \
      README* TODO* \
	$WORK/$DOC_DIR/
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR

mkdir -p $WORK/$PREFIX/bin
cp -p /$PREFIX/bin/php        $WORK/$PREFIX/bin/
cp -p /$PREFIX/bin/pear       $WORK/$PREFIX/bin/
cp -p /$PREFIX/bin/peardev    $WORK/$PREFIX/bin/
cp -p /$PREFIX/bin/pecl       $WORK/$PREFIX/bin/
cp -p /$PREFIX/bin/phpize     $WORK/$PREFIX/bin/
cp -p /$PREFIX/bin/php-config $WORK/$PREFIX/bin/
mkdir -p $WORK/$PREFIX/man/man1
cp -p /$PREFIX/man/man1/php.*     $WORK/$PREFIX/man/man1/
cp -p /$PREFIX/man/man1/php-*     $WORK/$PREFIX/man/man1/
cp -p /$PREFIX/man/man1/phpize.*  $WORK/$PREFIX/man/man1/
gzip $WORK/$PREFIX/man/man1/php*
mkdir -p $WORK/$PREFIX/etc
cp -p /$PREFIX/etc/pear.conf  $WORK/$PREFIX/etc/

cd $WORK
tar cf -  -C / ./$PREFIX/lib/php/  |  tar xvf -
tar cf -  -C / ./$PREFIX/include/php/  |  tar xvf -
chown -R root.root $WORK/$PREFIX/

XTS=`dirname $ZTS`
ZVR=`basename $ZTS`
for i in `ls $XTS`; do \
  if [ $i != $ZVR ]; then
    rm $i
  fi
done
rm -f opt/$HTTPD/conf/httpd.* install/*
mkdir -p opt/$HTTPD/conf/conf.d
cp $CUSTOM_DIR/httpd.php5-sample.conf opt/$HTTPD/conf/conf.d/
mkdir -p opt/$HTTPD/modules
cp -p /opt/$HTTPD/modules/libphp5.so opt/$HTTPD/modules/libphp5.so.$VERSION
mkdir -p opt/$HTTPD/man/man1
cp -p /opt/$HTTPD/man/man1/*.1 opt/$HTTPD/man/man1/
gzip opt/$HTTPD/man/man1/*.1

cp -av $CUSTOM_DIR/htdocs/* $WORK/opt/htdocs/
tar xvfz $CUSTOM_DIR/emacssl.tgz -C usr/share
curl -o $CUSTOM_DIR/php_browscap.ini http://browsers.garykeith.com/stream.asp\?PHP_BrowsCapINI
cp $CUSTOM_DIR/php_browscap.ini $WORK/$PREFIX/lib/php/

mkdir -p $WORK/etc
cp -a $CUSTOM_DIR/profile.d/ $WORK/etc/
mkdir -p $WORK/$CONFIG
if [ "x$PAT_VER" != "x" ]; then
 sed -e "s%_ZTS_%$ZTS%" \
     -e "s%_PREFIX_%/$PREFIX%" \
     -e "s%_CONFIG_%/$CONFIG%" \
	$CUSTOM_DIR/php.ini.hardened > $WORK/$CONFIG/php.ini-plamo
else
 sed -e "s%_ZTS_%$ZTS%" \
     -e "s%_PREFIX_%/$PREFIX%" \
     -e "s%_CONFIG_%/$CONFIG%" \
	$CUSTOM_DIR/php.ini > $WORK/$CONFIG/php.ini-plamo
fi
cat $CUSTOM_DIR/php.ini.apc >> $WORK/$CONFIG/php.ini-plamo

mkdir -p install/
sed -e "s/_VERSION_/$VERSION/" \
    -e "s/_HTTPD_VER_/$HTTPD_VER/" \
    -e "s%_CONFIG_%/$CONFIG%" \
    -e "s%_PACKAGE_%/$PACKAGE%" \
	$CUSTOM_DIR/doinst.sh > install/doinst.sh

mkdir -p $WORK/opt/htdocs/AppList
cat > $WORK/opt/htdocs/AppList/1.$PAC_NAME.list <<__EOCL__
TYP	1
NAM	${PAC_NAME}
URL	http://www.php.net
DOC	${PAC_NAME}/manual-ja
REM	PHP Hypertext Preprocessor Webץߥ󥰳ȯ
__EOCL__


# Make Package
tar cvfz ${PACKAGE}.tgz $PREFIX/*/* opt/${HTTPD}/*/* $DOC_DIR usr/share/emacs/site-lisp/*  opt/htdocs/* $CONFIG/php.ini-plamo etc/profile.d/php5.* install/doinst.sh 
mv -v ${PACKAGE}.tgz $PAC_DIR
echo "$PAC_DIR/${PACKAGE}.tgz ... done"
cd $CWD
 

# exit

fi # !DOC_ONLY

if [ "$DOC_ONLY" = "-1" ]; then
  echo "End build: php program only"
  exit;
fi

##
## Make Document Package
##
DOCPAC=php_doc_ja-${VERSION}-noname-${REL}
LOGF=/tmp/wgetlog$$
(cd $SRC_DIR; \
 wget -N $DOC_URI > $LOGF 2>&1)
cat $LOGF
if  ! grep "not retrieving" $LOGF || [ ! -f $SRC_DIR/php_manual_euc.tar.gz ]; then
  mkdir -p $WORK/$DOC_DIR/manual-ja/html
  ( cd $WORK/$DOC_DIR/manual-ja ; \
    gzip -dc $SRC_DIR/$DOC_FILE | tar xvf - ; cd html; \
    for i in *.html ; do /$PREFIX/bin/php $CUSTOM_DIR/utftoeuc.php < $i > ../$i; done ; \
    cd ../.. ; \
    rm -rf manual-ja/html ; \
    tar cvfz $SRC_DIR/php_manual_euc.tar.gz manual-ja ; \
  )
fi
rm -f $LOGF

cd $WORK
mkdir -p usr/share/doc/$PAC_NAME/manual-ja
tar xvfz $SRC_DIR/php_manual_euc.tar.gz -C usr/share/doc/$PAC_NAME/


tar cvfz ${DOCPAC}.tgz usr/share/doc/$PAC_NAME/manual-ja/
mv -v ${DOCPAC}.tgz $PAC_DIR

