#%% begin initialize 01_php-5.2.6-i586-P3
#!/bin/sh 
#
# This should be done at initial booting after installation.
# requires:
#	httpd-2.2.9
#
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C


VERSION=5.2.6
PREFIX=/opt/php5
CONFIG=/opt/php5/etc
HTTPDIR=/opt/httpd
HTDOCS=/opt/htdocs

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

  if [ ! -f $ROOT/$CONFIG/php.ini ]; then
        cp $ROOT/$CONFIG/php.ini-plamo $ROOT/$CONFIG/php.ini
  fi
  if [ -f $ROOT/$PREFIX/lib/php/php_browscap.ini ]; then
    if fgrep ";browscap" $ROOT/$CONFIG/php.ini 1> /dev/null 2>&1; then
      mv $ROOT/$CONFIG/php.ini $ROOT/$CONFIG/php.ini.bak
      sed -e "s%^;browscap =.*%browscap = $ROOT/$PREFIX/lib/php/php_browscap.ini%" \
        $ROOT/$CONFIG/php.ini.bak > $ROOT/$CONFIG/php.ini
    fi
  fi

  ln -sf $ROOT/usr/share/doc/php-$VERSION $ROOT/$HTDOCS/php-$VERSION


  mv $ROOT/$HTTPDIR/conf/httpd.conf $ROOT/$HTTPDIR/conf/httpd.conf.bak
  sed -e '/^ *DirectoryIndex/a \ \ \ \ DirectoryIndex index.php index.php5 index.phtml index.php.var index.html index.html.var' \
      -e 's/^\( *DirectoryIndex.*\)/#\1/' \
      $ROOT/$HTTPDIR/conf/httpd.conf.bak > $ROOT/$HTTPDIR/conf/httpd.conf


  chown root.apache $ROOT/$HTTPDIR/modules/libphp5.so $ROOT/$HTTPDIR/conf/httpd.conf
  chown wadm.apache $ROOT/$HTDOCS/index.php.*
  chmod go+r        $ROOT/$HTDOCS/index.php.*

  chown root.apache $ROOT/$CONFIG/php.ini
  chmod go+r        $ROOT/$CONFIG/php.ini
  chown -R root.apache $ROOT/$PREFIX/lib/php
  chmod -R go-w,go+rX  $ROOT/$PREFIX/lib/php


# Restart Apache Web Server
if [ "$ROOT" = "" ]; then
  $ROOT/$HTTPDIR/bin/apachectl stop
  sleep 1
  $ROOT/$HTTPDIR/bin/apachectl start
fi
#%% end
