<?php
//   General Table Class patern D
//
//	Define the table schema fields and store the data
//	Add or delete records
//	Sort by field vlues with specified order(ASC or DESC)
//
// Jun Kuwamura <juk@linet.gr.jp>
//		Mon Jul 14 10:20:29 JST 2008
//
// 2008-07-14 JuK new
//
class GeneralTableD
{
  var $gdate;   // generatede date
  var $origin;   // data origin
  var $schema;	// schema array
  var $selected;	// selected field in the schema
  var $record;  	// data record array list
  var $sorder;  // sort order(ascending or descending)
  var $sotype;  // sort type (number or string)
  var $sfield;  // sort field
  var $numfld;	// number of fields in the schema
  var $numrec;	// number of records in the data
  var $error;  	// error messages if occured

  function GeneralTableD ($path = '', $items = '')
  {
    $this->gdate = date("Y-m-d");
    $this->origin = $path;
    $this->numrec = 1;	// uniq record id start from 1
    $this->schema = array('id', 'alevel', 'atime', 'mtime', 'ctime');
    $this->numfld = count($this->schema);
    // defaults
    $this->sotype = SORT_REGULAR;
    $this->sorder = "natsort";
    $this->sfield = "id";
    // error msg buf
    $this->error = array();

    // example for directory
    if ( is_dir("$path") ) {
      $this->schema = array_merge($this->schema, array('name', 'size', 'type'));
      $this->numfld = count($this->schema);

      //print_r($this->schema);
      //echo $this->numfld."\n";

      $d = dir("$path");
      $n = 0;  // counter
      while($entry=$d->read()) {
        if ( $entry == '.' || $entry == '..' ) {
          $access = -1;
        } else {
          if ( is_file("$path/$entry") ) {
            $access = 1;
          } else {
            $access = 0;
          }
        }
        $item = array( 'name' => "$entry",
                       'size' => filesize("$path/$entry"),
                       'type' => filetype("$path/$entry"),
                       'atime' => fileatime("$path/$entry"),
                       'mtime' => filemtime("$path/$entry"),
                       'ctime' => filectime("$path/$entry"),
                       'alevel' => $access
                       );
        $this->add_entry($item);
        $n++;
      }
    }
    $d->close();
    $this->num = $n;
  }


  function add_field ($fld, $ival)
  {
    if (! in_array($fld, $this->schema) ){
      $this->schema = array_merge($this->schema, array($fld));
      $this->numfld = count($this->schema);
      foreach ( $this->record['id'] as $id => $val ) {
        $this->record[$fld][$id] = $ival;
      }
    } else {
      $this->error[] = __METHOD__.": field \"$fld\" was already in schema";
      return false;
    }
  }


  function select_fields ($flds)
  {
    $this->selected = array();
    foreach ( $flds as $fld ) {
      if (! in_array($fld, $this->schema) ){
        $this->selected[] = $fld;
      } else {
        $this->error[] = __METHOD__.": field \"$fld\" is not in schema";
      }
    }
  }


  function add_entry ($items = '')
  {
    $id = $this->numrec++;
    $this->record['id'][$id] = $id;
    $this->record['alevel'][$id] = 0;
    $now = time();
    $this->record['atime'][$id] = $now;
    $this->record['mtime'][$id] = $now;
    $this->record['ctime'][$id] = $now;
    if ( !empty($items) && is_array($items) ) {
      foreach ( $items as $key => $val ) {
        $this->record[$key][$id] = $val;
      }
    } else {
      $this->error[] = __METHOD__.": items \"$items\" is not an array";
    }
  }

  function update_entry ($key, $cons, $items)
  {
    if ( !empty($items) && is_array($items) ) {
      $id = $this->search_entry($key, $cons);
      if ( $id !== false ) {
        if ( in_array($key, $this->schema) ){
          foreach ( $items as $fld => $val ) {
            $this->record[$fld][$id] = $val;
          }
        } else {
          $this->error[] = __METHOD__.": field \"$fld\" is not in schema";
        }
      } else {
        $this->error[] = __METHOD__.": record  $key = $cond is not found";
        return false;
      }
    } else {
      $this->error[] = __METHOD__.": items \"$items\" is not an array";
      return false;
    }
  }

  function search_entry ( $key, $cons ) {
    if ( in_array($key, $this->schema) ){
      $candid = array_search($cons, $this->record[$key]);
      if ( $candid !== false ) {
        return $candid;
      } else {
        $this->error[] = __METHOD__.":  no \"$cons\" value found in $key record ";
        return false;
      }
    } else {
      $this->error[] = __METHOD__.": field \"$key\" is not in schema";
      return false;
    }
  }

  function get_numrec ()
  {
    return $this->numrec;
  }

  function set_sorder ( $scend )
  {
    $sc = strtolower(substr(ltrim($scend), 0, 1));
    switch ($sc) {
    case 'd':
    case '-':
      $this->sorder = "arsort";	# "DESC";
      break;
    case 'a':
    case '+':
      $this->sorder = "asort"; # "ASC";
      break;
    case 'n':
      $this->sorder = "natsort"; # Natural sort
      break;
    default:
      $this->error[] = __METHOD__.": order by \"$scend\" is not in schema";
      return false;
    }
  }

  function set_sfield ($bym)
  {
    $by = strtolower(trim($bym));
    if ( in_array($by, $this->schema) ){
      $this->sfield = $by;
    } else {
      $this->error[] = __METHOD__.": sort field \"$bym\" is not in schema";
      return false;
    }
  }

  function set_sotype ($type)
  {
    $st = strtolower(substr(ltrim($type), 0, 1));
    switch ($st) {
    case 'n':
    case 'i':
    case 'f':
      $this->sotype = SORT_NUMERIC;
      break;
    case 'c':
    case 's':
      $this->sotype = SORT_STRING;
      break;
    case 'l':
      $this->sotype = SORT_LOCALE_STRING;
      break;
    default:
      $this->sotype = SORT_REGULAR;
    }
  }

  function sort_records ()
  {
    $sortfunc = $this->sorder;
    $sorttype = $this->sotype;
    $sortfld = $this->sfield;    // sort $this->sfield field for id
    if ( $sortfunc == "natsort" ) {
      natsort($this->record[$sortfld]);
    } else {
      $sortfunc($this->record[$sortfld], $sorttype);
    }
    reset($this->record[$sortfld]);
  }
  
  public function current_key ()
  {
    return key($this->record[$this->sfield]);
  }
  private function next_key ()
  {
    if ( next($this->record[$this->sfield]) )
      return $this->current_key();
  }
  private function previous_key ()
  {
    if ( previous($this->record[$this->sfield]) )
      return $this->current_key();
  }
  private function end_key ()
  {
    end($this->record[$this->sfield]);
    return $this->current_key();
  }
  private function reset_key ()
  {
    reset($this->record[$this->sfield]);
    return $this->current_key();
  }
  private function point_key ($id)
  {
    $key = $this->reset_key();
    do {
      if ($key === $id)
        break;
    } while ($key = $this->next_key());
  }

  function key_record ($id)
  {
    foreach ( $this->schema as $key => $fld ) {
      if ( isset($this->record[$fld][$id]) ) {
          $record[$fld] =  $this->record[$fld][$id];
      } else {
        $this->error[] = __METHOD__.": \"$id\" is not existed in schema[$fld] lengh:".strlen("$id");
      }
    }
    return $record;
  }

  function current_record ()
  {
    $id = $this->current_key();
    return $this->key_record($id);
  }

  function next_record ()
  {
    $id = $this->next_key();
    if ($id) 
      return $this->key_record($id);
  }
  function previous_record ()
  {
    $id = $this->previous_key();
    if ($id) 
      return $this->key_record($id);
  }
  function end_record ()
  {
    $id = $this->end_key();
    return $this->key_record($id);
  }
  function reset_record ()
  {
    $id = $this->reset_key();
    return $this->key_record($id);
  }
  function point_record ($id)
  {
    $this->point_key($id);
    return $this->key_record($id);
  }

  function count_record ()
  {
    return count($this->record[$this->sfield]);
  }

  function html_schema ( $flds = '' )
  {
    $html = "";
    if ( empty($flds) ) {
      foreach ( $this->schema as $key => $fld ) {
        $html .= "<th>$fld</th>";
      }
    } else {
      if (! is_array($flds) ) {
        $flds = array("$flds");
      }
      foreach ( $flds as $fld ) {
        $html .= "<th>$fld</th>";
      }
    }
    return $html;
  }

  function html_record ( $flds = '' )
  {
    $html = "";
    $record = $this->current_record();
    if ( empty($flds) ) {
      while (list ($key, $val) = each ($record)) {
        $html .= "<td>$val</td>";
      }
    } else {
      if (! is_array($flds) ) {
        $flds = array("$flds");
      }
      foreach ( $flds as $fld ) {
        $html .= "<td>$record[$fld]</td>";
      }
    }
    return $html;
  }

  function print_record ()
  {
    $record = $this->current_record();
    print_r($record);
    print "\n";
    //while (list ($key, $val) = each ($record)) {
    //  echo "$key: $val<br>\n";
    //}
  }

  function print_records ()
  {
    $pk = $this->current_key();
    $key = $this->reset_key();
      echo "<td>".$n++."</td>\n";

    echo "<table>";
    echo "<tr>";
    echo "<th>#</th>\n";
    echo $this->html_schema();
    echo "</tr>";

    $n=1;
    do {
      echo "<tr>";
      echo "<td>".$n++."</td>\n";
      $record = $this->current_record();
      echo $this->html_record();
      echo "</tr>";
    } while ($key = $this->next_key());

    echo "</table>";

    $this->point_key($pk);
  }

  function get_fieldrec ($fld, $level = 1)
  {
    $zfld = array();
    if ( in_array($fld, $this->schema) ){
      $id = $this->reset_key();
      do {
        if ( $this->record['alevel'][$id] >= $level ) {
          $zfld[$id] = $this->record[$fld][$id];
        }
      } while ($id = $this->next_key());
      return $zfld;
    } else {
      $this->error[] = __METHOD__.": field \"$fld\" is not in schema";
      return false;
    }
  }

  function print_fieldrec($fld)
  {
    if ( $zfld = $this->get_fieldrec($fld) ) {
      while ( list($key, $val) = each($this->record[$fld]) ) {
        echo "$key, $val<br>\n";
      }
    } else {
      $this->error[] = __METHOD__.": faild to get field \"$fld\" records";
      return false;
    }
  }

  function print_errors ()
  {
    if (count($this->error) )
      print_r($this->error);
    echo "<br />\n";
  }

  function print_lasterror ()
  {
    if ( $n = count($this->error) ) {
      echo "$n:".$this->error[$n];
      echo "<br />\n";
    }
  }

  // end of class
}
?>
<?php
// The followngs are the test statements.
$TEST=0;
if ($TEST) {
$original_directory=".";
echo "////////// directory: ".$original_directory." ////////////////////";
$file_list = new GeneralTableD ("$original_directory");
// var_dump($file_list);

echo "<br>file size list:<br>\n";
$file_list->print_fieldrec('size');

echo "<br>sort by size:<br>\n";
$file_list->set_sfield("size");
$file_list->sort_records();
$file_list->print_records();

echo "<br>sort by size in descendant order:<br>\n";
$file_list->set_sfield("size");
$file_list->set_sorder("descend");
$file_list->sort_records();
$file_list->print_records();

echo "<br>sort by name:<br>";
$file_list->set_sfield("name");
$file_list->set_sorder("ascend");
$file_list->sort_records();
$file_list->print_records();

// error print
$file_list->print_errors();

}
?>
