#!/bin/bash
# Drupal	(http://drupal.org)(http://drupal.jp)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-09-17
# require:
#	httpd-2.2.x
#	php-5.2.x
#	postgresql-8.4.x
#
MVER=14
FVER=`printf "%03d" $MVER`
VERSION=6.$MVER
#SRC_URI="http://ftp.drupal.org/files/projects/drupal-${VERSION}.tar.gz"
#http://downloads.sourceforge.net/drupal-jp/drupal-6.10-japanese_010.tgz
PAC_NAME=drupal-$VERSION
SRC_URI=http://downloads.sourceforge.net/drupal-jp/${PAC_NAME}-japanese_${FVER}.tgz
SRC_FILE=${SRC_URI##*/}
JAM_URI=http://downloads.sourceforge.net/drupal-jp/jamail-6.x-1.0.tgz
JAM_FILE=${JAM_URI##*/}
# download from http://github.com/juk/drupal-tsearch/tree/37b67213389f4e15efc5648387a175b643bfd5fe
#TS2_FILE=juk-drupal-tsearch-37b67213389f4e15efc5648387a175b643bfd5fe.tar.gz
#TS2_DIR=${TS2_FILE%%.tar.gz}
# using git:# git  clone  git://github.com/juk/drupal-tsearch.git

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/drupal6
CUSTOM_DIR=$BUILD_DIR/Custom

( cd $CUSTOM_DIR; 
  wget -N http://drupal.org/files/issues/search-chouonpu-D6.patch )
PAT_FILE=search-chouonpu-D6.patch

REL=P1
CPU=noarch
SYS_NAME="${CPU}-${REL}"


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
export CFLAGS="-O2"
export PATH=$PATH:/usr/X11R6/bin

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi
if [ ! -f $SRC_DIR/$JAM_FILE ]; then
  ( cd $SRC_DIR; wget $JAM_URI )
fi 

( cd $CUSTOM_DIR; 
  git clone git://github.com/juk/drupal-tsearch.git )

cd $WORK
mkdir -p install
sed -e "s/VERSION/$VERSION/g" \
    -e "s/_PACKAGE_NAME_/${PAC_NAME}-${SYS_NAME}/g" \
  $CUSTOM_DIR/doinst.sh > install/doinst.sh
echo "To install japanese package drupal see:"
echo "        http://drupal.jp/drupal6/guide/install-step1"

mkdir -p opt/htdocs | exit 1
cd opt/htdocs
tar xvfz $SRC_DIR/$SRC_FILE
chmod -R o-w $PAC_NAME
cd $PAC_NAME

if [ -f $CUSTOM_DIR/$PAT_FILE ]; then
  patch -p0 < $CUSTOM_DIR/$PAT_FILE
fi

## patch to use unix domain socket with pgsql
#patch install.php $CUSTOM_DIR/install.php-pg.patch

# insert installtion notation into index.php
head -2 index.php > index.php.new
cat >>index.php.new<<EOF

if ( file_exists("install.php") ) {
  echo "<font color='red'>1.) Please access '<a href='install.php'>install.php</a>' for initial installation!  (You should make sure your mail server working before the installation.)</a></font><br />\n";
  echo "<font color='red'>2.) Please remove 'install.php' after the installation to start setup your site!</font><br />\n";
}

//for php-5.3// error_reporting(E_ALL & ~E_DEPRECATED);

EOF
sed -e '1,2d' index.php >> index.php.new
mv  index.php.new  index.php


mkdir -p files
mkdir -p sites/all/themes
mkdir -p sites/all/modules
(cd sites/all/modules; tar xvfz $SRC_DIR/$JAM_FILE)
(cd sites/all/modules;
  mkdir tsearch;  cp $CUSTOM_DIR/drupal-tsearch/* tsearch/;
  patch tsearch/tsearch.install $CUSTOM_DIR/tsearch.install-pg8.4.patch;
# tar xfz $CUSTOM_DIR/$TS2_FILE;
#  mv $TS2_DIR tsearch;
)


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR | exit
cp -p $BUILD_DIR/`basename $0`  \
      [A-Z][A-Z]*  \
    $WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

cp -a $CUSTOM_DIR/custom/ .

chown -R root:apache ./


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://drupal.jp/
DOC	/${DOC_DIR}/
EXE	/drupal6/
REM	content management platform(blog etc.)
__EOCL__



cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
