#!/bin/bash
# pgmemcache	(http://pgfoundry.org/projects/pgmemcache/)
#       BuildScript for Plamo Linux 4.5
#                       by Jun Kuwamura <juk@linet.gr.jp> on 2007-08-19
# require:
#	postgresql-8.3.x
#       libmemcache-1.4.x
#
SRC_URI=http://pgfoundry.org/frs/download.php/1300/pgmemcache_1.2beta1.tar.gz
PAC=pgmemcache
VER=1.2beta1
PG_VER=8.3.3
PAC_NAME=${PAC}-${VER}-${PG_VER}
SRC_FILE=${PAC}_${VER}.tar.gz

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"


PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/dbms/pgsql
PAC_DIR=$PLAMO/Packages/4.5/Database
BUILD_DIR=$PLAMO/pgmemcache
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd ${PAC}_${VER}

rm -f backup-032420080109-pre-${PAC}_${VER}-${PAC}_${VER}.tgz \
      ${PAC}_${VER}-${PAC}_${VER}-i386-1.tgz 
rm -f /var/log/packages/${PAC}_${VER}-${PAC}_${VER}-i386-1

#if ! `which pg_config > /dev/null 2>&1`; then
export PATH=/opt/postgresql-$PG_VER/bin:$PATH
#fi

make clean
make
chkinstall -P -y
rm -f /var/log/packages/${PAC}_${VER}-${PAC}_${VER}-i386-1

tar xvfz ${PAC}_${VER}-${PAC}_${VER}-i386-1.tgz -C $WORK

cd $WORK
if [ -d opt/pgsql ]; then
  mv opt/pgsql opt/postgresql-$PG_VER
fi
cp -p $BUILD_DIR/`basename $0`  \
      $CUSTOM_DIR/postgresql.conf.patch \
    usr/share/doc/${PAC}_${VER}

cat >install/doinst.sh<<EOF
# Begin install script for pgmemcache.
/usr/bin/patch  \$ROOT/opt/pgsql/data/postgresql.conf \$ROOT/usr/share/doc/${PAC}_${VER}/postgresql.conf.patch
/usr/bin/chown postgres.pgsql \$ROOT/opt/pgsql/data/postgresql.conf

/usr/bin/chown postgres.pgsql \$ROOT/opt/postgresql-8.3.3/lib/pgmemcache.so
/usr/bin/chown postgres.pgsql \$ROOT/opt/postgresql-8.3.3/share/contrib/pgmemcache.sql

export PATH=/bin:/usr/bin:\$PATH
\$ROOT/opt/pgsql/bin/pgsqld restart

# End doinst.sh
EOF

tar cvfz ${PAC_NAME}.tgz \
	opt/postgresql-8.3.3/lib/pgmemcache.so \
	opt/postgresql-8.3.3/share/contrib/pgmemcache.sql \
	usr/share/doc/* \
	install/doinst.sh

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD

