# composer.rb: Module of composition for PrimeSession
# $Id: composer.rb,v 1.2 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2005 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

module PrimeComposer
  ## 
  ## Composition methods
  ##
  def edit_insert (string)
    @composer.edit_insert(string)
    return true
  end
  def edit_delete ()
    @composer.edit_delete()
    return true
  end
  def edit_backspace ()
    @composer.edit_backspace()
    return true
  end
  def edit_erase ()
    @composer.edit_erase()
    if PRIME_ENV['hybrid_typing'] then
      @composer.set_mode_hybrid()
    end
    return true
  end
  def edit_undo ()
    @composer.undo()
    return true
  end
  def edit_cursor_right ()
    @composer.cursor_right()
    return true
  end
  def edit_cursor_left ()
    @composer.cursor_left()
    return true
  end
  def edit_cursor_right_edge ()
    @composer.cursor_right_edge()
    return true
  end
  def edit_cursor_left_edge ()
    @composer.cursor_left_edge()
    return true
  end

  ## This returns a list of the preediting string divided by the cursor 
  ## position.
  def edit_get_preedition ()
    return @composer.edit_get_preediting_string()
  end

  def edit_get_query_string ()
    return @composer.edit_get_query_string()
  end

  def edit_set_mode (mode)
    case mode
    when "hybrid" then         # Original
      @composer.set_mode_hybrid()
    when "default" then        # F6
      @composer.set_mode_default()
    when "katakana" then       # F7
      @composer.set_mode_katakana()
    when "half_katakana" then  # F8
      @composer.set_mode_half_katakana()
    when "wide_ascii" then     # F9
      @composer.set_mode_wide_ascii()
    when "raw" then            # F10
      @composer.set_mode_raw()
    else
      return false
    end
    return true
  end

  def edit_commit ()
    reading = edit_get_preedition().join()

    ## Commit the current conversion
    base         = reading
    base_reading = reading
    pos          = nil
    context      = get_context()
    adjunct      = ""
    rest         = ""

    @engines.command(:learn_word,
                     base_reading, base, pos, context, adjunct, rest)

    ## Set next context
    context_reset()
    context_set_previous_word(reading)

    ## Reset the conversion.
    edit_erase()

    return reading
  end
end
