/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIHttpServer.idl
 */

#ifndef __gen_nsIHttpServer_h__
#define __gen_nsIHttpServer_h__


#ifndef __gen_nsIServerSocket_h__
#include "nsIServerSocket.h"
#endif

#ifndef __gen_nsIPropertyBag_h__
#include "nsIPropertyBag.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsILocalFile; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIHttpServer; /* forward declaration */

class nsIHttpRequestHandler; /* forward declaration */

class nsIHttpRequestMetadata; /* forward declaration */

class nsIHttpResponse; /* forward declaration */


/* starting interface:    nsIHttpServer */
#define NS_IHTTPSERVER_IID_STR "5520f79e-ecd5-4c40-843b-97ee13a23747"

#define NS_IHTTPSERVER_IID \
  {0x5520f79e, 0xecd5, 0x4c40, \
    { 0x84, 0x3b, 0x97, 0xee, 0x13, 0xa2, 0x37, 0x47 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIHttpServer : public nsIServerSocketListener {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPSERVER_IID)

  /**
 * An interface which represents an HTTP server.
 */
/**
   * Starts up this server, listening upon the given port.  This method may
   * throw if the process does not have sufficient privileges to open a socket
   * for the given port, and it also throws when called upon a server which has
   * already been started.
   *
   * @param port
   *   the port upon which listening should happen, or -1 if no specific port is
   *   desired
   */
  /* void start (in long port); */
  NS_SCRIPTABLE NS_IMETHOD Start(PRInt32 port) = 0;

  /**
   * Shuts down this server if it is running; if it is not, this method is a
   * no-op.
   *
   * This method will do its best to return after the socket in this
   * server has been closed and all pending requests have completed being
   * served, but this may or may not actually happen, since in some
   * implementations this may not actually be possible.  Implementations which
   * can make this promise should make it explicit in implementation
   * documentation.
   */
  /* void stop (); */
  NS_SCRIPTABLE NS_IMETHOD Stop(void) = 0;

  /**
   * Associates the local file represented by the string file with all requests
   * which match request.
   *
   * @param path
   *   the path which is to be mapped to the given file; must begin with "/" and
   *   be a valid URI path (i.e., no query string, hash reference, etc.)
   * @param file
   *   the file to serve for the given path, or null to remove any mapping that
   *   might exist; this file must exist for the lifetime of the server
   */
  /* void registerFile (in string path, in nsILocalFile file); */
  NS_SCRIPTABLE NS_IMETHOD RegisterFile(const char *path, nsILocalFile *file) = 0;

  /**
   * Registers a custom path handler.
   *
   * @param path
   *   the path on the server (beginning with a "/") which is to be handled by
   *   handler; this path must not include a query string or hash component; it
   *   also should usually be canonicalized, since most browsers will do so
   *   before sending otherwise-matching requests
   * @param handler
   *   an object which will handle any requests for the given path, or null to
   *   remove any existing handler; if while the server is running the handler
   *   throws an exception while responding to a request, an HTTP 500 response
   *   will be returned
   * @throws NS_ERROR_INVALID_ARG
   *   if path does not begin with a "/"
   */
  /* void registerPathHandler (in string path, in nsIHttpRequestHandler handler); */
  NS_SCRIPTABLE NS_IMETHOD RegisterPathHandler(const char *path, nsIHttpRequestHandler *handler) = 0;

  /**
   * Registers a custom error page handler.
   *
   * @param code
   *   the error code which is to be handled by handler
   * @param handler
   *   an object which will handle any requests which generate the given status
   *   code, or null to remove any existing handler.  If the handler throws an
   *   exception during server operation, fallback is to the genericized error
   *   handler (the x00 version), then to 500, using a user-defined error
   *   handler if one exists or the server default handler otherwise.  Fallback
   *   will never occur from a user-provided handler that throws to the same
   *   handler as provided by the server, e.g. a throwing user 404 falls back to
   *   400, not a server-provided 404 that might not throw.
   * @note
   *   If the error handler handles HTTP 500 and throws, behavior is undefined.
   */
  /* void registerErrorHandler (in unsigned long code, in nsIHttpRequestHandler handler); */
  NS_SCRIPTABLE NS_IMETHOD RegisterErrorHandler(PRUint32 code, nsIHttpRequestHandler *handler) = 0;

  /**
   * Maps all requests to paths beneath path to the corresponding file beneath
   * dir.
   *
   * @param path
   *   the absolute path on the server against which requests will be served
   *   from dir (e.g., "/", "/foo/", etc.); must begin and end with a forward
   *   slash
   * @param dir
   *   the directory to be used to serve all requests for paths underneath path
   *   (except those further overridden by another, deeper path registered with
   *   another directory); if null, any current mapping for the given path is
   *   removed
   * @throws NS_ERROR_INVALID_ARG
   *   if dir is non-null and does not exist or is not a directory, or if path
   *   does not begin with and end with a forward slash
   */
  /* void registerDirectory (in string path, in nsILocalFile dir); */
  NS_SCRIPTABLE NS_IMETHOD RegisterDirectory(const char *path, nsILocalFile *dir) = 0;

  /**
   * Associates files with the given extension with the given Content-Type when
   * served by this server, in the absence of any file-specific information
   * about the desired Content-Type.  If type is empty, removes any extant
   * mapping, if one is present.
   *
   * @throws NS_ERROR_INVALID_ARG
   *   if the given type is not a valid header field value, i.e. if it doesn't
   *   match the field-value production in RFC 2616
   * @note
   *   No syntax checking is done of the given type, beyond ensuring that it is
   *   a valid header field value.  Behavior when not given a string matching
   *   the media-type production in RFC 2616 section 3.7 is undefined.
   *   Implementations may choose to define specific behavior for types which do
   *   not match the production, such as for CGI functionality.
   * @note
   *   Implementations MAY treat type as a trusted argument; users who fail to
   *   generate this string from trusted data risk security vulnerabilities.
   */
  /* void registerContentType (in string extension, in string type); */
  NS_SCRIPTABLE NS_IMETHOD RegisterContentType(const char *extension, const char *type) = 0;

  /**
   * Sets the handler used to display the contents of a directory if
   * the directory contains no index page.
   *
   * @param handler
   *   an object which will handle any requests for directories which
   *   do not contain index pages, or null to reset to the default
   *   index handler; if while the server is running the handler
   *   throws an exception while responding to a request, an HTTP 500
   *   response will be returned.  An nsIFile corresponding to the
   *   directory is available from the metadata object passed to the
   *   handler, under the key "directory".
   */
  /* void setIndexHandler (in nsIHttpRequestHandler handler); */
  NS_SCRIPTABLE NS_IMETHOD SetIndexHandler(nsIHttpRequestHandler *handler) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpServer, NS_IHTTPSERVER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPSERVER \
  NS_SCRIPTABLE NS_IMETHOD Start(PRInt32 port); \
  NS_SCRIPTABLE NS_IMETHOD Stop(void); \
  NS_SCRIPTABLE NS_IMETHOD RegisterFile(const char *path, nsILocalFile *file); \
  NS_SCRIPTABLE NS_IMETHOD RegisterPathHandler(const char *path, nsIHttpRequestHandler *handler); \
  NS_SCRIPTABLE NS_IMETHOD RegisterErrorHandler(PRUint32 code, nsIHttpRequestHandler *handler); \
  NS_SCRIPTABLE NS_IMETHOD RegisterDirectory(const char *path, nsILocalFile *dir); \
  NS_SCRIPTABLE NS_IMETHOD RegisterContentType(const char *extension, const char *type); \
  NS_SCRIPTABLE NS_IMETHOD SetIndexHandler(nsIHttpRequestHandler *handler); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPSERVER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Start(PRInt32 port) { return _to Start(port); } \
  NS_SCRIPTABLE NS_IMETHOD Stop(void) { return _to Stop(); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterFile(const char *path, nsILocalFile *file) { return _to RegisterFile(path, file); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterPathHandler(const char *path, nsIHttpRequestHandler *handler) { return _to RegisterPathHandler(path, handler); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterErrorHandler(PRUint32 code, nsIHttpRequestHandler *handler) { return _to RegisterErrorHandler(code, handler); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterDirectory(const char *path, nsILocalFile *dir) { return _to RegisterDirectory(path, dir); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterContentType(const char *extension, const char *type) { return _to RegisterContentType(extension, type); } \
  NS_SCRIPTABLE NS_IMETHOD SetIndexHandler(nsIHttpRequestHandler *handler) { return _to SetIndexHandler(handler); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPSERVER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Start(PRInt32 port) { return !_to ? NS_ERROR_NULL_POINTER : _to->Start(port); } \
  NS_SCRIPTABLE NS_IMETHOD Stop(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Stop(); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterFile(const char *path, nsILocalFile *file) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterFile(path, file); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterPathHandler(const char *path, nsIHttpRequestHandler *handler) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterPathHandler(path, handler); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterErrorHandler(PRUint32 code, nsIHttpRequestHandler *handler) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterErrorHandler(code, handler); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterDirectory(const char *path, nsILocalFile *dir) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterDirectory(path, dir); } \
  NS_SCRIPTABLE NS_IMETHOD RegisterContentType(const char *extension, const char *type) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterContentType(extension, type); } \
  NS_SCRIPTABLE NS_IMETHOD SetIndexHandler(nsIHttpRequestHandler *handler) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIndexHandler(handler); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpServer : public nsIHttpServer
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPSERVER

  nsHttpServer();

private:
  ~nsHttpServer();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpServer, nsIHttpServer)

nsHttpServer::nsHttpServer()
{
  /* member initializers and constructor code */
}

nsHttpServer::~nsHttpServer()
{
  /* destructor code */
}

/* void start (in long port); */
NS_IMETHODIMP nsHttpServer::Start(PRInt32 port)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void stop (); */
NS_IMETHODIMP nsHttpServer::Stop()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerFile (in string path, in nsILocalFile file); */
NS_IMETHODIMP nsHttpServer::RegisterFile(const char *path, nsILocalFile *file)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerPathHandler (in string path, in nsIHttpRequestHandler handler); */
NS_IMETHODIMP nsHttpServer::RegisterPathHandler(const char *path, nsIHttpRequestHandler *handler)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerErrorHandler (in unsigned long code, in nsIHttpRequestHandler handler); */
NS_IMETHODIMP nsHttpServer::RegisterErrorHandler(PRUint32 code, nsIHttpRequestHandler *handler)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerDirectory (in string path, in nsILocalFile dir); */
NS_IMETHODIMP nsHttpServer::RegisterDirectory(const char *path, nsILocalFile *dir)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void registerContentType (in string extension, in string type); */
NS_IMETHODIMP nsHttpServer::RegisterContentType(const char *extension, const char *type)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIndexHandler (in nsIHttpRequestHandler handler); */
NS_IMETHODIMP nsHttpServer::SetIndexHandler(nsIHttpRequestHandler *handler)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIHttpRequestHandler */
#define NS_IHTTPREQUESTHANDLER_IID_STR "2bbb4db7-d285-42b3-a3ce-142b8cc7e139"

#define NS_IHTTPREQUESTHANDLER_IID \
  {0x2bbb4db7, 0xd285, 0x42b3, \
    { 0xa3, 0xce, 0x14, 0x2b, 0x8c, 0xc7, 0xe1, 0x39 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIHttpRequestHandler : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPREQUESTHANDLER_IID)

  /**
 * A representation of a handler for HTTP requests.  The handler is used by
 * calling its .handle method with data for an incoming request; it is the
 * handler's job to use that data as it sees fit to make the desired response.
 *
 * @note
 *   This interface uses the [function] attribute, so you can pass a
 *   script-defined function with the functionality of handle() to any
 *   method which has a nsIHttpRequestHandler parameter, instead of wrapping
 *   it in an otherwise empty object.
 */
/**
   * Processes the HTTP request represented by metadata and initializes the
   * passed-in response to reflect the correct HTTP response.
   *
   * Note that in some uses of nsIHttpRequestHandler, this method is required to
   * not throw an exception; in the general case, however, this method may throw
   * an exception (causing an HTTP 500 response to occur).
   *
   * @param metadata
   *   data representing an HTTP request
   * @param response
   *   an initially-empty response which must be modified to reflect the data
   *   which should be sent as the response to the request described by metadata
   */
  /* void handle (in nsIHttpRequestMetadata metadata, in nsIHttpResponse response); */
  NS_SCRIPTABLE NS_IMETHOD Handle(nsIHttpRequestMetadata *metadata, nsIHttpResponse *response) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpRequestHandler, NS_IHTTPREQUESTHANDLER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPREQUESTHANDLER \
  NS_SCRIPTABLE NS_IMETHOD Handle(nsIHttpRequestMetadata *metadata, nsIHttpResponse *response); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPREQUESTHANDLER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Handle(nsIHttpRequestMetadata *metadata, nsIHttpResponse *response) { return _to Handle(metadata, response); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPREQUESTHANDLER(_to) \
  NS_SCRIPTABLE NS_IMETHOD Handle(nsIHttpRequestMetadata *metadata, nsIHttpResponse *response) { return !_to ? NS_ERROR_NULL_POINTER : _to->Handle(metadata, response); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpRequestHandler : public nsIHttpRequestHandler
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPREQUESTHANDLER

  nsHttpRequestHandler();

private:
  ~nsHttpRequestHandler();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpRequestHandler, nsIHttpRequestHandler)

nsHttpRequestHandler::nsHttpRequestHandler()
{
  /* member initializers and constructor code */
}

nsHttpRequestHandler::~nsHttpRequestHandler()
{
  /* destructor code */
}

/* void handle (in nsIHttpRequestMetadata metadata, in nsIHttpResponse response); */
NS_IMETHODIMP nsHttpRequestHandler::Handle(nsIHttpRequestMetadata *metadata, nsIHttpResponse *response)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIHttpRequestMetadata */
#define NS_IHTTPREQUESTMETADATA_IID_STR "3a899b17-b6eb-4333-8ef4-912df454a551"

#define NS_IHTTPREQUESTMETADATA_IID \
  {0x3a899b17, 0xb6eb, 0x4333, \
    { 0x8e, 0xf4, 0x91, 0x2d, 0xf4, 0x54, 0xa5, 0x51 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIHttpRequestMetadata : public nsIPropertyBag {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPREQUESTMETADATA_IID)

  /**
 * A representation of the data included in an HTTP request.
 */
/**
   * The request type for this request (see RFC 2616, section 5.1.1).
   */
  /* readonly attribute string method; */
  NS_SCRIPTABLE NS_IMETHOD GetMethod(char * *aMethod) = 0;

  /**
   * The host of the data being requested (e.g. "localhost" for the
   * http://localhost:8080/file resource).  Note that the relevant port on the
   * host is specified in this.port.
   */
  /* readonly attribute string host; */
  NS_SCRIPTABLE NS_IMETHOD GetHost(char * *aHost) = 0;

  /**
   * The port on the server on which the request was received.
   */
  /* readonly attribute unsigned long port; */
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRUint32 *aPort) = 0;

  /**
   * The requested path, without any query string (e.g. "/dir/file.txt").  It is
   * guaranteed to begin with a "/".  This string is in the 
   */
  /* readonly attribute string path; */
  NS_SCRIPTABLE NS_IMETHOD GetPath(char * *aPath) = 0;

  /**
   * The URL-encoded query string associated with this request, not including
   * the initial "?".
   */
  /* readonly attribute string queryString; */
  NS_SCRIPTABLE NS_IMETHOD GetQueryString(char * *aQueryString) = 0;

  /**
   * A string containing the HTTP version of the request (i.e., "1.1").  Leading
   * zeros for either component of the version will be omitted.  (In other
   * words, if the request contains the version "1.01", this attribute will be
   * "1.1"; see RFC 2616, section 3.1.)
   */
  /* readonly attribute string httpVersion; */
  NS_SCRIPTABLE NS_IMETHOD GetHttpVersion(char * *aHttpVersion) = 0;

  /**
   * Returns the value for the header in this request specified by fieldName.
   *
   * @param fieldName
   *   the name of the field whose value is to be gotten; note that since HTTP
   *   header field names are case-insensitive, this method produces equivalent
   *   results for "HeAdER" and "hEADer" as fieldName
   * @returns
   *   the field value for the given header; note that this value may be
   *   normalized (e.g., leading/trailing whitespace removed from the value [or
   *   from the values which make this up, if the header is a comma-separated
   *   list of values], whitespace runs compressed to single spaces, etc.)
   * @throws NS_ERROR_INVALID_ARG
   *   if fieldName does not constitute a valid header field name
   * @throws NS_ERROR_NOT_AVAILABLE
   *   if the given header does not exist in this
   */
  /* string getHeader (in string fieldName); */
  NS_SCRIPTABLE NS_IMETHOD GetHeader(const char *fieldName, char **_retval) = 0;

  /**
   * Returns true if a header with the given field name exists in this, false
   * otherwise.
   *
   * @param fieldName
   *   the field name whose existence is to be determined in this; note that
   *   since HTTP header field names are case-insensitive, this method produces
   *   equivalent results for "HeAdER" and "hEADer" as fieldName
   * @throws NS_ERROR_INVALID_ARG
   *   if fieldName does not constitute a valid header field name
   */
  /* boolean hasHeader (in string fieldName); */
  NS_SCRIPTABLE NS_IMETHOD HasHeader(const char *fieldName, PRBool *_retval) = 0;

  /**
   * An nsISimpleEnumerator of nsISupportsStrings over the names of the headers
   * in this request.  The header field names in the enumerator may not
   * necessarily have the same case as they do in the request itself.
   */
  /* readonly attribute nsISimpleEnumerator headers; */
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsISimpleEnumerator * *aHeaders) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpRequestMetadata, NS_IHTTPREQUESTMETADATA_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPREQUESTMETADATA \
  NS_SCRIPTABLE NS_IMETHOD GetMethod(char * *aMethod); \
  NS_SCRIPTABLE NS_IMETHOD GetHost(char * *aHost); \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRUint32 *aPort); \
  NS_SCRIPTABLE NS_IMETHOD GetPath(char * *aPath); \
  NS_SCRIPTABLE NS_IMETHOD GetQueryString(char * *aQueryString); \
  NS_SCRIPTABLE NS_IMETHOD GetHttpVersion(char * *aHttpVersion); \
  NS_SCRIPTABLE NS_IMETHOD GetHeader(const char *fieldName, char **_retval); \
  NS_SCRIPTABLE NS_IMETHOD HasHeader(const char *fieldName, PRBool *_retval); \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsISimpleEnumerator * *aHeaders); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPREQUESTMETADATA(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMethod(char * *aMethod) { return _to GetMethod(aMethod); } \
  NS_SCRIPTABLE NS_IMETHOD GetHost(char * *aHost) { return _to GetHost(aHost); } \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRUint32 *aPort) { return _to GetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD GetPath(char * *aPath) { return _to GetPath(aPath); } \
  NS_SCRIPTABLE NS_IMETHOD GetQueryString(char * *aQueryString) { return _to GetQueryString(aQueryString); } \
  NS_SCRIPTABLE NS_IMETHOD GetHttpVersion(char * *aHttpVersion) { return _to GetHttpVersion(aHttpVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeader(const char *fieldName, char **_retval) { return _to GetHeader(fieldName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasHeader(const char *fieldName, PRBool *_retval) { return _to HasHeader(fieldName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsISimpleEnumerator * *aHeaders) { return _to GetHeaders(aHeaders); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPREQUESTMETADATA(_to) \
  NS_SCRIPTABLE NS_IMETHOD GetMethod(char * *aMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMethod(aMethod); } \
  NS_SCRIPTABLE NS_IMETHOD GetHost(char * *aHost) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHost(aHost); } \
  NS_SCRIPTABLE NS_IMETHOD GetPort(PRUint32 *aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPort(aPort); } \
  NS_SCRIPTABLE NS_IMETHOD GetPath(char * *aPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPath(aPath); } \
  NS_SCRIPTABLE NS_IMETHOD GetQueryString(char * *aQueryString) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetQueryString(aQueryString); } \
  NS_SCRIPTABLE NS_IMETHOD GetHttpVersion(char * *aHttpVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHttpVersion(aHttpVersion); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeader(const char *fieldName, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeader(fieldName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD HasHeader(const char *fieldName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasHeader(fieldName, _retval); } \
  NS_SCRIPTABLE NS_IMETHOD GetHeaders(nsISimpleEnumerator * *aHeaders) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHeaders(aHeaders); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpRequestMetadata : public nsIHttpRequestMetadata
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPREQUESTMETADATA

  nsHttpRequestMetadata();

private:
  ~nsHttpRequestMetadata();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpRequestMetadata, nsIHttpRequestMetadata)

nsHttpRequestMetadata::nsHttpRequestMetadata()
{
  /* member initializers and constructor code */
}

nsHttpRequestMetadata::~nsHttpRequestMetadata()
{
  /* destructor code */
}

/* readonly attribute string method; */
NS_IMETHODIMP nsHttpRequestMetadata::GetMethod(char * *aMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string host; */
NS_IMETHODIMP nsHttpRequestMetadata::GetHost(char * *aHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long port; */
NS_IMETHODIMP nsHttpRequestMetadata::GetPort(PRUint32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string path; */
NS_IMETHODIMP nsHttpRequestMetadata::GetPath(char * *aPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string queryString; */
NS_IMETHODIMP nsHttpRequestMetadata::GetQueryString(char * *aQueryString)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string httpVersion; */
NS_IMETHODIMP nsHttpRequestMetadata::GetHttpVersion(char * *aHttpVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getHeader (in string fieldName); */
NS_IMETHODIMP nsHttpRequestMetadata::GetHeader(const char *fieldName, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasHeader (in string fieldName); */
NS_IMETHODIMP nsHttpRequestMetadata::HasHeader(const char *fieldName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator headers; */
NS_IMETHODIMP nsHttpRequestMetadata::GetHeaders(nsISimpleEnumerator * *aHeaders)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIHttpResponse */
#define NS_IHTTPRESPONSE_IID_STR "a2aaaff7-03bd-43b6-b460-94671e288093"

#define NS_IHTTPRESPONSE_IID \
  {0xa2aaaff7, 0x03bd, 0x43b6, \
    { 0xb4, 0x60, 0x94, 0x67, 0x1e, 0x28, 0x80, 0x93 }}

class NS_NO_VTABLE NS_SCRIPTABLE nsIHttpResponse : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPRESPONSE_IID)

  /**
 * Represents an HTTP response, as described in RFC 2616, section 6.
 */
/**
   * Sets the status line for this.  If this method is never called on this, the
   * status line defaults to "HTTP/", followed by the server's default HTTP
   * version (e.g. "1.1"), followed by " 200 OK".
   *
   * @param httpVersion
   *   the HTTP version of this, as a string (e.g. "1.1"); if null, the server
   *   default is used
   * @param code
   *   the numeric HTTP status code for this
   * @param description
   *   a human-readable description of code; may be null if no description is
   *   desired
   * @throws NS_ERROR_INVALID_ARG
   *   if httpVersion is not a valid HTTP version string, statusCode is greater
   *   than 999, or description contains invalid characters
   */
  /* void setStatusLine (in string httpVersion, in unsigned short statusCode, in string description); */
  NS_SCRIPTABLE NS_IMETHOD SetStatusLine(const char *httpVersion, PRUint16 statusCode, const char *description) = 0;

  /**
   * Sets the specified header in this.
   *
   * @param name
   *   the name of the header; must match the field-name production per RFC 2616
   * @param value
   *   the value of the header; must match the field-value production per RFC
   *   2616
   * @param merge
   *   when true, if the given header already exists in this, the values passed
   *   to this function will be merged into the existing header, per RFC 2616
   *   header semantics; when false, if the given header already exists in this,
   *   it is overwritten with the passed-in values; if the header doesn't exist
   *   in this, it is set regardless of the value of this parameter
   * @throws NS_ERROR_INVALID_ARG
   *   if name or value is not a valid header component
   */
  /* void setHeader (in string name, in string value, in boolean merge); */
  NS_SCRIPTABLE NS_IMETHOD SetHeader(const char *name, const char *value, PRBool merge) = 0;

  /**
   * A stream to which data appearing in the body of this response should be
   * written.
   */
  /* readonly attribute nsIOutputStream bodyOutputStream; */
  NS_SCRIPTABLE NS_IMETHOD GetBodyOutputStream(nsIOutputStream * *aBodyOutputStream) = 0;

  /**
   * Write a string to the response's output stream.
   *
   * @note
   *   This method is only guaranteed to work with ASCII data.
   */
  /* void write (in string data); */
  NS_SCRIPTABLE NS_IMETHOD Write(const char *data) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpResponse, NS_IHTTPRESPONSE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPRESPONSE \
  NS_SCRIPTABLE NS_IMETHOD SetStatusLine(const char *httpVersion, PRUint16 statusCode, const char *description); \
  NS_SCRIPTABLE NS_IMETHOD SetHeader(const char *name, const char *value, PRBool merge); \
  NS_SCRIPTABLE NS_IMETHOD GetBodyOutputStream(nsIOutputStream * *aBodyOutputStream); \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *data); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPRESPONSE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SetStatusLine(const char *httpVersion, PRUint16 statusCode, const char *description) { return _to SetStatusLine(httpVersion, statusCode, description); } \
  NS_SCRIPTABLE NS_IMETHOD SetHeader(const char *name, const char *value, PRBool merge) { return _to SetHeader(name, value, merge); } \
  NS_SCRIPTABLE NS_IMETHOD GetBodyOutputStream(nsIOutputStream * *aBodyOutputStream) { return _to GetBodyOutputStream(aBodyOutputStream); } \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *data) { return _to Write(data); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPRESPONSE(_to) \
  NS_SCRIPTABLE NS_IMETHOD SetStatusLine(const char *httpVersion, PRUint16 statusCode, const char *description) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStatusLine(httpVersion, statusCode, description); } \
  NS_SCRIPTABLE NS_IMETHOD SetHeader(const char *name, const char *value, PRBool merge) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHeader(name, value, merge); } \
  NS_SCRIPTABLE NS_IMETHOD GetBodyOutputStream(nsIOutputStream * *aBodyOutputStream) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBodyOutputStream(aBodyOutputStream); } \
  NS_SCRIPTABLE NS_IMETHOD Write(const char *data) { return !_to ? NS_ERROR_NULL_POINTER : _to->Write(data); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpResponse : public nsIHttpResponse
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPRESPONSE

  nsHttpResponse();

private:
  ~nsHttpResponse();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpResponse, nsIHttpResponse)

nsHttpResponse::nsHttpResponse()
{
  /* member initializers and constructor code */
}

nsHttpResponse::~nsHttpResponse()
{
  /* destructor code */
}

/* void setStatusLine (in string httpVersion, in unsigned short statusCode, in string description); */
NS_IMETHODIMP nsHttpResponse::SetStatusLine(const char *httpVersion, PRUint16 statusCode, const char *description)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setHeader (in string name, in string value, in boolean merge); */
NS_IMETHODIMP nsHttpResponse::SetHeader(const char *name, const char *value, PRBool merge)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIOutputStream bodyOutputStream; */
NS_IMETHODIMP nsHttpResponse::GetBodyOutputStream(nsIOutputStream * *aBodyOutputStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void write (in string data); */
NS_IMETHODIMP nsHttpResponse::Write(const char *data)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIHttpServer_h__ */
