/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.swing.ProgressMonitor;

public class ProgressMonitorInputStream
extends FilterInputStream {
    private ProgressMonitor monitor;
    private int nread = 0;
    private int size = 0;

    public ProgressMonitorInputStream(Component component, Object object, InputStream inputStream) {
        super(inputStream);
        try {
            this.size = inputStream.available();
        }
        catch (IOException iOException) {
            this.size = 0;
        }
        this.monitor = new ProgressMonitor(component, object, null, 0, this.size);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n >= 0) {
            this.monitor.setProgress(++this.nread);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n > 0) {
            this.monitor.setProgress(this.nread += n);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.monitor.setProgress(this.nread += n3);
        }
        if (this.monitor.isCanceled()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("progress");
            interruptedIOException.bytesTransferred = this.nread;
            throw interruptedIOException;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        if (l2 > 0L) {
            this.nread = (int)((long)this.nread + l2);
            this.monitor.setProgress(this.nread);
        }
        return l2;
    }

    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.monitor.setProgress(this.nread);
    }
}

