/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReqEntry {
    private int lrType;
    private KerberosTime lrValue;

    private LastReqEntry() {
    }

    public LastReqEntry(int n, KerberosTime kerberosTime) {
        this.lrType = n;
        this.lrValue = kerberosTime;
    }

    public LastReqEntry(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.lrType = derValue2.getData().getBigInteger().intValue();
        this.lrValue = KerberosTime.parse(derValue.getData(), (byte)1, false);
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.lrType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), this.lrValue.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public Object clone() {
        LastReqEntry lastReqEntry = new LastReqEntry();
        lastReqEntry.lrType = this.lrType;
        lastReqEntry.lrValue = (KerberosTime)this.lrValue.clone();
        return lastReqEntry;
    }
}

