/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.tools.JavaFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StandardLocation implements JavaFileManager.Location
{
    CLASS_OUTPUT,
    SOURCE_OUTPUT,
    CLASS_PATH,
    SOURCE_PATH,
    ANNOTATION_PROCESSOR_PATH,
    PLATFORM_CLASS_PATH;

    private static ConcurrentMap<String, JavaFileManager.Location> locations;

    public static JavaFileManager.Location locationFor(final String string) {
        if (locations.isEmpty()) {
            for (StandardLocation standardLocation : StandardLocation.values()) {
                locations.putIfAbsent(standardLocation.getName(), standardLocation);
            }
        }
        locations.putIfAbsent(string.toString(), new JavaFileManager.Location(){

            public String getName() {
                return string;
            }

            public boolean isOutputLocation() {
                return string.endsWith("_OUTPUT");
            }
        });
        return (JavaFileManager.Location)locations.get(string);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isOutputLocation() {
        return this == CLASS_OUTPUT || this == SOURCE_OUTPUT;
    }

    static {
        locations = new ConcurrentHashMap<String, JavaFileManager.Location>();
    }
}

