/*
 * Decompiled with CFR 0.152.
 */
package sun.dc.pr;

import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathError;
import sun.dc.path.PathException;
import sun.dc.pr.PRError;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathFiller;
import sun.dc.pr.PathStroker;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;

public class Rasterizer {
    public static final int EOFILL = 1;
    public static final int NZFILL = 2;
    public static final int STROKE = 3;
    public static final int ROUND = 10;
    public static final int SQUARE = 20;
    public static final int BUTT = 30;
    public static final int BEVEL = 40;
    public static final int MITER = 50;
    public static final int TILE_SIZE = 1 << PathFiller.tileSizeL2S;
    public static final int TILE_SIZE_L2S = PathFiller.tileSizeL2S;
    public static final int MAX_ALPHA = 1000000;
    public static final int MAX_MITER = 10;
    public static final int MAX_WN = 63;
    public static final int TILE_IS_ALL_0 = 0;
    public static final int TILE_IS_ALL_1 = 1;
    public static final int TILE_IS_GENERAL = 2;
    private static final int BEG = 1;
    private static final int PAC_FILL = 2;
    private static final int PAC_STROKE = 3;
    private static final int PATH = 4;
    private static final int SUBPATH = 5;
    private static final int RAS = 6;
    private int state = 1;
    private PathFiller filler = new PathFiller();
    private PathStroker stroker = new PathStroker(this.filler);
    private PathDasher dasher = new PathDasher(this.stroker);
    private PathConsumer curPC;

    public Rasterizer() {
        Disposer.addRecord(this, new ConsumerDisposer(this.filler, this.stroker, this.dasher));
    }

    public void setUsage(int n) throws PRError {
        if (this.state != 1) {
            throw new PRError("setUsage: unexpected");
        }
        if (n == 1) {
            this.filler.setFillMode(1);
            this.curPC = this.filler;
            this.state = 2;
        } else if (n == 2) {
            this.filler.setFillMode(2);
            this.curPC = this.filler;
            this.state = 2;
        } else if (n == 3) {
            this.curPC = this.stroker;
            this.filler.setFillMode(2);
            this.stroker.setPenDiameter(1.0f);
            this.stroker.setPenT4(null);
            this.stroker.setCaps(10);
            this.stroker.setCorners(10, 0.0f);
            this.state = 3;
        } else {
            throw new PRError("setUsage: unknown usage type");
        }
    }

    public void setPenDiameter(float f) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenDiameter: unexpected");
        }
        this.stroker.setPenDiameter(f);
    }

    public void setPenT4(float[] fArray) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenT4: unexpected");
        }
        this.stroker.setPenT4(fArray);
    }

    public void setPenFitting(float f, int n) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenFitting: unexpected");
        }
        this.stroker.setPenFitting(f, n);
    }

    public void setPenDisplacement(float f, float f2) throws PRError {
        if (this.state != 3) {
            throw new PRError("setPenDisplacement: unexpected");
        }
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f, f, f2};
        this.stroker.setOutputT6(fArray);
    }

    public void setCaps(int n) throws PRError {
        if (this.state != 3) {
            throw new PRError("setCaps: unexpected");
        }
        this.stroker.setCaps(n);
    }

    public void setCorners(int n, float f) throws PRError {
        if (this.state != 3) {
            throw new PRError("setCorners: unexpected");
        }
        this.stroker.setCorners(n, f);
    }

    public void setDash(float[] fArray, float f) throws PRError {
        if (this.state != 3) {
            throw new PRError("setDash: unexpected");
        }
        this.dasher.setDash(fArray, f);
        this.curPC = this.dasher;
    }

    public void setDashT4(float[] fArray) throws PRError {
        if (this.state != 3) {
            throw new PRError("setDashT4: unexpected");
        }
        this.dasher.setDashT4(fArray);
    }

    public void beginPath(float[] fArray) throws PRError {
        this.beginPath();
    }

    public void beginPath() throws PRError {
        if (this.state != 2 && this.state != 3) {
            throw new PRError("beginPath: unexpected");
        }
        try {
            this.curPC.beginPath();
            this.state = 4;
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void beginSubpath(float f, float f2) throws PRError {
        if (this.state != 4 && this.state != 5) {
            throw new PRError("beginSubpath: unexpected");
        }
        try {
            this.curPC.beginSubpath(f, f2);
            this.state = 5;
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void appendLine(float f, float f2) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendLine: unexpected");
        }
        try {
            this.curPC.appendLine(f, f2);
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void appendQuadratic(float f, float f2, float f3, float f4) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendQuadratic: unexpected");
        }
        try {
            this.curPC.appendQuadratic(f, f2, f3, f4);
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void appendCubic(float f, float f2, float f3, float f4, float f5, float f6) throws PRError {
        if (this.state != 5) {
            throw new PRError("appendCubic: unexpected");
        }
        try {
            this.curPC.appendCubic(f, f2, f3, f4, f5, f6);
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void closedSubpath() throws PRError {
        if (this.state != 5) {
            throw new PRError("closedSubpath: unexpected");
        }
        try {
            this.curPC.closedSubpath();
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
    }

    public void endPath() throws PRError, PRException {
        if (this.state != 4 && this.state != 5) {
            throw new PRError("endPath: unexpected");
        }
        try {
            this.curPC.endPath();
            this.state = 6;
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
        catch (PathException pathException) {
            throw new PRException(pathException.getMessage());
        }
    }

    public void useProxy(FastPathProducer fastPathProducer) throws PRError, PRException {
        if (this.state != 2 && this.state != 3) {
            throw new PRError("useProxy: unexpected");
        }
        try {
            this.curPC.useProxy(fastPathProducer);
            this.state = 6;
        }
        catch (PathError pathError) {
            throw new PRError(pathError.getMessage());
        }
        catch (PathException pathException) {
            throw new PRException(pathException.getMessage());
        }
    }

    public void getAlphaBox(int[] nArray) throws PRError {
        this.filler.getAlphaBox(nArray);
    }

    public void setOutputArea(float f, float f2, int n, int n2) throws PRError, PRException {
        this.filler.setOutputArea(f, f2, n, n2);
    }

    public int getTileState() throws PRError {
        return this.filler.getTileState();
    }

    public void writeAlpha(byte[] byArray, int n, int n2, int n3) throws PRError, PRException, InterruptedException {
        this.filler.writeAlpha(byArray, n, n2, n3);
    }

    public void writeAlpha(char[] cArray, int n, int n2, int n3) throws PRError, PRException, InterruptedException {
        this.filler.writeAlpha(cArray, n, n2, n3);
    }

    public void nextTile() throws PRError {
        this.filler.nextTile();
    }

    public void reset() {
        this.state = 1;
        this.filler.reset();
        this.stroker.reset();
        this.dasher.reset();
    }

    private static class ConsumerDisposer
    implements DisposerRecord {
        PathConsumer filler;
        PathConsumer stroker;
        PathConsumer dasher;

        public ConsumerDisposer(PathConsumer pathConsumer, PathConsumer pathConsumer2, PathConsumer pathConsumer3) {
            this.filler = pathConsumer;
            this.stroker = pathConsumer2;
            this.dasher = pathConsumer3;
        }

        public void dispose() {
            this.filler.dispose();
            this.stroker.dispose();
            this.dasher.dispose();
        }
    }
}

