/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gnomevte;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Vector;
import org.gnu.gdk.Color;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Boxed;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gnomevte.event.CharacterSizeChangedEvent;
import org.gnu.gnomevte.event.CharacterSizeChangedListener;
import org.gnu.gnomevte.event.CommitEvent;
import org.gnu.gnomevte.event.CommitListener;
import org.gnu.gnomevte.event.MoveWindowEvent;
import org.gnu.gnomevte.event.MoveWindowListener;
import org.gnu.gnomevte.event.ResizeWindowEvent;
import org.gnu.gnomevte.event.ResizeWindowListener;
import org.gnu.gnomevte.event.TerminalEvent;
import org.gnu.gnomevte.event.TerminalListener;
import org.gnu.gnomevte.event.TextScrolledEvent;
import org.gnu.gnomevte.event.TextScrolledListener;
import org.gnu.gtk.Adjustment;
import org.gnu.gtk.Widget;
import org.gnu.pango.FontDescription;

public class Terminal
extends Widget {
    private int pid_t;
    private Vector terminalListeners;
    private Vector commitListeners;
    private Vector characterSizeChangeListeners;
    private Vector moveWindowListeners;
    private Vector resizeWindowListeners;
    private Vector textScrolledListeners;
    private static EventMap evtMap;

    private /* synthetic */ void finit$() {
        this.terminalListeners = null;
        this.commitListeners = null;
        this.characterSizeChangeListeners = null;
        this.moveWindowListeners = null;
        this.resizeWindowListeners = null;
        this.textScrolledListeners = null;
    }

    protected Terminal(Handle handle) {
        super(handle);
        this.finit$();
    }

    public Terminal() {
        super(Terminal.vte_terminal_new());
        this.finit$();
    }

    public Terminal(String string, String[] stringArray, String string2) {
        this();
        this.pid_t = this.forkCommand(string, stringArray, string2, true, true, true);
    }

    public static Terminal terminalAndShell() {
        Terminal terminal = new Terminal(null, null, null);
        return terminal;
    }

    public int forkCommand(String string, String[] stringArray, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return Terminal.vte_terminal_fork_command(this.getHandle(), string, stringArray, string2, bl, bl2, bl3);
    }

    public void setPty(int n) {
        Terminal.vte_terminal_set_pty(this.getHandle(), n);
    }

    public void feed(String string) {
        if (string != null) {
            Terminal.vte_terminal_feed(this.getHandle(), string, string.length());
        }
    }

    public void feedChild(String string) {
        if (string != null) {
            Terminal.vte_terminal_feed_child(this.getHandle(), string, string.length());
        }
    }

    public void copyClipboard() {
        Terminal.vte_terminal_copy_clipboard(this.getHandle());
    }

    public void pasteClipboard() {
        Terminal.vte_terminal_paste_clipboard(this.getHandle());
    }

    public void copyPrimary() {
        Terminal.vte_terminal_copy_primary(this.getHandle());
    }

    public void pastePrimary() {
        Terminal.vte_terminal_paste_primary(this.getHandle());
    }

    public void setSize(int n, int n2) {
        Terminal.vte_terminal_set_size(this.getHandle(), n, n2);
    }

    public void setAudibleBell(boolean bl) {
        Terminal.vte_terminal_set_audible_bell(this.getHandle(), bl);
    }

    public boolean isBellAudible() {
        return Terminal.vte_terminal_get_audible_bell(this.getHandle());
    }

    public void setVisibleBell(boolean bl) {
        Terminal.vte_terminal_set_visible_bell(this.getHandle(), bl);
    }

    public boolean isBellVisible() {
        return Terminal.vte_terminal_get_visible_bell(this.getHandle());
    }

    public void setScrollOnOutput(boolean bl) {
        Terminal.vte_terminal_set_scroll_on_output(this.getHandle(), bl);
    }

    public void setScrollOnKeystroke(boolean bl) {
        Terminal.vte_terminal_set_scroll_on_keystroke(this.getHandle(), bl);
    }

    public void setDefaultColors() {
        Terminal.vte_terminal_set_default_colors(this.getHandle());
    }

    public void setBackgroundImage(String string) throws FileNotFoundException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        Terminal.vte_terminal_set_background_image_file(this.getHandle(), string);
    }

    public void setBackgroudImage(String string) throws FileNotFoundException {
        this.setBackgroundImage(string);
    }

    public void setBackgroundImage(Pixbuf pixbuf) {
        Terminal.vte_terminal_set_background_image(this.getHandle(), pixbuf.getHandle());
    }

    public void setCursorBlinks(boolean bl) {
        Terminal.vte_terminal_set_cursor_blinks(this.getHandle(), bl);
    }

    public void setScrollbackLines(int n) {
        Terminal.vte_terminal_set_scrollback_lines(this.getHandle(), n);
    }

    public void setBackgroundSaturation(int n) {
        Terminal.vte_terminal_set_background_saturation(this.getHandle(), n);
    }

    public void setBackgroundTransparent(boolean bl) {
        Terminal.vte_terminal_set_background_transparent(this.getHandle(), bl);
    }

    public void setBackgroundColor(Color color) {
        Terminal.vte_terminal_set_color_background(this.getHandle(), color.getHandle());
    }

    public void setBackgroudColor(Color color) {
        this.setBackgroundColor(color);
    }

    public void setForegroundColor(Color color) {
        Terminal.vte_terminal_set_color_foreground(this.getHandle(), color.getHandle());
    }

    public void setColors(Color color, Color color2, Color color3, int n) {
        Terminal.vte_terminal_set_colors(this.getHandle(), color.getHandle(), color2.getHandle(), color3.getHandle(), n);
    }

    public void setColorBold(Color color) {
        Terminal.vte_terminal_set_color_bold(this.getHandle(), color.getHandle());
    }

    public void setColorDim(Color color) {
        Terminal.vte_terminal_set_color_dim(this.getHandle(), color.getHandle());
    }

    public void setFont(FontDescription fontDescription) {
        Terminal.vte_terminal_set_font(this.getHandle(), fontDescription.getHandle());
    }

    public FontDescription getFont() {
        Handle handle = Terminal.vte_terminal_get_font(this.getHandle());
        if (handle != null) {
            FontDescription fontDescription = (FontDescription)Boxed.getBoxedFromHandle((Handle)handle);
            if (fontDescription != null) {
                return fontDescription;
            }
            return new FontDescription(fontDescription);
        }
        return null;
    }

    public void setAllowBold(boolean bl) {
        Terminal.vte_terminal_set_allow_bold(this.getHandle(), bl);
    }

    public boolean getAllowBold() {
        return Terminal.vte_terminal_get_allow_bold(this.getHandle());
    }

    public void reset(boolean bl, boolean bl2) {
        Terminal.vte_terminal_reset(this.getHandle(), bl, bl2);
    }

    public void setEmulation(String string) {
        Terminal.vte_terminal_set_emulation(this.getHandle(), string);
    }

    public String getEmulation() {
        return Terminal.vte_terminal_get_emulation(this.getHandle());
    }

    public void setEncoding(String string) {
        Terminal.vte_terminal_set_encoding(this.getHandle(), string);
    }

    public String getEncoding() {
        return Terminal.vte_terminal_get_encoding(this.getHandle());
    }

    public String getStatusLine() {
        return Terminal.vte_terminal_get_status_line(this.getHandle());
    }

    public boolean hasSelection() {
        return Terminal.vte_terminal_get_has_selection(this.getHandle());
    }

    public Adjustment getAdjustment() {
        Handle handle = Terminal.vte_terminal_get_adjustment(this.getHandle());
        return Adjustment.getAdjustment((Handle)handle);
    }

    protected void fireTerminalEvent(TerminalEvent terminalEvent) {
        if (this.terminalListeners == null) {
            return;
        }
        Iterator iterator = this.terminalListeners.iterator();
        while (iterator.hasNext()) {
            TerminalListener terminalListener = (TerminalListener)iterator.next();
            terminalListener.terminalEvent(terminalEvent);
        }
    }

    protected void fireTerminalCommitEvent(CommitEvent commitEvent) {
        if (this.commitListeners == null) {
            return;
        }
        Iterator iterator = this.commitListeners.iterator();
        while (iterator.hasNext()) {
            CommitListener commitListener = (CommitListener)iterator.next();
            commitListener.committed(commitEvent);
        }
    }

    protected void fireTerminalCharacterSizeChangedEvent(CharacterSizeChangedEvent characterSizeChangedEvent) {
        if (this.characterSizeChangeListeners == null) {
            return;
        }
        Iterator iterator = this.characterSizeChangeListeners.iterator();
        while (iterator.hasNext()) {
            CharacterSizeChangedListener characterSizeChangedListener = (CharacterSizeChangedListener)iterator.next();
            characterSizeChangedListener.characterSizeChanged(characterSizeChangedEvent);
        }
    }

    protected void fireTerminalMoveWindowEvent(MoveWindowEvent moveWindowEvent) {
        if (this.moveWindowListeners == null) {
            return;
        }
        Iterator iterator = this.moveWindowListeners.iterator();
        while (iterator.hasNext()) {
            MoveWindowListener moveWindowListener = (MoveWindowListener)iterator.next();
            moveWindowListener.windowMoved(moveWindowEvent);
        }
    }

    protected void fireTerminalResizeWindowEvent(ResizeWindowEvent resizeWindowEvent) {
        if (this.resizeWindowListeners == null) {
            return;
        }
        Iterator iterator = this.resizeWindowListeners.iterator();
        while (iterator.hasNext()) {
            ResizeWindowListener resizeWindowListener = (ResizeWindowListener)iterator.next();
            resizeWindowListener.windowResized(resizeWindowEvent);
        }
    }

    protected void fireTerminalTextScrolledEvent(TextScrolledEvent textScrolledEvent) {
        if (this.textScrolledListeners == null) {
            return;
        }
        Iterator iterator = this.textScrolledListeners.iterator();
        while (iterator.hasNext()) {
            TextScrolledListener textScrolledListener = (TextScrolledListener)iterator.next();
            textScrolledListener.textScrolled(textScrolledEvent);
        }
    }

    public void addListener(TerminalListener terminalListener) {
        int n = Widget.findListener((Vector)this.terminalListeners, (Object)terminalListener);
        if (n == -1) {
            if (this.terminalListeners == null) {
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.CHILD_EXITED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.SELECTION_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.CONTENTS_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.CURSOR_MOVED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.DECREASE_FONT_SIZE);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.DEICONIFY_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.EMULATION_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.ENCODING_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.EOF);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.ICON_TITLE_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.ICONIFY_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.INCREASE_FONT_SIZE);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.LOWER_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.MAXIMIZE_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.RAISE_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.REFRESH_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.RESTORE_WINDOW);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.STATUS_LINE_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_DELETED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_INSERTED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_MODIFIED);
                evtMap.initialize((GObject)this, (EventType)TerminalEvent.Type.WINDOW_TITLE_CHANGED);
                this.terminalListeners = new Vector();
            }
            this.terminalListeners.addElement(terminalListener);
        }
    }

    public void removeListener(TerminalListener terminalListener) {
        int n = Widget.findListener((Vector)this.terminalListeners, (Object)terminalListener);
        if (n > -1) {
            this.terminalListeners.remove(n);
        }
        if (this.terminalListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.CHILD_EXITED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.SELECTION_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.CONTENTS_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.CURSOR_MOVED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.DECREASE_FONT_SIZE);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.DEICONIFY_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.EMULATION_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.ENCODING_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.EOF);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.ICON_TITLE_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.ICONIFY_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.INCREASE_FONT_SIZE);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.LOWER_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.MAXIMIZE_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.RAISE_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.REFRESH_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.RESTORE_WINDOW);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.STATUS_LINE_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_DELETED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_INSERTED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.TEXT_MODIFIED);
            evtMap.uninitialize((GObject)this, (EventType)TerminalEvent.Type.WINDOW_TITLE_CHANGED);
            this.terminalListeners = null;
        }
    }

    public void addListener(CommitListener commitListener) {
        int n = Widget.findListener((Vector)this.commitListeners, (Object)commitListener);
        if (n == -1) {
            if (this.commitListeners == null) {
                evtMap.initialize((GObject)this, (EventType)CommitEvent.Type.COMMIT);
                this.commitListeners = new Vector();
            }
            this.commitListeners.addElement(commitListener);
        }
    }

    public void removeListener(CommitListener commitListener) {
        int n = Widget.findListener((Vector)this.commitListeners, (Object)commitListener);
        if (n > -1) {
            this.commitListeners.remove(n);
        }
        if (this.commitListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)CommitEvent.Type.COMMIT);
            this.commitListeners = null;
        }
    }

    public void addListener(CharacterSizeChangedListener characterSizeChangedListener) {
        int n = Widget.findListener((Vector)this.characterSizeChangeListeners, (Object)characterSizeChangedListener);
        if (n == -1) {
            if (this.characterSizeChangeListeners == null) {
                evtMap.initialize((GObject)this, (EventType)CharacterSizeChangedEvent.Type.CHAR_SIZE_CHANGED);
                this.characterSizeChangeListeners = new Vector();
            }
            this.characterSizeChangeListeners.addElement(characterSizeChangedListener);
        }
    }

    public void removeListener(CharacterSizeChangedListener characterSizeChangedListener) {
        int n = Widget.findListener((Vector)this.characterSizeChangeListeners, (Object)characterSizeChangedListener);
        if (n > -1) {
            this.characterSizeChangeListeners.remove(n);
        }
        if (this.characterSizeChangeListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)CharacterSizeChangedEvent.Type.CHAR_SIZE_CHANGED);
            this.characterSizeChangeListeners = null;
        }
    }

    public void addListener(MoveWindowListener moveWindowListener) {
        int n = Widget.findListener((Vector)this.moveWindowListeners, (Object)moveWindowListener);
        if (n == -1) {
            if (this.moveWindowListeners == null) {
                evtMap.initialize((GObject)this, (EventType)MoveWindowEvent.Type.MOVE_WINDOW);
                this.moveWindowListeners = new Vector();
            }
            this.moveWindowListeners.addElement(moveWindowListener);
        }
    }

    public void removeListener(MoveWindowListener moveWindowListener) {
        int n = Widget.findListener((Vector)this.moveWindowListeners, (Object)moveWindowListener);
        if (n > -1) {
            this.moveWindowListeners.remove(n);
        }
        if (this.moveWindowListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)MoveWindowEvent.Type.MOVE_WINDOW);
            this.moveWindowListeners = null;
        }
    }

    public void addListener(ResizeWindowListener resizeWindowListener) {
        int n = Widget.findListener((Vector)this.resizeWindowListeners, (Object)resizeWindowListener);
        if (n == -1) {
            if (this.resizeWindowListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ResizeWindowEvent.Type.RESIZE_WINDOW);
                this.resizeWindowListeners = new Vector();
            }
            this.resizeWindowListeners.addElement(resizeWindowListener);
        }
    }

    public void removeListener(ResizeWindowListener resizeWindowListener) {
        int n = Widget.findListener((Vector)this.resizeWindowListeners, (Object)resizeWindowListener);
        if (n > -1) {
            this.resizeWindowListeners.remove(n);
        }
        if (this.resizeWindowListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ResizeWindowEvent.Type.RESIZE_WINDOW);
            this.resizeWindowListeners = null;
        }
    }

    public void addListener(TextScrolledListener textScrolledListener) {
        int n = Widget.findListener((Vector)this.textScrolledListeners, (Object)textScrolledListener);
        if (n == -1) {
            if (this.textScrolledListeners == null) {
                evtMap.initialize((GObject)this, (EventType)TextScrolledEvent.Type.TEXT_SCROLLED);
                this.textScrolledListeners = new Vector();
            }
            this.textScrolledListeners.addElement(textScrolledListener);
        }
    }

    public void removeListener(TextScrolledListener textScrolledListener) {
        int n = Widget.findListener((Vector)this.textScrolledListeners, (Object)textScrolledListener);
        if (n > -1) {
            this.textScrolledListeners.remove(n);
        }
        if (this.textScrolledListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TextScrolledEvent.Type.TEXT_SCROLLED);
            this.textScrolledListeners = null;
        }
    }

    private void handleChildExited() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.CHILD_EXITED));
    }

    private void handleSelectionChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.SELECTION_CHANGED));
    }

    private void handleCommit(String string, int n) {
        CommitEvent commitEvent = new CommitEvent((Object)this, CommitEvent.Type.COMMIT, string);
        this.fireTerminalCommitEvent(commitEvent);
    }

    private void handleCharSizeChanged(int n, int n2) {
        CharacterSizeChangedEvent characterSizeChangedEvent = new CharacterSizeChangedEvent((Object)this, CharacterSizeChangedEvent.Type.CHAR_SIZE_CHANGED, n, n2);
        this.fireTerminalCharacterSizeChangedEvent(characterSizeChangedEvent);
    }

    private void handleContentsChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.CONTENTS_CHANGED));
    }

    private void handleCursorMoved() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.CURSOR_MOVED));
    }

    private void handleDecreaseFontSize() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.DECREASE_FONT_SIZE));
    }

    private void handleDeiconifyWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.DEICONIFY_WINDOW));
    }

    private void handleEmulationChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.EMULATION_CHANGED));
    }

    private void handleEncodingChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.ENCODING_CHANGED));
    }

    private void handleEof() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.EOF));
    }

    private void handleIconTitleChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.ICON_TITLE_CHANGED));
    }

    private void handleIconifyWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.ICONIFY_WINDOW));
    }

    private void handleIncreaseFontSize() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.INCREASE_FONT_SIZE));
    }

    private void handleLowerWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.LOWER_WINDOW));
    }

    private void handleMaximizeWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.MAXIMIZE_WINDOW));
    }

    private void handleMoveWindow(int n, int n2) {
        MoveWindowEvent moveWindowEvent = new MoveWindowEvent((Object)this, MoveWindowEvent.Type.MOVE_WINDOW, n, n2);
        this.fireTerminalMoveWindowEvent(moveWindowEvent);
    }

    private void handleRaiseWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.RAISE_WINDOW));
    }

    private void handleRefreshWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.REFRESH_WINDOW));
    }

    private void handleResizeWindow(int n, int n2) {
        ResizeWindowEvent resizeWindowEvent = new ResizeWindowEvent((Object)this, ResizeWindowEvent.Type.RESIZE_WINDOW, n, n2);
        this.fireTerminalResizeWindowEvent(resizeWindowEvent);
    }

    private void handleRestoreWindow() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.RESTORE_WINDOW));
    }

    private void handleStatusLineChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.STATUS_LINE_CHANGED));
    }

    private void handleTextDeleted() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.TEXT_DELETED));
    }

    private void handleTextInserted() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.TEXT_INSERTED));
    }

    private void handleTextModified() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.TEXT_MODIFIED));
    }

    private void handleTextScrolled(int n) {
        TextScrolledEvent textScrolledEvent = new TextScrolledEvent((Object)this, TextScrolledEvent.Type.TEXT_SCROLLED, n);
        this.fireTerminalTextScrolledEvent(textScrolledEvent);
    }

    private void handleWindowTitleChanged() {
        this.fireTerminalEvent(new TerminalEvent((Object)this, TerminalEvent.Type.WINDOW_TITLE_CHANGED));
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("child-exited", "handleChildExited", (EventType)TerminalEvent.Type.CHILD_EXITED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("selection-changed", "handleSelectionChanged", (EventType)TerminalEvent.Type.SELECTION_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("contents-changed", "handleContentsChanged", (EventType)TerminalEvent.Type.CONTENTS_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("cursor-moved", "handleCursorMoved", (EventType)TerminalEvent.Type.CURSOR_MOVED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("decrease-font-size", "handleDecreaseFontSize", (EventType)TerminalEvent.Type.DECREASE_FONT_SIZE, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("deiconify-window", "handleDeiconifyWindow", (EventType)TerminalEvent.Type.DEICONIFY_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("emulation-changed", "handleEmulationChanged", (EventType)TerminalEvent.Type.EMULATION_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("encoding-changed", "handleEncodingChanged", (EventType)TerminalEvent.Type.ENCODING_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("eof", "handleEof", (EventType)TerminalEvent.Type.EOF, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("icon-title-changed", "handleIconTitleChanged", (EventType)TerminalEvent.Type.ICON_TITLE_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("iconify-window", "handleIconifyWindow", (EventType)TerminalEvent.Type.ICONIFY_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("increase-font-size", "handleIncreaseFontSize", (EventType)TerminalEvent.Type.INCREASE_FONT_SIZE, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("lower-window", "handleLowerWindow", (EventType)TerminalEvent.Type.LOWER_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("maximize-window", "handleMaximizeWindow", (EventType)TerminalEvent.Type.MAXIMIZE_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("raise-window", "handleRaiseWindow", (EventType)TerminalEvent.Type.RAISE_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("refresh-window", "handleRefreshWindow", (EventType)TerminalEvent.Type.REFRESH_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("restore-window", "handleRestoreWindow", (EventType)TerminalEvent.Type.RESTORE_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("status-line-changed", "handleStatusLineChanged", (EventType)TerminalEvent.Type.STATUS_LINE_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("text-deleted", "handleTextDeleted", (EventType)TerminalEvent.Type.TEXT_DELETED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("text-inserted", "handleTextInserted", (EventType)TerminalEvent.Type.TEXT_INSERTED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("window-title-changed", "handleWindowTitleChanged", (EventType)TerminalEvent.Type.WINDOW_TITLE_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("text-modified", "handleTextModified", (EventType)TerminalEvent.Type.TEXT_MODIFIED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("commit", "handleCommit", (EventType)CommitEvent.Type.COMMIT, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("char-size-changed", "handleCharSizeChanged", (EventType)CharacterSizeChangedEvent.Type.CHAR_SIZE_CHANGED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("move-window", "handleMoveWindow", (EventType)MoveWindowEvent.Type.MOVE_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("resize-window", "handleResizeWindow", (EventType)ResizeWindowEvent.Type.RESIZE_WINDOW, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
        eventMap.addEvent("text-scrolled", "handleTextScrolled", (EventType)TextScrolledEvent.Type.TEXT_SCROLLED, Terminal.class$("org.gnu.gnomevte.event.TerminalListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static native Handle vte_terminal_new();

    static native int vte_terminal_fork_command(Handle var0, String var1, String[] var2, String var3, boolean var4, boolean var5, boolean var6);

    static native void vte_terminal_set_pty(Handle var0, int var1);

    static native void vte_terminal_feed(Handle var0, String var1, int var2);

    static native void vte_terminal_feed_child(Handle var0, String var1, long var2);

    static native void vte_terminal_copy_clipboard(Handle var0);

    static native void vte_terminal_paste_clipboard(Handle var0);

    static native void vte_terminal_copy_primary(Handle var0);

    static native void vte_terminal_paste_primary(Handle var0);

    static native void vte_terminal_set_size(Handle var0, int var1, int var2);

    static native void vte_terminal_set_audible_bell(Handle var0, boolean var1);

    static native boolean vte_terminal_get_audible_bell(Handle var0);

    static native void vte_terminal_set_visible_bell(Handle var0, boolean var1);

    static native boolean vte_terminal_get_visible_bell(Handle var0);

    static native void vte_terminal_set_scroll_on_output(Handle var0, boolean var1);

    static native void vte_terminal_set_scroll_on_keystroke(Handle var0, boolean var1);

    static native void vte_terminal_set_color_dim(Handle var0, Handle var1);

    static native void vte_terminal_set_color_bold(Handle var0, Handle var1);

    static native void vte_terminal_set_color_foreground(Handle var0, Handle var1);

    static native void vte_terminal_set_color_background(Handle var0, Handle var1);

    static native void vte_terminal_set_colors(Handle var0, Handle var1, Handle var2, Handle var3, int var4);

    static native void vte_terminal_set_default_colors(Handle var0);

    static native void vte_terminal_set_background_image(Handle var0, Handle var1);

    static native void vte_terminal_set_background_image_file(Handle var0, String var1);

    static native void vte_terminal_set_background_saturation(Handle var0, double var1);

    static native void vte_terminal_set_background_transparent(Handle var0, boolean var1);

    static native void vte_terminal_set_cursor_blinks(Handle var0, boolean var1);

    static native void vte_terminal_set_scrollback_lines(Handle var0, int var1);

    static native void vte_terminal_set_font(Handle var0, Handle var1);

    static native Handle vte_terminal_get_font(Handle var0);

    static native void vte_terminal_set_allow_bold(Handle var0, boolean var1);

    static native boolean vte_terminal_get_allow_bold(Handle var0);

    static native boolean vte_terminal_get_has_selection(Handle var0);

    static native void vte_terminal_reset(Handle var0, boolean var1, boolean var2);

    static native void vte_terminal_set_emulation(Handle var0, String var1);

    static native String vte_terminal_get_emulation(Handle var0);

    static native void vte_terminal_set_encoding(Handle var0, String var1);

    static native String vte_terminal_get_encoding(Handle var0);

    static native String vte_terminal_get_status_line(Handle var0);

    static native Handle vte_terminal_get_adjustment(Handle var0);

    static {
        System.loadLibrary("vtejni-0.12");
        evtMap = new EventMap();
        Terminal.addEvents(evtMap);
    }
}

