#!/bin/bash
#
# A small script to help run example apps
#

prefix=/usr
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
classpath=${jardir}/gtk2.10-2.10.2.jar

GTK_LIB=$libdir
GTK_JAR=$classpath

# You should not need to modify anything below here

error_message ()
{
	echo
	echo
	echo "Usage: ./runExample.sh CLASSNAME [ARGS]"
	echo "Please first ensure you have a valid java interpreter and compiler" 
	echo "in your \$PATH and you have compiled java-gnome libraries and jars, then" 
	echo "run an application by passing it's classname to this script, e.g.:"
	echo
	echo "$0 progressbar/ProgressBarTest"
	echo
	exit 1;
}

NEED_LIB="$GTK_LIB"
NEED_JAR="$GTK_JAR  /usr/share/java/cairo1.0-1.0.8.jar /usr/share/java/glib0.4-0.4.2.jar"

echo "Java-Gnome Example Application Launcher"
echo

echo "Checking for jvm and compiler availability..."

TESTGCJ="`which gcj 2> /dev/null`"
TESTGCJ="`basename "$TESTGCJ"`"
TESTKJC="`which kjc 2> /dev/null`"
TESTKJC="`basename "$TESTKJC"`"
TESTJAVAC="`which javac 2> /dev/null`"
TESTJAVAC="`basename "$TESTJAVAC"`"

if [ "$TESTGCJ" == "gcj" ]; then
	JAVAC="gcj -C"
elif [ "$TESTKJC" == "kjc" ]; then
	JAVAC=kjc
elif [ "$TESTJAVAC" == "javac" ]; then
	JAVAC=javac
else
	echo "ERROR: no valid compiler was found in your \$PATH"
	error_message
fi

TESTGIJ="`which gij 2> /dev/null`"
TESTGIJ="`basename "$TESTGIJ"`"
TESTKAFFE="`which kaffe 2> /dev/null`"
TESTKAFFE="`basename "$TESTKAFFE"`"
TESTJAVA="`which java 2> /dev/null`"
TESTJAVA="`basename "$TESTJAVA"`"

#Try to use gij first, then java
if [ "$TESTGIJ" == "gij" ]; then
	JAVA=gij
elif [ "$TESTKAFFE" == "kaffe" ]; then
	JAVA=kaffe
elif [ "$TESTJAVA" == "java" ]; then
	JAVA=java
else
	echo "ERROR: no valid interpreter was found in your \$PATH"
	error_message
fi

echo "	`echo $JAVAC | awk '{print $1}'` and $JAVA - appear to be ok"

#Praise the users who use Free Software
if [ "$JAVAC" == "gcj -C" -a "$JAVA" == "gij" ]; then
	echo
	echo "	You are using Open Source java" 
	echo "	virtual machine and compiler: this is so good!"
elif [ "$JAVAC" == "kjc" -a "$JAVA" == "kaffe" ]; then
	echo
	echo "  You are using Open Source java"
	echo "  virtual machine and compiler: this is so good!"
fi

echo
echo "Checking if library paths exist..."

for NEEDLIB in $NEED_LIB; do
	if test -e $NEEDLIB; then echo "	$NEEDLIB - appears to be ok"; fi;
	if ! test -e $NEEDLIB; then echo "	$NEEDLIB - DOES NOT EXIST" && error_message; fi;
done;

echo
echo "Testing JAR archives..."
for JAR in $NEED_JAR; do
	if test -e $JAR; then
		echo "	$JAR - appears to be ok";
	else
		echo "	$JAR - DOES NOT EXIST";
	error_message
	fi;
done;

echo

if ! test -e $1.java ; then
	echo "ERROR: unexpected example app";
	echo
	error_message
fi

#do the real work
export CLASSPATH=.:$CLASSPATH:`echo $NEED_JAR | sed s'/ /:/g'`
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:`echo $NEED_LIB | sed s'/ /:/g'`

($JAVAC $1.java && echo "Compilation successful") || (echo "ERROR: Compilation failed"; error_message)

TARGET=`echo $1 | sed 's/\//\./g'`
shift
($JAVA $TARGET $@ && echo "Application successfully terminated") || (echo
"Application terminated abnormally"; error_message)
