/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pango;

import org.gnu.glib.Boxed;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.pango.Alignment;
import org.gnu.pango.AttrList;
import org.gnu.pango.Context;
import org.gnu.pango.FontDescription;
import org.gnu.pango.LayoutLine;
import org.gnu.pango.Rectangle;
import org.gnu.pango.TabArray;
import org.gnu.pango.WrapMode;

public class Layout
extends GObject {
    public Layout(Context context) {
        super(Layout.pango_layout_new(context.getHandle()));
    }

    public Layout(Layout layout) {
        super(Layout.pango_layout_copy(layout.getHandle()));
    }

    public Layout(Handle handle) {
        super(handle);
    }

    public static Layout getLayoutFromHandle(Handle handle) {
        if (handle == null) {
            return null;
        }
        Layout layout = (Layout)GObject.getGObjectFromHandle((Handle)handle);
        if (layout == null) {
            layout = new Layout(handle);
        }
        return layout;
    }

    public Context getContext() {
        Handle handle = Layout.pango_layout_get_context(this.getHandle());
        return Context.getContextFromHandle(handle);
    }

    public void contextChanged() {
        Layout.pango_layout_context_changed(this.getHandle());
    }

    public void setText(String string) {
        Layout.pango_layout_set_text(this.getHandle(), string, string.length());
    }

    public String getText() {
        return Layout.pango_layout_get_text(this.getHandle());
    }

    public void setMarkup(String string, char c) {
        Layout.pango_layout_set_markup_with_accel(this.getHandle(), string, string.length(), (byte)c, (byte)48);
    }

    public void setMarkup(String string) {
        Layout.pango_layout_set_markup(this.getHandle(), string, string.length());
    }

    public void setAttributes(AttrList attrList) {
        Layout.pango_layout_set_attributes(this.getHandle(), attrList.getHandle());
    }

    public AttrList getAttributes() {
        Handle handle = Layout.pango_layout_get_attributes(this.getHandle());
        return AttrList.getAttrListFromHandle(handle);
    }

    public void setFontDescription(FontDescription fontDescription) {
        Layout.pango_layout_set_font_description(this.getHandle(), fontDescription.getHandle());
    }

    public void setWidth(int n) {
        Layout.pango_layout_set_width(this.getHandle(), n);
    }

    public int getWidth() {
        return Layout.pango_layout_get_width(this.getHandle());
    }

    public void setWrapStyle(WrapMode wrapMode) {
        this.setWrap(wrapMode);
    }

    public WrapMode getWrapMode() {
        return this.getWrap();
    }

    public void setWrap(WrapMode wrapMode) {
        Layout.pango_layout_set_wrap(this.getHandle(), wrapMode.getValue());
    }

    public WrapMode getWrap() {
        return WrapMode.intern(Layout.pango_layout_get_wrap(this.getHandle()));
    }

    public void setIndent(int n) {
        Layout.pango_layout_set_indent(this.getHandle(), n);
    }

    public int getIndent() {
        return Layout.pango_layout_get_indent(this.getHandle());
    }

    public int getSpacing() {
        return Layout.pango_layout_get_spacing(this.getHandle());
    }

    public void setSpacing(int n) {
        Layout.pango_layout_set_spacing(this.getHandle(), n);
    }

    public void setJustification(boolean bl) {
        this.setJustify(bl);
    }

    public boolean getJustified() {
        return this.getJustify();
    }

    public void setJustify(boolean bl) {
        Layout.pango_layout_set_justify(this.getHandle(), bl);
    }

    public boolean getJustify() {
        return Layout.pango_layout_get_justify(this.getHandle());
    }

    public void setAlignment(Alignment alignment) {
        Layout.pango_layout_set_alignment(this.getHandle(), alignment.getValue());
    }

    public Alignment getAlignment() {
        return Alignment.intern(Layout.pango_layout_get_alignment(this.getHandle()));
    }

    public void setTabs(TabArray tabArray) {
        Layout.pango_layout_set_tabs(this.getHandle(), tabArray.getHandle());
    }

    public TabArray getTabs() {
        Handle handle = Layout.pango_layout_get_tabs(this.getHandle());
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed == null) {
                return new TabArray(handle);
            }
            return (TabArray)boxed;
        }
        return null;
    }

    public void setSingleParagraphMode(boolean bl) {
        Layout.pango_layout_set_single_paragraph_mode(this.getHandle(), bl);
    }

    public boolean getSingleParagraphMode() {
        return Layout.pango_layout_get_single_paragraph_mode(this.getHandle());
    }

    public int getLineCount() {
        return Layout.pango_layout_get_line_count(this.getHandle());
    }

    public LayoutLine getLine(int n) {
        Handle handle = Layout.pango_layout_get_line(this.getHandle(), n);
        if (handle != null) {
            MemStruct memStruct = MemStruct.getMemStructFromHandle((Handle)handle);
            if (memStruct == null) {
                return new LayoutLine(handle);
            }
            return (LayoutLine)memStruct;
        }
        return null;
    }

    public Rectangle indexToPos(int n) {
        return Rectangle.getRectangleFromHandle(Layout.pango_layout_index_to_pos(this.getHandle(), n));
    }

    public Rectangle getStrongCursorPosition(int n) {
        return Rectangle.getRectangleFromHandle(Layout.pango_layout_get_cursor_pos_strong(this.getHandle(), n));
    }

    public Rectangle getWeakCursorPosition(int n) {
        return Rectangle.getRectangleFromHandle(Layout.pango_layout_get_cursor_pos_weak(this.getHandle(), n));
    }

    public int getHeight() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Layout.pango_layout_get_size(this.getHandle(), nArray, nArray2);
        return nArray2[0];
    }

    public int getPixelWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Layout.pango_layout_get_pixel_size(this.getHandle(), nArray, nArray2);
        return nArray[0];
    }

    public int getPixelHeight() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Layout.pango_layout_get_pixel_size(this.getHandle(), nArray, nArray2);
        return nArray2[0];
    }

    protected static final native int pango_layout_get_type();

    protected static final native Handle pango_layout_new(Handle var0);

    protected static final native Handle pango_layout_copy(Handle var0);

    protected static final native Handle pango_layout_get_context(Handle var0);

    protected static final native void pango_layout_set_attributes(Handle var0, Handle var1);

    protected static final native Handle pango_layout_get_attributes(Handle var0);

    protected static final native void pango_layout_set_text(Handle var0, String var1, int var2);

    protected static final native String pango_layout_get_text(Handle var0);

    protected static final native void pango_layout_set_markup(Handle var0, String var1, int var2);

    protected static final native void pango_layout_set_markup_with_accel(Handle var0, String var1, int var2, byte var3, byte var4);

    protected static final native void pango_layout_set_font_description(Handle var0, Handle var1);

    protected static final native void pango_layout_set_width(Handle var0, int var1);

    protected static final native int pango_layout_get_width(Handle var0);

    protected static final native void pango_layout_set_wrap(Handle var0, int var1);

    protected static final native int pango_layout_get_wrap(Handle var0);

    protected static final native void pango_layout_set_indent(Handle var0, int var1);

    protected static final native int pango_layout_get_indent(Handle var0);

    protected static final native void pango_layout_set_spacing(Handle var0, int var1);

    protected static final native int pango_layout_get_spacing(Handle var0);

    protected static final native void pango_layout_set_justify(Handle var0, boolean var1);

    protected static final native boolean pango_layout_get_justify(Handle var0);

    protected static final native void pango_layout_set_alignment(Handle var0, int var1);

    protected static final native int pango_layout_get_alignment(Handle var0);

    protected static final native void pango_layout_set_tabs(Handle var0, Handle var1);

    protected static final native Handle pango_layout_get_tabs(Handle var0);

    protected static final native void pango_layout_set_single_paragraph_mode(Handle var0, boolean var1);

    protected static final native boolean pango_layout_get_single_paragraph_mode(Handle var0);

    protected static final native void pango_layout_context_changed(Handle var0);

    protected static final native Handle pango_layout_index_to_pos(Handle var0, int var1);

    protected static final native Handle pango_layout_get_cursor_pos_strong(Handle var0, int var1);

    protected static final native Handle pango_layout_get_cursor_pos_weak(Handle var0, int var1);

    protected static final native void pango_layout_move_cursor_visually(Handle var0, boolean var1, int var2, int var3, int var4, int[] var5, int[] var6);

    protected static final native boolean pango_layout_xy_to_index(Handle var0, int var1, int var2, int[] var3, int[] var4);

    protected static final native void pango_layout_get_extents(Handle var0, Handle var1, Handle var2);

    protected static final native void pango_layout_get_pixel_extents(Handle var0, Handle var1, Handle var2);

    protected static final native void pango_layout_get_size(Handle var0, int[] var1, int[] var2);

    protected static final native void pango_layout_get_pixel_size(Handle var0, int[] var1, int[] var2);

    protected static final native int pango_layout_get_line_count(Handle var0);

    protected static final native Handle pango_layout_get_line(Handle var0, int var1);
}

