/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pango;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.pango.FontMask;
import org.gnu.pango.Stretch;
import org.gnu.pango.Style;
import org.gnu.pango.Variant;
import org.gnu.pango.Weight;

public class FontDescription
extends Boxed {
    public FontDescription(Handle handle) {
        super(handle);
    }

    public FontDescription() {
        super(FontDescription.pango_font_description_new());
    }

    public FontDescription(String string) {
        super(FontDescription.pango_font_description_from_string(string));
    }

    public FontDescription(FontDescription fontDescription) {
        super(FontDescription.pango_font_description_copy(fontDescription.getHandle()));
    }

    public void setFamily(String string) {
        FontDescription.pango_font_description_set_family(this.getHandle(), string);
    }

    public String getFamily() {
        return FontDescription.pango_font_description_get_family(this.getHandle());
    }

    public void setStyle(Style style) {
        FontDescription.pango_font_description_set_style(this.getHandle(), style.getValue());
    }

    public Style getStyle() {
        return Style.intern(FontDescription.pango_font_description_get_style(this.getHandle()));
    }

    public void setVariant(Variant variant) {
        FontDescription.pango_font_description_set_variant(this.getHandle(), variant.getValue());
    }

    public Variant getVariant() {
        return Variant.intern(FontDescription.pango_font_description_get_variant(this.getHandle()));
    }

    public void setWeight(Weight weight) {
        FontDescription.pango_font_description_set_weight(this.getHandle(), weight.getValue());
    }

    public Weight getWeight() {
        return Weight.intern(FontDescription.pango_font_description_get_weight(this.getHandle()));
    }

    public void setStretch(Stretch stretch) {
        FontDescription.pango_font_description_set_stretch(this.getHandle(), stretch.getValue());
    }

    public Stretch getStretch() {
        return Stretch.intern(FontDescription.pango_font_description_get_stretch(this.getHandle()));
    }

    public void setSize(int n) {
        FontDescription.pango_font_description_set_size(this.getHandle(), n);
    }

    public int getSize() {
        return FontDescription.pango_font_description_get_size(this.getHandle());
    }

    public FontMask getSetFields() {
        return FontMask.intern(FontDescription.pango_font_description_get_set_fields(this.getHandle()));
    }

    public void replace(FontDescription fontDescription, boolean bl) {
        FontDescription.pango_font_description_merge(this.getHandle(), fontDescription.getHandle(), bl);
    }

    public String toString() {
        return FontDescription.pango_font_description_to_string(this.getHandle());
    }

    public int hash() {
        return FontDescription.pango_font_description_hash(this.getHandle());
    }

    public boolean equal(FontDescription fontDescription) {
        return FontDescription.pango_font_description_equal(this.getHandle(), fontDescription.getHandle());
    }

    public void unsetFields(FontMask fontMask) {
        FontDescription.pango_font_description_unset_fields(this.getHandle(), fontMask.getValue());
    }

    public boolean betterMatch(FontDescription fontDescription, FontDescription fontDescription2) {
        return FontDescription.pango_font_description_better_match(this.getHandle(), fontDescription.getHandle(), fontDescription2.getHandle());
    }

    public String toFilename() {
        return FontDescription.pango_font_description_to_filename(this.getHandle());
    }

    static FontDescription getFontDescriptionFromHandle(Handle handle) {
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed != null) {
                return (FontDescription)boxed;
            }
            return new FontDescription(handle);
        }
        return null;
    }

    protected static final native int pango_font_description_get_type();

    protected static final native Handle pango_font_description_new();

    protected static final native Handle pango_font_description_copy(Handle var0);

    protected static final native int pango_font_description_hash(Handle var0);

    protected static final native boolean pango_font_description_equal(Handle var0, Handle var1);

    protected static final native void pango_font_description_set_family(Handle var0, String var1);

    protected static final native String pango_font_description_get_family(Handle var0);

    protected static final native void pango_font_description_set_style(Handle var0, int var1);

    protected static final native int pango_font_description_get_style(Handle var0);

    protected static final native void pango_font_description_set_variant(Handle var0, int var1);

    protected static final native int pango_font_description_get_variant(Handle var0);

    protected static final native void pango_font_description_set_weight(Handle var0, int var1);

    protected static final native int pango_font_description_get_weight(Handle var0);

    protected static final native void pango_font_description_set_stretch(Handle var0, int var1);

    protected static final native int pango_font_description_get_stretch(Handle var0);

    protected static final native void pango_font_description_set_size(Handle var0, int var1);

    protected static final native int pango_font_description_get_size(Handle var0);

    protected static final native int pango_font_description_get_set_fields(Handle var0);

    protected static final native void pango_font_description_unset_fields(Handle var0, int var1);

    protected static final native void pango_font_description_merge(Handle var0, Handle var1, boolean var2);

    protected static final native boolean pango_font_description_better_match(Handle var0, Handle var1, Handle var2);

    protected static final native Handle pango_font_description_from_string(String var0);

    protected static final native String pango_font_description_to_string(Handle var0);

    protected static final native String pango_font_description_to_filename(Handle var0);
}

