/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pango;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.glib.Type;
import org.gnu.pango.Coverage;
import org.gnu.pango.FontDescription;
import org.gnu.pango.FontMetrics;
import org.gnu.pango.Language;

public class Font
extends GObject {
    public Font() {
        super(Font.getType());
    }

    public FontDescription describe() {
        return FontDescription.getFontDescriptionFromHandle(Font.pango_font_describe(this.getHandle()));
    }

    public Coverage getCoverage(Language language) {
        Handle handle = Font.pango_font_get_coverage(this.getHandle(), language.getHandle());
        if (handle != null) {
            MemStruct memStruct = MemStruct.getMemStructFromHandle((Handle)handle);
            if (memStruct != null) {
                return (Coverage)memStruct;
            }
            return new Coverage(handle);
        }
        return null;
    }

    public FontMetrics getMetrics(Language language) {
        return FontMetrics.getFontMetricsFromHandle(Font.pango_font_get_metrics(this.getHandle(), language.getHandle()));
    }

    public static Type getType() {
        return new Type(Font.pango_font_get_type());
    }

    protected static final native int pango_font_get_type();

    protected static final native Handle pango_font_describe(Handle var0);

    protected static final native Handle pango_font_get_coverage(Handle var0, Handle var1);

    protected static final native Handle pango_font_get_metrics(Handle var0, Handle var1);
}

