/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pango;

import org.gnu.glib.Boxed;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.pango.Direction;
import org.gnu.pango.FontDescription;
import org.gnu.pango.FontFamily;
import org.gnu.pango.FontMetrics;
import org.gnu.pango.Language;

public class Context
extends GObject {
    public Context(Handle handle) {
        super(handle);
    }

    public static Context getContextFromHandle(Handle handle) {
        if (handle == null) {
            return null;
        }
        Context context = (Context)GObject.getGObjectFromHandle((Handle)handle);
        if (context == null) {
            context = new Context(handle);
        }
        return context;
    }

    public FontDescription getFontDescription() {
        return FontDescription.getFontDescriptionFromHandle(Context.pango_context_get_font_description(this.getHandle()));
    }

    public void setFontDescription(FontDescription fontDescription) {
        Context.pango_context_set_font_description(this.getHandle(), fontDescription.getHandle());
    }

    public Language getLanguage() {
        Handle handle = Context.pango_context_get_language(this.getHandle());
        if (handle != null) {
            Boxed boxed = Boxed.getBoxedFromHandle((Handle)handle);
            if (boxed != null) {
                return (Language)boxed;
            }
            return new Language(handle);
        }
        return null;
    }

    public void setLanguage(Language language) {
        Context.pango_context_set_language(this.getHandle(), language.getHandle());
    }

    public Direction getBaseDir() {
        return Direction.intern(Context.pango_context_get_base_dir(this.getHandle()));
    }

    public void setBaseDir(Direction direction) {
        Context.pango_context_set_base_dir(this.getHandle(), direction.getValue());
    }

    public FontDescription loadFont(FontDescription fontDescription) {
        return FontDescription.getFontDescriptionFromHandle(Context.pango_context_load_font(this.getHandle(), fontDescription.getHandle()));
    }

    public FontMetrics getMetrics(FontDescription fontDescription, Language language) {
        return FontMetrics.getFontMetricsFromHandle(Context.pango_context_get_metrics(this.getHandle(), fontDescription.getHandle(), language.getHandle()));
    }

    public FontFamily[] listFamilies() {
        Handle[] handleArray = Context.pango_context_list_families(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        FontFamily[] fontFamilyArray = new FontFamily[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            fontFamilyArray[i] = GObject.getGObjectFromHandle((Handle)handleArray[i]) == null ? new FontFamily(handleArray[i]) : (FontFamily)GObject.getGObjectFromHandle((Handle)handleArray[i]);
        }
        return fontFamilyArray;
    }

    protected static final native int pango_context_get_type();

    protected static final native Handle[] pango_context_list_families(Handle var0);

    protected static final native Handle pango_context_load_font(Handle var0, Handle var1);

    protected static final native Handle pango_context_get_metrics(Handle var0, Handle var1, Handle var2);

    protected static final native void pango_context_set_font_description(Handle var0, Handle var1);

    protected static final native Handle pango_context_get_font_description(Handle var0);

    protected static final native Handle pango_context_get_language(Handle var0);

    protected static final native void pango_context_set_language(Handle var0, Handle var1);

    protected static final native void pango_context_set_base_dir(Handle var0, int var1);

    protected static final native int pango_context_get_base_dir(Handle var0);

    protected static final native boolean pango_context_load_fontNULL(Handle var0, Handle var1);
}

