/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk.event;

import org.gnu.gdk.Device;
import org.gnu.gdk.EventMotion;
import org.gnu.gdk.ModifierType;
import org.gnu.gdk.Window;
import org.gnu.glib.EventType;
import org.gnu.gtk.event.GtkEvent;

public class MouseMotionEvent
extends GtkEvent {
    private final Window window;
    private final boolean sendEvent;
    private final int timeMillis;
    private final double x;
    private final double y;
    private final ModifierType state;
    private final boolean isHint;
    private final Device device;
    private final double xRoot;
    private final double yRoot;

    public MouseMotionEvent(Object object, EventMotion eventMotion) {
        super(object, Type.MOTION);
        this.window = eventMotion.getWindow();
        this.sendEvent = eventMotion.getSendEvent();
        this.timeMillis = eventMotion.getTimeMillis();
        this.x = eventMotion.getX();
        this.y = eventMotion.getY();
        this.state = eventMotion.getState();
        this.isHint = eventMotion.isHint();
        this.device = eventMotion.getDevice();
        this.xRoot = eventMotion.getXRoot();
        this.yRoot = eventMotion.getYRoot();
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean getSendEvent() {
        return this.sendEvent;
    }

    public int getTimeMillis() {
        return this.timeMillis;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public ModifierType getState() {
        return this.state;
    }

    public boolean isHint() {
        return this.isHint;
    }

    public Device getDevice() {
        return this.device;
    }

    public double getXRoot() {
        return this.xRoot;
    }

    public double getYRoot() {
        return this.yRoot;
    }

    public boolean isOfType(Type type) {
        return this.type.getID() == type.getID();
    }

    public void refireIfHint() {
        if (this.isHint()) {
            this.window.getPointerWindow();
        }
    }

    public static class Type
    extends EventType {
        public static final Type MOTION = new Type(1, "MOTION");

        Type(int n, String string) {
            super(n, string);
        }
    }
}

