/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk.event;

import org.gnu.gdk.EventExpose;
import org.gnu.gdk.EventNoExpose;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Region;
import org.gnu.gdk.Window;
import org.gnu.glib.EventType;
import org.gnu.gtk.event.GtkEvent;

public class ExposeEvent
extends GtkEvent {
    private final Window window;
    private final boolean sendEvent;
    private final Rectangle area;
    private final Region region;
    private final int count;

    public ExposeEvent(Object object, EventExpose eventExpose) {
        super(object, Type.EXPOSE);
        this.window = eventExpose.getWindow();
        this.sendEvent = eventExpose.getSendEvent();
        this.area = eventExpose.getArea();
        this.region = eventExpose.getRegion();
        this.count = eventExpose.getCount();
    }

    public ExposeEvent(Object object, EventNoExpose eventNoExpose) {
        super(object, Type.NO_EXPOSE);
        this.window = eventNoExpose.getWindow();
        this.sendEvent = eventNoExpose.getSendEvent();
        this.area = null;
        this.region = null;
        this.count = -1;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean getSendEvent() {
        return this.sendEvent;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public Region getRegion() {
        return this.region;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isOfType(Type type) {
        return this.type.getID() == type.getID();
    }

    public static class Type
    extends EventType {
        public static final Type EXPOSE = new Type(1, "EXPOSE");
        public static final Type NO_EXPOSE = new Type(2, "NO_EXPOSE");

        Type(int n, String string) {
            super(n, string);
        }
    }
}

