/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Geometry;
import org.gnu.gdk.Gravity;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Point;
import org.gnu.gdk.Screen;
import org.gnu.gdk.WindowHints;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.Bin;
import org.gnu.gtk.ObjectDestroyedException;
import org.gnu.gtk.Requisition;
import org.gnu.gtk.Widget;
import org.gnu.gtk.WindowPosition;
import org.gnu.gtk.WindowType;

public class Window
extends Bin {
    private boolean destroyed;

    private /* synthetic */ void finit$() {
        this.destroyed = false;
    }

    public Window() {
        this(WindowType.TOPLEVEL);
    }

    public Window(WindowType windowType) {
        super(Window.gtk_window_new(windowType.getValue()));
        this.finit$();
    }

    public Window(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Window getWindow(Handle handle) {
        if (handle == null) {
            return null;
        }
        Window window = (Window)GObject.getGObjectFromHandle((Handle)handle);
        if (window == null) {
            window = new Window(handle);
        }
        return window;
    }

    public void setTitle(String string) {
        this.checkState();
        if (string != null) {
            Window.gtk_window_set_title(this.getHandle(), string);
        } else {
            Window.gtk_window_set_title(this.getHandle(), "");
        }
    }

    public String getTitle() {
        this.checkState();
        return Window.gtk_window_get_title(this.getHandle());
    }

    public void setResizable(boolean bl) {
        this.checkState();
        Window.gtk_window_set_resizable(this.getHandle(), bl);
    }

    public void addAccelGroup(AccelGroup accelGroup) {
        this.checkState();
        Window.gtk_window_add_accel_group(this.getHandle(), accelGroup.getHandle());
    }

    public void removeAccelGroup(AccelGroup accelGroup) {
        this.checkState();
        Window.gtk_window_remove_accel_group(this.getHandle(), accelGroup.getHandle());
    }

    public void setModal(boolean bl) {
        this.checkState();
        Window.gtk_window_set_modal(this.getHandle(), bl);
    }

    public void setDefaultSize(int n, int n2) {
        this.checkState();
        Window.gtk_window_set_default_size(this.getHandle(), n, n2);
    }

    public void setGeometryHints(Widget widget, Geometry geometry, WindowHints windowHints) {
        this.checkState();
        Window.gtk_window_set_geometry_hints(this.getHandle(), widget.getHandle(), geometry.getHandle(), windowHints.getValue());
    }

    public void setGravity(Gravity gravity) {
        this.checkState();
        Window.gtk_window_set_gravity(this.getHandle(), gravity.getValue());
    }

    public Gravity getGravity() {
        this.checkState();
        int n = Window.gtk_window_get_gravity(this.getHandle());
        return Gravity.intern(n);
    }

    public void setPosition(WindowPosition windowPosition) {
        this.checkState();
        Window.gtk_window_set_position(this.getHandle(), windowPosition.getValue());
    }

    public Widget getFocusWidget() {
        this.checkState();
        Handle handle = Window.gtk_window_get_focus(this.getHandle());
        return Widget.getWidget(handle);
    }

    public void setFocusWidget(Widget widget) {
        this.checkState();
        Window.gtk_window_set_focus(this.getHandle(), widget.getHandle());
    }

    public void setDefaultWidget(Widget widget) {
        this.checkState();
        Window.gtk_window_set_default(this.getHandle(), widget.getHandle());
    }

    public void present() {
        this.checkState();
        Window.gtk_window_present(this.getHandle());
    }

    public void iconify() {
        this.checkState();
        Window.gtk_window_iconify(this.getHandle());
    }

    public void deiconify() {
        this.checkState();
        Window.gtk_window_deiconify(this.getHandle());
    }

    public void stick() {
        this.checkState();
        Window.gtk_window_stick(this.getHandle());
    }

    public void unstick() {
        this.checkState();
        Window.gtk_window_unstick(this.getHandle());
    }

    public void maximize() {
        this.checkState();
        Window.gtk_window_maximize(this.getHandle());
    }

    public void unmaximize() {
        this.checkState();
        Window.gtk_window_unmaximize(this.getHandle());
    }

    public void setDecorated(boolean bl) {
        this.checkState();
        Window.gtk_window_set_decorated(this.getHandle(), bl);
    }

    public Requisition getSize() {
        this.checkState();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Window.gtk_window_get_size(this.getHandle(), nArray, nArray2);
        return new Requisition(nArray[0], nArray2[0]);
    }

    public Point getPosition() {
        this.checkState();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Window.gtk_window_get_position(this.getHandle(), nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public void move(int n, int n2) {
        this.checkState();
        Window.gtk_window_move(this.getHandle(), n, n2);
    }

    public void resize(int n, int n2) {
        this.checkState();
        Window.gtk_window_resize(this.getHandle(), n, n2);
    }

    public void setIcon(Pixbuf pixbuf) {
        this.checkState();
        Window.gtk_window_set_icon(this.getHandle(), pixbuf.getHandle());
    }

    public Pixbuf getIcon() {
        this.checkState();
        Handle handle = Window.gtk_window_get_icon(this.getHandle());
        return Pixbuf.getPixbufFromHandle(handle);
    }

    public void setIconList(Pixbuf[] pixbufArray) {
        this.checkState();
        Handle[] handleArray = new Handle[pixbufArray.length];
        for (int i = 0; i < pixbufArray.length; ++i) {
            handleArray[i] = pixbufArray[i].getHandle();
        }
        Window.gtk_window_set_icon_list(this.getHandle(), handleArray);
    }

    public Pixbuf[] getIconList() {
        this.checkState();
        Handle[] handleArray = Window.gtk_window_get_icon_list(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Pixbuf[] pixbufArray = new Pixbuf[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            pixbufArray[i] = Pixbuf.getPixbufFromHandle(handleArray[i]);
        }
        return pixbufArray;
    }

    public void setSkipTaskbarHint(boolean bl) {
        this.checkState();
        Window.gtk_window_set_skip_taskbar_hint(this.getHandle(), bl);
    }

    public boolean getSkipTaskbarHint() {
        this.checkState();
        return Window.gtk_window_get_skip_taskbar_hint(this.getHandle());
    }

    public void setSkipPagerHint(boolean bl) {
        this.checkState();
        Window.gtk_window_set_skip_pager_hint(this.getHandle(), bl);
    }

    public boolean getSkipPagerHint() {
        this.checkState();
        return Window.gtk_window_get_skip_pager_hint(this.getHandle());
    }

    public void setAcceptFocus(boolean bl) {
        this.checkState();
        Window.gtk_window_set_accept_focus(this.getHandle(), bl);
    }

    public boolean getAcceptFocus() {
        this.checkState();
        return Window.gtk_window_get_accept_focus(this.getHandle());
    }

    public void setScreen(Screen screen) {
        this.checkState();
        Window.gtk_window_set_screen(this.getHandle(), screen.getHandle());
    }

    public Screen getScreen() {
        this.checkState();
        Handle handle = Window.gtk_window_get_screen(this.getHandle());
        return Screen.getScreenFromHandle(handle);
    }

    public boolean isActive() {
        this.checkState();
        return Window.gtk_window_is_active(this.getHandle());
    }

    public boolean hasToplevelFocus() {
        this.checkState();
        return Window.gtk_window_has_toplevel_focus(this.getHandle());
    }

    public boolean setIconFromFile(String string) {
        this.checkState();
        return Window.gtk_window_set_icon_from_file(this.getHandle(), string);
    }

    public static boolean setDefaultIconFromFile(String string) {
        return Window.gtk_window_set_default_icon_from_file(string);
    }

    public static void setDefaultIcon(Pixbuf pixbuf) {
        Window.gtk_window_set_default_icon(pixbuf.getHandle());
    }

    public static void setAutoStartupNotification(boolean bl) {
        Window.gtk_window_set_auto_startup_notification(bl);
    }

    public void fullscreen() {
        this.checkState();
        Window.gtk_window_fullscreen(this.getHandle());
    }

    public void unfullscreen() {
        this.checkState();
        Window.gtk_window_unfullscreen(this.getHandle());
    }

    public void setKeepAbove(boolean bl) {
        this.checkState();
        Window.gtk_window_set_keep_above(this.getHandle(), bl);
    }

    public void setKeepBelow(boolean bl) {
        this.checkState();
        Window.gtk_window_set_keep_below(this.getHandle(), bl);
    }

    public static void setDefaultIconList(Pixbuf[] pixbufArray) {
        if (pixbufArray == null) {
            return;
        }
        Handle[] handleArray = new Handle[pixbufArray.length];
        for (int i = 0; i < pixbufArray.length; ++i) {
            handleArray[i] = pixbufArray[i].getHandle();
        }
        Window.gtk_window_set_default_icon_list(handleArray);
    }

    public static Pixbuf[] getDefaultIconList() {
        Handle[] handleArray = Window.gtk_window_get_default_icon_list();
        Pixbuf[] pixbufArray = new Pixbuf[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            pixbufArray[i] = Pixbuf.getPixbufFromHandle(handleArray[i]);
        }
        return pixbufArray;
    }

    public static Window[] listToplevelWindows() {
        Handle[] handleArray = Window.gtk_window_list_toplevels();
        Window[] windowArray = new Window[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            windowArray[i] = Window.getWindow(handleArray[i]);
        }
        return windowArray;
    }

    public void setFocusOnMap(boolean bl) {
        this.checkState();
        Window.gtk_window_set_focus_on_map(this.getHandle(), bl);
    }

    public boolean getFocusOnMap() {
        this.checkState();
        return Window.gtk_window_get_focus_on_map(this.getHandle());
    }

    public void setIconName(String string) {
        this.checkState();
        Window.gtk_window_set_icon_name(this.getHandle(), string);
    }

    public String getIconName() {
        this.checkState();
        return Window.gtk_window_get_icon_name(this.getHandle());
    }

    public void setDefaultIconName(String string) {
        this.checkState();
        Window.gtk_window_set_default_icon_name(string);
    }

    public Window getTransientParent() {
        this.checkState();
        Handle handle = Window.gtk_window_get_transient_for(this.getHandle());
        return Window.getWindow(handle);
    }

    public void setTransientParent(Window window) {
        this.checkState();
        Handle handle = window == null ? Struct.getNullHandle() : window.getHandle();
        Window.gtk_window_set_transient_for(this.getHandle(), handle);
    }

    public static Type getType() {
        return new Type(Window.gtk_window_get_type());
    }

    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        Window.gtk_window_destroy(this.getHandle());
        this.destroyed = true;
    }

    protected void checkState() {
        if (this.isDestroyed()) {
            throw new ObjectDestroyedException();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void finalize() {
    }

    protected static final native int gtk_window_get_type();

    protected static final native Handle gtk_window_new(int var0);

    protected static final native void gtk_window_set_title(Handle var0, String var1);

    protected static final native String gtk_window_get_title(Handle var0);

    protected static final native void gtk_window_set_wmclass(Handle var0, String var1, String var2);

    protected static final native void gtk_window_set_role(Handle var0, String var1);

    protected static final native String gtk_window_get_role(Handle var0);

    protected static final native void gtk_window_add_accel_group(Handle var0, Handle var1);

    protected static final native void gtk_window_remove_accel_group(Handle var0, Handle var1);

    protected static final native void gtk_window_set_position(Handle var0, int var1);

    protected static final native int gtk_window_activate_focus(Handle var0);

    protected static final native void gtk_window_set_focus(Handle var0, Handle var1);

    protected static final native Handle gtk_window_get_focus(Handle var0);

    protected static final native void gtk_window_set_default(Handle var0, Handle var1);

    protected static final native boolean gtk_window_activate_default(Handle var0);

    protected static final native void gtk_window_set_transient_for(Handle var0, Handle var1);

    protected static final native Handle gtk_window_get_transient_for(Handle var0);

    protected static final native void gtk_window_set_type_hint(Handle var0, int var1);

    protected static final native int gtk_window_get_type_hint(Handle var0);

    protected static final native void gtk_window_set_destroy_with_parent(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_destroy_with_parent(Handle var0);

    protected static final native void gtk_window_set_resizable(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_resizable(Handle var0);

    protected static final native void gtk_window_set_gravity(Handle var0, int var1);

    protected static final native int gtk_window_get_gravity(Handle var0);

    protected static final native void gtk_window_set_geometry_hints(Handle var0, Handle var1, Handle var2, int var3);

    protected static final native void gtk_window_set_has_frame(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_has_frame(Handle var0);

    protected static final native void gtk_window_set_frame_dimensions(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gtk_window_get_frame_dimensions(Handle var0, int[] var1, int[] var2, int[] var3, int[] var4);

    protected static final native void gtk_window_set_decorated(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_decorated(Handle var0);

    protected static final native void gtk_window_set_icon_list(Handle var0, Handle[] var1);

    protected static final native Handle[] gtk_window_get_icon_list(Handle var0);

    protected static final native void gtk_window_set_icon(Handle var0, Handle var1);

    protected static final native Handle gtk_window_get_icon(Handle var0);

    protected static final native void gtk_window_set_default_icon_list(Handle[] var0);

    protected static final native Handle[] gtk_window_get_default_icon_list();

    protected static final native void gtk_window_set_modal(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_modal(Handle var0);

    protected static final native Handle[] gtk_window_list_toplevels();

    protected static final native void gtk_window_add_mnemonic(Handle var0, int var1, Handle var2);

    protected static final native void gtk_window_remove_mnemonic(Handle var0, int var1, Handle var2);

    protected static final native boolean gtk_window_mnemonic_activate(Handle var0, int var1, int var2);

    protected static final native void gtk_window_set_mnemonic_modifier(Handle var0, int var1);

    protected static final native int gtk_window_get_mnemonic_modifier(Handle var0);

    protected static final native void gtk_window_present(Handle var0);

    protected static final native void gtk_window_iconify(Handle var0);

    protected static final native void gtk_window_deiconify(Handle var0);

    protected static final native void gtk_window_stick(Handle var0);

    protected static final native void gtk_window_unstick(Handle var0);

    protected static final native void gtk_window_maximize(Handle var0);

    protected static final native void gtk_window_unmaximize(Handle var0);

    protected static final native void gtk_window_begin_resize_drag(Handle var0, int var1, int var2, int var3, int var4, int var5);

    protected static final native void gtk_window_begin_move_drag(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gtk_window_set_default_size(Handle var0, int var1, int var2);

    protected static final native void gtk_window_get_default_size(Handle var0, int[] var1, int[] var2);

    protected static final native void gtk_window_resize(Handle var0, int var1, int var2);

    protected static final native void gtk_window_get_size(Handle var0, int[] var1, int[] var2);

    protected static final native void gtk_window_move(Handle var0, int var1, int var2);

    protected static final native void gtk_window_get_position(Handle var0, int[] var1, int[] var2);

    protected static final native boolean gtk_window_parse_geometry(Handle var0, String var1);

    protected static final native void gtk_window_set_skip_taskbar_hint(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_skip_taskbar_hint(Handle var0);

    protected static final native void gtk_window_set_skip_pager_hint(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_skip_pager_hint(Handle var0);

    protected static final native void gtk_window_set_accept_focus(Handle var0, boolean var1);

    protected static final native boolean gtk_window_get_accept_focus(Handle var0);

    protected static final native void gtk_window_set_screen(Handle var0, Handle var1);

    protected static final native Handle gtk_window_get_screen(Handle var0);

    protected static final native boolean gtk_window_is_active(Handle var0);

    protected static final native boolean gtk_window_has_toplevel_focus(Handle var0);

    protected static final native boolean gtk_window_set_icon_from_file(Handle var0, String var1);

    protected static final native boolean gtk_window_set_default_icon_from_file(String var0);

    protected static final native void gtk_window_set_default_icon(Handle var0);

    protected static final native void gtk_window_set_auto_startup_notification(boolean var0);

    protected static final native void gtk_window_fullscreen(Handle var0);

    protected static final native void gtk_window_unfullscreen(Handle var0);

    protected static final native void gtk_window_set_keep_above(Handle var0, boolean var1);

    protected static final native void gtk_window_set_keep_below(Handle var0, boolean var1);

    private static final native void gtk_window_set_focus_on_map(Handle var0, boolean var1);

    private static final native boolean gtk_window_get_focus_on_map(Handle var0);

    private static final native void gtk_window_set_icon_name(Handle var0, String var1);

    private static final native String gtk_window_get_icon_name(Handle var0);

    private static final native void gtk_window_set_default_icon_name(String var0);

    private static final native void gtk_window_destroy(Handle var0);
}

