/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.lang.reflect.Method;
import java.util.Vector;
import org.gnu.atk.AtkObject;
import org.gnu.gdk.Atom;
import org.gnu.gdk.Bitmap;
import org.gnu.gdk.Color;
import org.gnu.gdk.Colormap;
import org.gnu.gdk.Display;
import org.gnu.gdk.DragAction;
import org.gnu.gdk.DragContext;
import org.gnu.gdk.EventButton;
import org.gnu.gdk.EventConfigure;
import org.gnu.gdk.EventCrossing;
import org.gnu.gdk.EventExpose;
import org.gnu.gdk.EventKey;
import org.gnu.gdk.EventMask;
import org.gnu.gdk.EventMotion;
import org.gnu.gdk.EventScroll;
import org.gnu.gdk.ExtensionMode;
import org.gnu.gdk.ModifierType;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Pixmap;
import org.gnu.gdk.Point;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Screen;
import org.gnu.gdk.Window;
import org.gnu.glib.Boxed;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;
import org.gnu.gtk.AccelFlags;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.Allocation;
import org.gnu.gtk.DestDefaults;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.GtkObject;
import org.gnu.gtk.RcStyle;
import org.gnu.gtk.SelectionData;
import org.gnu.gtk.StateType;
import org.gnu.gtk.Style;
import org.gnu.gtk.TargetEntry;
import org.gnu.gtk.event.ConfigureEvent;
import org.gnu.gtk.event.ConfigureListener;
import org.gnu.gtk.event.DeleteDragDataEvent;
import org.gnu.gtk.event.DragDestinationListener;
import org.gnu.gtk.event.DragEvent;
import org.gnu.gtk.event.DragMotionEvent;
import org.gnu.gtk.event.DragOriginListener;
import org.gnu.gtk.event.DragSourceListener;
import org.gnu.gtk.event.DragTargetListener;
import org.gnu.gtk.event.DropDragEvent;
import org.gnu.gtk.event.EndDragEvent;
import org.gnu.gtk.event.ExposeEvent;
import org.gnu.gtk.event.ExposeListener;
import org.gnu.gtk.event.FocusEvent;
import org.gnu.gtk.event.FocusListener;
import org.gnu.gtk.event.KeyEvent;
import org.gnu.gtk.event.KeyListener;
import org.gnu.gtk.event.LeaveDragDestinationEvent;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;
import org.gnu.gtk.event.MouseEvent;
import org.gnu.gtk.event.MouseListener;
import org.gnu.gtk.event.MouseMotionEvent;
import org.gnu.gtk.event.MouseMotionListener;
import org.gnu.gtk.event.ReceiveDragDataEvent;
import org.gnu.gtk.event.RequestDragDataEvent;
import org.gnu.gtk.event.StartDragEvent;
import org.gnu.pango.Context;
import org.gnu.pango.FontDescription;
import org.gnu.pango.Layout;

public class Widget
extends GtkObject {
    private static Class[] handleClass = new Class[]{Widget.class$("org.gnu.glib.Handle")};
    private Vector focusListeners;
    private Vector configureListeners;
    private Vector keyListeners;
    private Vector lifeCycleListeners;
    private Vector mouseListeners;
    private Vector dragTargetListeners;
    private Vector dragOriginListeners;
    private Vector exposeListeners;
    private Vector mouseMotionListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.focusListeners = null;
        this.configureListeners = null;
        this.keyListeners = null;
        this.lifeCycleListeners = null;
        this.mouseListeners = null;
        this.dragTargetListeners = null;
        this.dragOriginListeners = null;
        this.exposeListeners = null;
        this.mouseMotionListeners = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Widget(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static Widget getWidget(Handle handle) {
        if (handle == null) {
            return null;
        }
        Widget widget = (Widget)GObject.getGObjectFromHandle((Handle)handle);
        if (widget == null) {
            widget = new Widget(handle);
        }
        return widget;
    }

    public void show() {
        this.checkState();
        Widget.gtk_widget_show(this.getHandle());
    }

    public void showAll() {
        this.checkState();
        Widget.gtk_widget_show_all(this.getHandle());
    }

    public void hide() {
        this.checkState();
        Widget.gtk_widget_hide(this.getHandle());
    }

    public void hideAll() {
        this.checkState();
        Widget.gtk_widget_hide_all(this.getHandle());
    }

    public void realize() {
        this.checkState();
        Widget.gtk_widget_realize(this.getHandle());
    }

    public void draw() {
        this.checkState();
        Widget.gtk_widget_queue_draw(this.getHandle());
    }

    public void drawArea(Rectangle rectangle) {
        this.checkState();
        this.drawArea(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void drawArea(int n, int n2, int n3, int n4) {
        this.checkState();
        Widget.gtk_widget_queue_draw_area(this.getHandle(), n, n2, n3, n4);
    }

    public boolean activate() {
        this.checkState();
        return Widget.gtk_widget_activate(this.getHandle());
    }

    public void reparent(Widget widget) {
        this.checkState();
        Widget.gtk_widget_reparent(this.getHandle(), widget.getHandle());
    }

    public Widget getParent() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_parent(this.getHandle());
        return Widget.getWidget(handle);
    }

    public Window getParentWindow() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_parent_window(this.getHandle());
        return Window.getWindowFromHandle(handle);
    }

    public Window getWindow() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_window(this.getHandle());
        return Window.getWindowFromHandle(handle);
    }

    public void setEvents(EventMask eventMask) {
        this.checkState();
        Widget.gtk_widget_set_events(this.getHandle(), eventMask.getValue());
    }

    public void addEvents(EventMask eventMask) {
        this.checkState();
        Widget.gtk_widget_add_events(this.getHandle(), eventMask.getValue());
    }

    public void setExtensionEvents(ExtensionMode extensionMode) {
        this.checkState();
        Widget.gtk_widget_set_extension_events(this.getHandle(), extensionMode.getValue());
    }

    public ExtensionMode getExtensionEvents() {
        this.checkState();
        return ExtensionMode.intern(Widget.gtk_widget_get_extension_events(this.getHandle()));
    }

    public Rectangle intersect(Rectangle rectangle) {
        this.checkState();
        Handle handle = Widget.gtk_widget_intersect(this.getHandle(), rectangle.getHandle());
        return Rectangle.getRectangle(handle);
    }

    public boolean hasFocus() {
        this.checkState();
        return Widget.gtk_widget_is_focus(this.getHandle());
    }

    public void grabFocus() {
        this.checkState();
        Widget.gtk_widget_grab_focus(this.getHandle());
    }

    public boolean getCanFocus() {
        this.checkState();
        return this.getBooleanProperty("can-focus");
    }

    public void setCanFocus(boolean bl) {
        this.checkState();
        this.setBooleanProperty("can-focus", bl);
    }

    public void grabDefault() {
        this.checkState();
        Widget.gtk_widget_grab_default(this.getHandle());
    }

    public void setName(String string) {
        this.checkState();
        Widget.gtk_widget_set_name(this.getHandle(), string);
    }

    public String getName() {
        this.checkState();
        return Widget.gtk_widget_get_name(this.getHandle());
    }

    public void setSensitive(boolean bl) {
        this.checkState();
        Widget.gtk_widget_set_sensitive(this.getHandle(), bl);
    }

    public boolean getSensitive() {
        this.checkState();
        return Widget.gtk_widget_get_sensitive(this.getHandle());
    }

    public Widget getToplevel() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_toplevel(this.getHandle());
        return Widget.getWidget(handle);
    }

    public Colormap getColormap() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_colormap(this.getHandle());
        return Colormap.getColormapFromHandle(handle);
    }

    public void setColormap(Colormap colormap) {
        this.checkState();
        Widget.gtk_widget_set_colormap(this.getHandle(), colormap.getHandle());
    }

    public Point getPointer() {
        this.checkState();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Widget.gtk_widget_get_pointer(this.getHandle(), nArray, nArray2);
        if (nArray == null) {
            return null;
        }
        if (nArray2 == null) {
            return null;
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public boolean isAncestor(Widget widget) {
        this.checkState();
        return Widget.gtk_widget_is_ancestor(this.getHandle(), widget.getHandle());
    }

    public void pushColormap(Colormap colormap) {
        this.checkState();
        Widget.gtk_widget_push_colormap(colormap.getHandle());
    }

    public void popColormap() {
        this.checkState();
        Widget.gtk_widget_pop_colormap();
    }

    public void shapeCombineMask(Bitmap bitmap, int n, int n2) {
        this.checkState();
        Handle handle = bitmap == null ? null : bitmap.getHandle();
        Widget.gtk_widget_shape_combine_mask(this.getHandle(), handle, n, n2);
    }

    public void setForegroundColor(StateType stateType, Color color) {
        this.checkState();
        Widget.gtk_widget_modify_fg(this.getHandle(), stateType.getValue(), this.getHandle((Struct)color));
    }

    public void setBackgroundColor(StateType stateType, Color color) {
        this.checkState();
        Widget.gtk_widget_modify_bg(this.getHandle(), stateType.getValue(), this.getHandle((Struct)color));
    }

    public void setTextColor(StateType stateType, Color color) {
        this.checkState();
        Widget.gtk_widget_modify_text(this.getHandle(), stateType.getValue(), this.getHandle((Struct)color));
    }

    public void setBaseColor(StateType stateType, Color color) {
        this.checkState();
        Widget.gtk_widget_modify_base(this.getHandle(), stateType.getValue(), this.getHandle((Struct)color));
    }

    public void setFont(FontDescription fontDescription) {
        this.checkState();
        Widget.gtk_widget_modify_font(this.getHandle(), this.getHandle((Struct)fontDescription));
    }

    public void modifyStyle(RcStyle rcStyle) {
        this.checkState();
        Widget.gtk_widget_modify_style(this.getHandle(), this.getHandle((Struct)rcStyle));
    }

    public RcStyle getModifierStyle() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_modifier_style(this.getHandle());
        return RcStyle.getRcStyle(handle);
    }

    public Style getStyle() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_style(this.getHandle());
        return Style.getStyle(handle);
    }

    public Context createContext() {
        this.checkState();
        Handle handle = Widget.gtk_widget_create_pango_context(this.getHandle());
        return Context.getContextFromHandle(handle);
    }

    public Context getContext() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_pango_context(this.getHandle());
        return Context.getContextFromHandle(handle);
    }

    public Layout createLayout(String string) {
        this.checkState();
        Handle handle = Widget.gtk_widget_create_pango_layout(this.getHandle(), string);
        return Layout.getLayoutFromHandle(handle);
    }

    public void setDoubleBuffered(boolean bl) {
        this.checkState();
        Widget.gtk_widget_set_double_buffered(this.getHandle(), bl);
    }

    public AtkObject getAccessible() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_accessible(this.getHandle());
        return AtkObject.getAtkObjectFromHandle(handle);
    }

    public boolean canActivateAccel(int n) {
        this.checkState();
        return Widget.gtk_widget_can_activate_accel(this.getHandle(), n);
    }

    public Screen getScreen() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_screen(this.getHandle());
        return Screen.getScreenFromHandle(handle);
    }

    public boolean hasScreen() {
        this.checkState();
        return Widget.gtk_widget_has_screen(this.getHandle());
    }

    public Display getDisplay() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_display(this.getHandle());
        return Display.getDisplayFromHandle(handle);
    }

    public Window getRootWindow() {
        this.checkState();
        Handle handle = Widget.gtk_widget_get_root_window(this.getHandle());
        return Window.getWindowFromHandle(handle);
    }

    public void addAccelerator(AccelGroup accelGroup, int n, ModifierType modifierType, AccelFlags accelFlags) {
        Widget.gtk_widget_add_accelerator(this.getHandle(), accelGroup.getHandle(), n, modifierType.getValue(), accelFlags.getValue());
    }

    public boolean removeAccelerator(AccelGroup accelGroup, int n, ModifierType modifierType) {
        return Widget.gtk_widget_remove_accelerator(this.getHandle(), accelGroup.getHandle(), n, modifierType.getValue());
    }

    public void setMinimumSize(int n, int n2) {
        this.checkState();
        Widget.gtk_widget_set_size_request(this.getHandle(), n, n2);
    }

    public Class getEventListenerClass(String string) {
        this.checkState();
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        this.checkState();
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("hide", "handleHide", (EventType)LifeCycleEvent.Type.HIDE, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("show", "handleShow", (EventType)LifeCycleEvent.Type.SHOW, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("realize", "handleRealize", (EventType)LifeCycleEvent.Type.REALIZE, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("unrealize", "handleUnrealize", (EventType)LifeCycleEvent.Type.UNREALIZE, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("destroy_event", "handleDestroy", (EventType)LifeCycleEvent.Type.DESTROY, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("delete_event", "handleDelete", (EventType)LifeCycleEvent.Type.DELETE, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("map", "handleMap", (EventType)LifeCycleEvent.Type.MAP, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("unmap", "handleUnmap", (EventType)LifeCycleEvent.Type.UNMAP, Widget.class$("org.gnu.gtk.event.LifeCycleListener"));
        eventMap.addEvent("focus_in_event", "handleFocusIn", (EventType)FocusEvent.Type.FOCUS_IN, Widget.class$("org.gnu.gtk.event.FocusListener"));
        eventMap.addEvent("focus_out_event", "handleFocusOut", (EventType)FocusEvent.Type.FOCUS_OUT, Widget.class$("org.gnu.gtk.event.FocusListener"));
        eventMap.addEvent("configure_event", "handleConfigure", (EventType)ConfigureEvent.Type.CONFIGURE, Widget.class$("org.gnu.gtk.event.ConfigureListener"));
        eventMap.addEvent("key_press_event", "handleKeyPressed", (EventType)KeyEvent.Type.KEY_PRESSED, Widget.class$("org.gnu.gtk.event.KeyListener"));
        eventMap.addEvent("key_release_event", "handleKeyReleased", (EventType)KeyEvent.Type.KEY_RELEASED, Widget.class$("org.gnu.gtk.event.KeyListener"));
        eventMap.addEvent("button_press_event", "handleButtonPressed", (EventType)MouseEvent.Type.BUTTON_PRESS, Widget.class$("org.gnu.gtk.event.MouseListener"));
        eventMap.addEvent("button_release_event", "handleButtonReleased", (EventType)MouseEvent.Type.BUTTON_RELEASE, Widget.class$("org.gnu.gtk.event.MouseListener"));
        eventMap.addEvent("scroll_event", "handleScroll", (EventType)MouseEvent.Type.WHEEL_SCROLL, Widget.class$("org.gnu.gtk.event.MouseListener"));
        eventMap.addEvent("enter_notify_event", "handleMouseEnter", (EventType)MouseEvent.Type.ENTER, Widget.class$("org.gnu.gtk.event.MouseListener"));
        eventMap.addEvent("leave_notify_event", "handleMouseLeave", (EventType)MouseEvent.Type.LEAVE, Widget.class$("org.gnu.gtk.event.MouseListener"));
        eventMap.addEvent("expose_event", "handleExpose", (EventType)ExposeEvent.Type.EXPOSE, Widget.class$("org.gnu.gtk.event.ExposeListener"));
        eventMap.addEvent("no_expose_event", "handleNoExpose", (EventType)ExposeEvent.Type.NO_EXPOSE, Widget.class$("org.gnu.gtk.event.ExposeListener"));
        eventMap.addEvent("motion-notify-event", "handleMouseMotion", (EventType)MouseMotionEvent.Type.MOTION, Widget.class$("org.gnu.gtk.event.MouseMotionListener"));
        eventMap.addEvent("drag-begin", "handleDragStarted", (EventType)StartDragEvent.Type.START, Widget.class$("org.gnu.gtk.event.DragOriginListener"));
        eventMap.addEvent("drag-data-delete", "handleDragDataDeleted", (EventType)DeleteDragDataEvent.Type.DATA_DELETE, Widget.class$("org.gnu.gtk.event.DragOriginListener"));
        eventMap.addEvent("drag-data-get", "handleDragDataRequested", (EventType)RequestDragDataEvent.Type.DATA_REQUEST, Widget.class$("org.gnu.gtk.event.DragOriginListener"));
        eventMap.addEvent("drag-data-received", "handleDragDataReceived", (EventType)ReceiveDragDataEvent.Type.DATA_RECEIVE, Widget.class$("org.gnu.gtk.event.DragTargetListener"));
        eventMap.addEvent("drag-drop", "handleDragDropped", (EventType)DropDragEvent.Type.DROP, Widget.class$("org.gnu.gtk.event.DragTargetListener"));
        eventMap.addEvent("drag-end", "handleDragEnded", (EventType)EndDragEvent.Type.END, Widget.class$("org.gnu.gtk.event.DragOriginListener"));
        eventMap.addEvent("drag-leave", "handleDragDestinationLeft", (EventType)LeaveDragDestinationEvent.Type.LEAVE_DESTINATION, Widget.class$("org.gnu.gtk.event.DragTargetListener"));
        eventMap.addEvent("drag-motion", "handleDragMotionOccurred", (EventType)DragMotionEvent.Type.MOTION, Widget.class$("org.gnu.gtk.event.DragOriginListener"));
    }

    public void addListener(LifeCycleListener lifeCycleListener) {
        this.checkState();
        int n = Widget.findListener(this.lifeCycleListeners, lifeCycleListener);
        if (n == -1) {
            if (this.lifeCycleListeners == null) {
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.HIDE);
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.SHOW);
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.REALIZE);
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.UNREALIZE);
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.DESTROY);
                evtMap.initialize((GObject)this, (EventType)LifeCycleEvent.Type.DELETE);
                this.lifeCycleListeners = new Vector();
            }
            this.lifeCycleListeners.addElement(lifeCycleListener);
        }
    }

    public void removeListener(LifeCycleListener lifeCycleListener) {
        this.checkState();
        int n = Widget.findListener(this.lifeCycleListeners, lifeCycleListener);
        if (n > -1) {
            this.lifeCycleListeners.remove(n);
        }
        if (this.lifeCycleListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.HIDE);
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.SHOW);
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.REALIZE);
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.UNREALIZE);
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.DESTROY);
            evtMap.uninitialize((GObject)this, (EventType)LifeCycleEvent.Type.DELETE);
            this.lifeCycleListeners = null;
        }
    }

    protected void fireLifeCycleEvent(LifeCycleEvent lifeCycleEvent) {
        if (this.lifeCycleListeners == null) {
            return;
        }
        int n = this.lifeCycleListeners.size();
        for (int i = 0; i < n; ++i) {
            LifeCycleListener lifeCycleListener = (LifeCycleListener)this.lifeCycleListeners.elementAt(i);
            lifeCycleListener.lifeCycleEvent(lifeCycleEvent);
        }
    }

    protected boolean fireBooleanLifeCycleEvent(LifeCycleEvent lifeCycleEvent, boolean bl) {
        boolean bl2 = bl;
        if (this.lifeCycleListeners == null) {
            return bl;
        }
        int n = this.lifeCycleListeners.size();
        for (int i = 0; i < n; ++i) {
            LifeCycleListener lifeCycleListener = (LifeCycleListener)this.lifeCycleListeners.elementAt(i);
            if (lifeCycleListener.lifeCycleQuery(lifeCycleEvent) == bl) continue;
            bl2 = bl ^ true;
        }
        return bl2;
    }

    protected void handleShow() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.SHOW));
    }

    protected void handleHide() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.HIDE));
    }

    protected void handleRealize() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.REALIZE));
    }

    protected void handleUnrealize() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.UNREALIZE));
    }

    protected boolean handleDestroy(Handle handle) {
        return this.fireBooleanLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.DESTROY), true);
    }

    protected boolean handleDelete(Handle handle) {
        return this.fireBooleanLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.DELETE), false);
    }

    protected void handleMap() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.MAP));
    }

    protected void handleUnmap() {
        this.fireLifeCycleEvent(new LifeCycleEvent((Object)this, LifeCycleEvent.Type.UNMAP));
    }

    public void addListener(FocusListener focusListener) {
        this.checkState();
        int n = Widget.findListener(this.focusListeners, focusListener);
        if (n == -1) {
            if (this.focusListeners == null) {
                evtMap.initialize((GObject)this, (EventType)FocusEvent.Type.FOCUS_IN);
                evtMap.initialize((GObject)this, (EventType)FocusEvent.Type.FOCUS_OUT);
                this.focusListeners = new Vector();
            }
            this.focusListeners.addElement(focusListener);
        }
    }

    public void removeListener(FocusListener focusListener) {
        this.checkState();
        int n = Widget.findListener(this.focusListeners, focusListener);
        if (n > -1) {
            this.focusListeners.remove(n);
        }
        if (this.focusListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)FocusEvent.Type.FOCUS_IN);
            evtMap.uninitialize((GObject)this, (EventType)FocusEvent.Type.FOCUS_OUT);
            this.focusListeners = null;
        }
    }

    protected boolean fireFocusEvent(FocusEvent focusEvent) {
        if (this.focusListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.focusListeners.size();
        for (int i = 0; i < n; ++i) {
            FocusListener focusListener = (FocusListener)this.focusListeners.elementAt(i);
            if (!focusListener.focusEvent(focusEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleFocusIn(Handle handle) {
        return this.fireFocusEvent(new FocusEvent((Object)this, FocusEvent.Type.FOCUS_IN));
    }

    protected boolean handleFocusOut(Handle handle) {
        return this.fireFocusEvent(new FocusEvent((Object)this, FocusEvent.Type.FOCUS_OUT));
    }

    public void addListener(ConfigureListener configureListener) {
        this.checkState();
        int n = Widget.findListener(this.configureListeners, configureListener);
        if (n == -1) {
            if (this.configureListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ConfigureEvent.Type.CONFIGURE);
                this.configureListeners = new Vector();
            }
            this.configureListeners.addElement(configureListener);
        }
    }

    public void removeListener(ConfigureListener configureListener) {
        this.checkState();
        int n = Widget.findListener(this.configureListeners, configureListener);
        if (n > -1) {
            this.configureListeners.remove(n);
        }
        if (this.configureListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ConfigureEvent.Type.CONFIGURE);
            this.configureListeners = null;
        }
    }

    protected boolean fireConfigureEvent(ConfigureEvent configureEvent) {
        if (this.configureListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.configureListeners.size();
        for (int i = 0; i < n; ++i) {
            ConfigureListener configureListener = (ConfigureListener)this.configureListeners.elementAt(i);
            if (!configureListener.configureEvent(configureEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleConfigure(Handle handle) {
        return this.fireConfigureEvent(new ConfigureEvent((Object)this, ConfigureEvent.Type.CONFIGURE, new EventConfigure(handle)));
    }

    public void addListener(KeyListener keyListener) {
        this.checkState();
        int n = Widget.findListener(this.keyListeners, keyListener);
        if (n == -1) {
            if (this.keyListeners == null) {
                evtMap.initialize((GObject)this, (EventType)KeyEvent.Type.KEY_PRESSED);
                evtMap.initialize((GObject)this, (EventType)KeyEvent.Type.KEY_RELEASED);
                this.keyListeners = new Vector();
            }
            this.keyListeners.addElement(keyListener);
        }
    }

    public void removeListener(KeyListener keyListener) {
        this.checkState();
        int n = Widget.findListener(this.keyListeners, keyListener);
        if (n > -1) {
            this.keyListeners.remove(n);
        }
        if (this.keyListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)KeyEvent.Type.KEY_PRESSED);
            evtMap.uninitialize((GObject)this, (EventType)KeyEvent.Type.KEY_RELEASED);
            this.keyListeners = null;
        }
    }

    protected boolean fireKeyEvent(KeyEvent keyEvent) {
        this.checkState();
        if (this.keyListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.keyListeners.size();
        for (int i = 0; i < n; ++i) {
            KeyListener keyListener = (KeyListener)this.keyListeners.elementAt(i);
            if (!keyListener.keyEvent(keyEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleKeyPressed(Handle handle) {
        return this.fireKeyEvent(new KeyEvent((Object)this, KeyEvent.Type.KEY_PRESSED, new EventKey(handle)));
    }

    protected boolean handleKeyReleased(Handle handle) {
        return this.fireKeyEvent(new KeyEvent((Object)this, KeyEvent.Type.KEY_RELEASED, new EventKey(handle)));
    }

    public void addListener(MouseListener mouseListener) {
        this.checkState();
        int n = Widget.findListener(this.mouseListeners, mouseListener);
        if (n == -1) {
            if (this.mouseListeners == null) {
                evtMap.initialize((GObject)this, (EventType)MouseEvent.Type.BUTTON_PRESS);
                evtMap.initialize((GObject)this, (EventType)MouseEvent.Type.BUTTON_RELEASE);
                evtMap.initialize((GObject)this, (EventType)MouseEvent.Type.WHEEL_SCROLL);
                evtMap.initialize((GObject)this, (EventType)MouseEvent.Type.ENTER);
                evtMap.initialize((GObject)this, (EventType)MouseEvent.Type.LEAVE);
                this.mouseListeners = new Vector();
            }
            this.mouseListeners.addElement(mouseListener);
        }
    }

    public void removeListener(MouseListener mouseListener) {
        this.checkState();
        int n = Widget.findListener(this.mouseListeners, mouseListener);
        if (n > -1) {
            this.mouseListeners.remove(n);
        }
        if (this.mouseListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)MouseEvent.Type.BUTTON_PRESS);
            evtMap.uninitialize((GObject)this, (EventType)MouseEvent.Type.BUTTON_RELEASE);
            evtMap.uninitialize((GObject)this, (EventType)MouseEvent.Type.WHEEL_SCROLL);
            evtMap.uninitialize((GObject)this, (EventType)MouseEvent.Type.ENTER);
            evtMap.uninitialize((GObject)this, (EventType)MouseEvent.Type.LEAVE);
            this.mouseListeners = null;
        }
    }

    protected boolean fireMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.mouseListeners.size();
        for (int i = 0; i < n; ++i) {
            MouseListener mouseListener = (MouseListener)this.mouseListeners.elementAt(i);
            if (!mouseListener.mouseEvent(mouseEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleButtonPressed(Handle handle) {
        return this.fireMouseEvent(new MouseEvent((Object)this, MouseEvent.Type.BUTTON_PRESS, new EventButton(handle)));
    }

    protected boolean handleButtonReleased(Handle handle) {
        return this.fireMouseEvent(new MouseEvent((Object)this, MouseEvent.Type.BUTTON_RELEASE, new EventButton(handle)));
    }

    protected boolean handleScroll(Handle handle) {
        return this.fireMouseEvent(new MouseEvent((Object)this, MouseEvent.Type.WHEEL_SCROLL, new EventScroll(handle)));
    }

    protected boolean handleMouseEnter(Handle handle) {
        return this.fireMouseEvent(new MouseEvent((Object)this, MouseEvent.Type.ENTER, new EventCrossing(handle)));
    }

    protected boolean handleMouseLeave(Handle handle) {
        return this.fireMouseEvent(new MouseEvent((Object)this, MouseEvent.Type.LEAVE, new EventCrossing(handle)));
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    public static Type getType() {
        return new Type(Widget.gtk_widget_get_type());
    }

    public static Widget makeWidget(Handle handle) throws ClassNotFoundException {
        String string = Widget.getTypeClass(handle);
        String string2 = null;
        if (string == null) {
            throw new ClassNotFoundException("No GTK class name: invalid handle?");
        }
        try {
            Class<?> clazz = Class.forName(string);
            String string3 = Widget.removePackageName(clazz);
            string2 = "get" + string3;
            Method method = clazz.getMethod(string2, handleClass);
            return (Widget)((Object)method.invoke(null, handle));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClassNotFoundException("Could not find static factory method: " + string2 + "(Handle) in " + string + ". Please file a bug with this information.");
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(exception.toString());
        }
    }

    private static String removePackageName(Class clazz) {
        String string = clazz.getName();
        int n = clazz.getPackage().getName().length();
        return string.substring(n + 1);
    }

    private static String getTypeClass(Handle handle) {
        String string = Gtk.getTypeName(handle);
        if (string.startsWith("Gtk")) {
            String string2 = string.substring(3);
            if (string2.equals("Statusbar")) {
                string2 = "StatusBar";
            } else if (string2.equals("Toolbar")) {
                string2 = "ToolBar";
            } else if (string2.equals("HScrollbar")) {
                string2 = "HScrollBar";
            } else if (string2.equals("VScrollbar")) {
                string2 = "VScrollBar";
            }
            return "org.gnu.gtk." + string2;
        }
        if (string.startsWith("Gnome")) {
            return "org.gnu.gnome." + string.substring(5);
        }
        return string;
    }

    public Allocation getAllocation() {
        this.checkState();
        return Widget.gtk_widget_get_allocation(this.getHandle());
    }

    public void setDragSource(ModifierType modifierType, TargetEntry[] targetEntryArray, DragAction dragAction) {
        this.checkState();
        Handle[] handleArray = new Handle[targetEntryArray.length];
        for (int i = 0; i < targetEntryArray.length; ++i) {
            handleArray[i] = targetEntryArray[i].getHandle();
        }
        Widget.gtk_drag_source_set(this.getHandle(), modifierType.getValue(), handleArray, dragAction.getValue());
    }

    public void setNoDragSource() {
        this.checkState();
        Widget.gtk_drag_source_unset(this.getHandle());
    }

    public void setDragIcon(Widget widget, Colormap colormap, Pixmap pixmap, Bitmap bitmap) {
        this.checkState();
        Widget.gtk_drag_source_set_icon(widget.getHandle(), colormap.getHandle(), pixmap.getHandle(), bitmap.getHandle());
    }

    public void setDragIconPixbuf(Widget widget, Pixbuf pixbuf) {
        this.checkState();
        Widget.gtk_drag_source_set_icon_pixbuf(widget.getHandle(), pixbuf.getHandle());
    }

    public void setDragIconStock(Widget widget, String string) {
        this.checkState();
        Widget.gtk_drag_source_set_icon_stock(widget.getHandle(), string);
    }

    public void setDragDestination(DestDefaults destDefaults, TargetEntry[] targetEntryArray, DragAction dragAction) {
        this.checkState();
        Handle[] handleArray = new Handle[targetEntryArray.length];
        for (int i = 0; i < targetEntryArray.length; ++i) {
            handleArray[i] = targetEntryArray[i].getHandle();
        }
        Widget.gtk_drag_dest_set(this.getHandle(), destDefaults.getValue(), handleArray, dragAction.getValue());
    }

    public void getDragData(DragContext dragContext, Atom atom, int n) {
        this.checkState();
        Widget.gtk_drag_get_data(this.getHandle(), dragContext.getHandle(), atom.getHandle(), n);
    }

    public void setNoDragDestination() {
        this.checkState();
        Widget.gtk_drag_dest_unset(this.getHandle());
    }

    public static void getData(Widget widget, DragContext dragContext, Atom atom) {
        Widget.gtk_drag_get_data(widget.getHandle(), dragContext.getHandle(), atom.getHandle(), 0);
    }

    public static void finish(DragContext dragContext, boolean bl, boolean bl2) {
        Widget.gtk_drag_finish(dragContext.getHandle(), bl, bl2, 0);
    }

    public static void highlight(Widget widget) {
        Widget.gtk_drag_highlight(widget.getHandle());
    }

    public void highlight() {
        this.checkState();
        Widget.gtk_drag_highlight(this.getHandle());
    }

    public static void unHighlight(Widget widget) {
        Widget.gtk_drag_unhighlight(widget.getHandle());
    }

    public void unHighlight() {
        this.checkState();
        Widget.gtk_drag_unhighlight(this.getHandle());
    }

    public void addListener(DragDestinationListener dragDestinationListener) {
    }

    public void addListener(DragTargetListener dragTargetListener) {
        this.checkState();
        int n = Widget.findListener(this.dragTargetListeners, dragTargetListener);
        if (n == -1) {
            if (this.dragTargetListeners == null) {
                evtMap.initialize((GObject)this, (EventType)LeaveDragDestinationEvent.Type.LEAVE_DESTINATION);
                evtMap.initialize((GObject)this, (EventType)DropDragEvent.Type.DROP);
                evtMap.initialize((GObject)this, (EventType)ReceiveDragDataEvent.Type.DATA_RECEIVE);
                evtMap.initialize((GObject)this, (EventType)DragMotionEvent.Type.MOTION);
                this.dragTargetListeners = new Vector();
            }
            this.dragTargetListeners.addElement(dragTargetListener);
        }
    }

    public void removeListener(DragDestinationListener dragDestinationListener) {
    }

    public void removeListener(DragTargetListener dragTargetListener) {
        this.checkState();
        int n = Widget.findListener(this.dragTargetListeners, dragTargetListener);
        if (n > -1) {
            this.dragTargetListeners.remove(n);
        }
        if (this.dragTargetListeners.size() == 0) {
            this.dragTargetListeners = null;
            evtMap.uninitialize((GObject)this, (EventType)LeaveDragDestinationEvent.Type.LEAVE_DESTINATION);
            evtMap.uninitialize((GObject)this, (EventType)DropDragEvent.Type.DROP);
            evtMap.uninitialize((GObject)this, (EventType)ReceiveDragDataEvent.Type.DATA_RECEIVE);
            evtMap.uninitialize((GObject)this, (EventType)DragMotionEvent.Type.MOTION);
        }
    }

    protected void fireReceiveDragDataEvent(ReceiveDragDataEvent receiveDragDataEvent) {
        if (this.dragTargetListeners == null) {
            return;
        }
        int n = this.dragTargetListeners.size();
        for (int i = 0; i < n; ++i) {
            DragTargetListener dragTargetListener = (DragTargetListener)this.dragTargetListeners.elementAt(i);
            dragTargetListener.dataReceived(receiveDragDataEvent);
        }
    }

    public void addListener(DragSourceListener dragSourceListener) {
    }

    public void addListener(DragOriginListener dragOriginListener) {
        this.checkState();
        int n = Widget.findListener(this.dragOriginListeners, dragOriginListener);
        if (n == -1) {
            if (this.dragOriginListeners == null) {
                this.dragOriginListeners = new Vector();
                evtMap.initialize((GObject)this, (EventType)StartDragEvent.Type.START);
                evtMap.initialize((GObject)this, (EventType)EndDragEvent.Type.END);
                evtMap.initialize((GObject)this, (EventType)RequestDragDataEvent.Type.DATA_REQUEST, false);
                evtMap.initialize((GObject)this, (EventType)DeleteDragDataEvent.Type.DATA_DELETE);
            }
            this.dragOriginListeners.addElement(dragOriginListener);
        }
    }

    public void removeListener(DragSourceListener dragSourceListener) {
    }

    public void removeListener(DragOriginListener dragOriginListener) {
        this.checkState();
        int n = Widget.findListener(this.dragOriginListeners, dragOriginListener);
        if (n > -1) {
            this.dragOriginListeners.remove(n);
        }
        if (this.dragOriginListeners.size() == 0) {
            this.dragOriginListeners = null;
            evtMap.uninitialize((GObject)this, (EventType)StartDragEvent.Type.START);
            evtMap.uninitialize((GObject)this, (EventType)EndDragEvent.Type.END);
            evtMap.uninitialize((GObject)this, (EventType)RequestDragDataEvent.Type.DATA_REQUEST);
            evtMap.uninitialize((GObject)this, (EventType)DeleteDragDataEvent.Type.DATA_DELETE);
        }
    }

    protected void fireStartDragEvent(StartDragEvent startDragEvent) {
        if (this.dragOriginListeners == null) {
            return;
        }
        int n = this.dragOriginListeners.size();
        for (int i = 0; i < n; ++i) {
            DragOriginListener dragOriginListener = (DragOriginListener)this.dragOriginListeners.elementAt(i);
            dragOriginListener.dragStarted(startDragEvent);
        }
    }

    protected boolean fireDragMotionEvent(DragMotionEvent dragMotionEvent) {
        boolean bl = false;
        if (this.dragTargetListeners == null) {
            return false;
        }
        int n = this.dragTargetListeners.size();
        for (int i = 0; i < n; ++i) {
            DragTargetListener dragTargetListener = (DragTargetListener)this.dragTargetListeners.elementAt(i);
            if (!dragTargetListener.motionOcurred(dragMotionEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected void fireLeaveDragDestinationEvent(LeaveDragDestinationEvent leaveDragDestinationEvent) {
        if (this.dragTargetListeners == null) {
            return;
        }
        int n = this.dragTargetListeners.size();
        for (int i = 0; i < n; ++i) {
            DragTargetListener dragTargetListener = (DragTargetListener)this.dragTargetListeners.elementAt(i);
            dragTargetListener.destinationLeft(leaveDragDestinationEvent);
        }
    }

    protected void fireDeleteDragDataEvent(DeleteDragDataEvent deleteDragDataEvent) {
        if (this.dragOriginListeners == null) {
            return;
        }
        int n = this.dragOriginListeners.size();
        for (int i = 0; i < n; ++i) {
            DragOriginListener dragOriginListener = (DragOriginListener)this.dragOriginListeners.elementAt(i);
            dragOriginListener.dataDeleted(deleteDragDataEvent);
        }
    }

    protected boolean fireDropDragEvent(DropDragEvent dropDragEvent) {
        boolean bl = false;
        if (this.dragTargetListeners == null) {
            return false;
        }
        int n = this.dragTargetListeners.size();
        for (int i = 0; i < n; ++i) {
            DragTargetListener dragTargetListener = (DragTargetListener)this.dragTargetListeners.elementAt(i);
            if (!dragTargetListener.dropped(dropDragEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected void fireEndDragEvent(EndDragEvent endDragEvent) {
        if (this.dragOriginListeners == null) {
            return;
        }
        int n = this.dragOriginListeners.size();
        for (int i = 0; i < n; ++i) {
            DragOriginListener dragOriginListener = (DragOriginListener)this.dragOriginListeners.elementAt(i);
            dragOriginListener.dragEnded(endDragEvent);
        }
    }

    protected void fireRequestDragDataEvent(RequestDragDataEvent requestDragDataEvent) {
        if (this.dragOriginListeners == null) {
            return;
        }
        int n = this.dragOriginListeners.size();
        for (int i = 0; i < n; ++i) {
            DragOriginListener dragOriginListener = (DragOriginListener)this.dragOriginListeners.elementAt(i);
            dragOriginListener.dataRequested(requestDragDataEvent);
        }
    }

    protected void handleDragStarted(Handle handle) {
        StartDragEvent startDragEvent = new StartDragEvent(this, StartDragEvent.Type.START, this.getDragContext(handle));
        this.fireStartDragEvent(startDragEvent);
    }

    protected void handleDragDataDeleted(Handle handle) {
        DeleteDragDataEvent deleteDragDataEvent = new DeleteDragDataEvent(this, DeleteDragDataEvent.Type.DATA_DELETE, this.getDragContext(handle));
        this.fireDeleteDragDataEvent(deleteDragDataEvent);
    }

    protected boolean handleDragDropped(Handle handle, int n, int n2, int n3) {
        DragContext dragContext = this.getDragContext(handle);
        DragEvent dragEvent = new DragEvent(this, DropDragEvent.Type.DROP, dragContext);
        DropDragEvent dropDragEvent = new DropDragEvent(dragEvent, n, n2, n3);
        return this.fireDropDragEvent(dropDragEvent);
    }

    protected void handleDragEnded(Handle handle) {
        EndDragEvent endDragEvent = new EndDragEvent(this, EndDragEvent.Type.END, this.getDragContext(handle));
        this.fireEndDragEvent(endDragEvent);
    }

    protected void handleDragDataReceived(Handle handle, int n, int n2, Handle handle2, int n3, int n4) {
        SelectionData selectionData = this.getSelectionData(handle2);
        DragContext dragContext = this.getDragContext(handle);
        DragEvent dragEvent = new DragEvent(this, ReceiveDragDataEvent.Type.DATA_RECEIVE, dragContext);
        ReceiveDragDataEvent receiveDragDataEvent = new ReceiveDragDataEvent(dragEvent, n, n2, selectionData, n3, n4);
        this.fireReceiveDragDataEvent(receiveDragDataEvent);
    }

    protected void handleDragDestinationLeft(Handle handle, int n) {
        DragEvent dragEvent = new DragEvent(this, LeaveDragDestinationEvent.Type.LEAVE_DESTINATION, this.getDragContext(handle));
        LeaveDragDestinationEvent leaveDragDestinationEvent = new LeaveDragDestinationEvent(dragEvent, n);
        this.fireLeaveDragDestinationEvent(leaveDragDestinationEvent);
    }

    protected boolean handleDragMotionOccurred(Handle handle, int n, int n2, int n3) {
        DragEvent dragEvent = new DragEvent(this, DragMotionEvent.Type.MOTION, this.getDragContext(handle));
        DragMotionEvent dragMotionEvent = new DragMotionEvent(dragEvent, n, n2, n3);
        return this.fireDragMotionEvent(dragMotionEvent);
    }

    protected void handleDragDataRequested(Handle handle, Handle handle2, int n, int n2) {
        SelectionData selectionData = this.getSelectionData(handle2);
        DragContext dragContext = this.getDragContext(handle);
        DragEvent dragEvent = new DragEvent(this, RequestDragDataEvent.Type.DATA_REQUEST, dragContext);
        RequestDragDataEvent requestDragDataEvent = new RequestDragDataEvent(dragEvent, selectionData, n, n2);
        this.fireRequestDragDataEvent(requestDragDataEvent);
    }

    private SelectionData getSelectionData(Handle handle) {
        SelectionData selectionData = (SelectionData)Boxed.getBoxedFromHandle((Handle)handle);
        if (selectionData == null) {
            selectionData = new SelectionData(handle);
        }
        return selectionData;
    }

    private DragContext getDragContext(Handle handle) {
        DragContext dragContext = (DragContext)GObject.getGObjectFromHandle((Handle)handle);
        if (dragContext == null) {
            dragContext = new DragContext(handle);
        }
        return dragContext;
    }

    public void addListener(ExposeListener exposeListener) {
        this.checkState();
        int n = Widget.findListener(this.exposeListeners, exposeListener);
        if (n == -1) {
            if (this.exposeListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ExposeEvent.Type.EXPOSE);
                evtMap.initialize((GObject)this, (EventType)ExposeEvent.Type.NO_EXPOSE);
                this.exposeListeners = new Vector();
            }
            this.exposeListeners.addElement(exposeListener);
        }
    }

    public void removeListener(ExposeListener exposeListener) {
        this.checkState();
        int n = Widget.findListener(this.exposeListeners, exposeListener);
        if (n > -1) {
            this.exposeListeners.remove(n);
        }
        if (this.exposeListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ExposeEvent.Type.EXPOSE);
            evtMap.uninitialize((GObject)this, (EventType)ExposeEvent.Type.NO_EXPOSE);
            this.exposeListeners = null;
        }
    }

    protected boolean fireExposeEvent(ExposeEvent exposeEvent) {
        if (this.exposeListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.exposeListeners.size();
        for (int i = 0; i < n; ++i) {
            ExposeListener exposeListener = (ExposeListener)this.exposeListeners.elementAt(i);
            if (!exposeListener.exposeEvent(exposeEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleExpose(Handle handle) {
        return this.fireExposeEvent(new ExposeEvent((Object)this, EventExpose.getEventExpose(handle)));
    }

    protected boolean handleNoExpose(Handle handle) {
        return this.fireExposeEvent(new ExposeEvent((Object)this, EventExpose.getEventExpose(handle)));
    }

    public void addListener(MouseMotionListener mouseMotionListener) {
        this.addEvents(EventMask.POINTER_MOTION_MASK);
        this.checkState();
        int n = Widget.findListener(this.mouseMotionListeners, mouseMotionListener);
        if (n == -1) {
            if (this.mouseMotionListeners == null) {
                evtMap.initialize((GObject)this, (EventType)MouseMotionEvent.Type.MOTION);
                this.mouseMotionListeners = new Vector();
            }
            this.mouseMotionListeners.addElement(mouseMotionListener);
        }
    }

    public void removeListener(MouseMotionListener mouseMotionListener) {
        this.checkState();
        int n = Widget.findListener(this.mouseMotionListeners, mouseMotionListener);
        if (n > -1) {
            this.mouseMotionListeners.remove(n);
        }
        if (this.mouseMotionListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)MouseMotionEvent.Type.MOTION);
            this.mouseMotionListeners = null;
        }
    }

    protected boolean fireMouseMotionEvent(MouseMotionEvent mouseMotionEvent) {
        if (this.mouseMotionListeners == null) {
            return false;
        }
        boolean bl = false;
        int n = this.mouseMotionListeners.size();
        for (int i = 0; i < n; ++i) {
            MouseMotionListener mouseMotionListener = (MouseMotionListener)this.mouseMotionListeners.elementAt(i);
            if (!mouseMotionListener.mouseMotionEvent(mouseMotionEvent)) continue;
            bl = true;
        }
        return bl;
    }

    protected boolean handleMouseMotion(Handle handle) {
        return this.fireMouseMotionEvent(new MouseMotionEvent((Object)this, new EventMotion(handle)));
    }

    private Handle getHandle(Struct struct) {
        if (struct == null) {
            return null;
        }
        return struct.getHandle();
    }

    protected static final native int gtk_widget_get_type();

    protected static final native void gtk_widget_destroy(Handle var0);

    protected static final native void gtk_widget_destroyed(Handle var0, Handle[] var1);

    protected static final native void gtk_widget_unparent(Handle var0);

    protected static final native void gtk_widget_show(Handle var0);

    protected static final native void gtk_widget_show_now(Handle var0);

    protected static final native void gtk_widget_hide(Handle var0);

    protected static final native void gtk_widget_show_all(Handle var0);

    protected static final native void gtk_widget_hide_all(Handle var0);

    protected static final native void gtk_widget_map(Handle var0);

    protected static final native void gtk_widget_unmap(Handle var0);

    protected static final native void gtk_widget_realize(Handle var0);

    protected static final native void gtk_widget_unrealize(Handle var0);

    protected static final native void gtk_widget_queue_draw(Handle var0);

    protected static final native void gtk_widget_queue_draw_area(Handle var0, int var1, int var2, int var3, int var4);

    protected static final native void gtk_widget_queue_resize(Handle var0);

    protected static final native void gtk_widget_size_request(Handle var0, Handle var1);

    protected static final native void gtk_widget_get_child_requisition(Handle var0, Handle[] var1);

    protected static final native void gtk_widget_size_allocate(Handle var0, Handle var1);

    protected static final native void gtk_widget_add_accelerator(Handle var0, Handle var1, int var2, int var3, int var4);

    protected static final native boolean gtk_widget_remove_accelerator(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gtk_widget_set_accel_path(Handle var0, String var1, Handle var2);

    protected static final native Handle gtk_widget_list_accel_closures(Handle var0);

    protected static final native boolean gtk_widget_can_activate_accel(Handle var0, int var1);

    protected static final native boolean gtk_widget_mnemonic_activate(Handle var0, boolean var1);

    protected static final native boolean gtk_widget_event(Handle var0, Handle var1);

    protected static final native int gtk_widget_send_expose(Handle var0, Handle var1);

    protected static final native boolean gtk_widget_activate(Handle var0);

    protected static final native void gtk_widget_set_scroll_adjustments(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_widget_reparent(Handle var0, Handle var1);

    protected static final native Handle gtk_widget_intersect(Handle var0, Handle var1);

    protected static final native Handle gtk_widget_region_intersect(Handle var0, Handle var1);

    protected static final native void gtk_widget_freeze_child_notify(Handle var0);

    protected static final native void gtk_widget_child_notify(Handle var0, String var1);

    protected static final native void gtk_widget_thaw_child_notify(Handle var0);

    protected static final native boolean gtk_widget_is_focus(Handle var0);

    protected static final native void gtk_widget_grab_focus(Handle var0);

    protected static final native void gtk_widget_grab_default(Handle var0);

    protected static final native void gtk_widget_set_name(Handle var0, String var1);

    protected static final native String gtk_widget_get_name(Handle var0);

    protected static final native void gtk_widget_set_state(Handle var0, int var1);

    protected static final native void gtk_widget_set_sensitive(Handle var0, boolean var1);

    protected static final native void gtk_widget_set_app_paintable(Handle var0, boolean var1);

    protected static final native void gtk_widget_set_double_buffered(Handle var0, boolean var1);

    protected static final native void gtk_widget_set_redraw_on_allocate(Handle var0, boolean var1);

    protected static final native void gtk_widget_set_parent(Handle var0, Handle var1);

    protected static final native void gtk_widget_set_parent_window(Handle var0, Handle var1);

    protected static final native void gtk_widget_set_child_visible(Handle var0, boolean var1);

    protected static final native boolean gtk_widget_get_child_visible(Handle var0);

    protected static final native Handle gtk_widget_get_parent(Handle var0);

    protected static final native Handle gtk_widget_get_parent_window(Handle var0);

    protected static final native Handle gtk_widget_get_window(Handle var0);

    protected static final native boolean gtk_widget_child_focus(Handle var0, int var1);

    protected static final native void gtk_widget_set_size_request(Handle var0, int var1, int var2);

    protected static final native void gtk_widget_get_size_request(Handle var0, int[] var1, int[] var2);

    protected static final native void gtk_widget_set_events(Handle var0, int var1);

    protected static final native void gtk_widget_add_events(Handle var0, int var1);

    protected static final native void gtk_widget_set_extension_events(Handle var0, int var1);

    protected static final native int gtk_widget_get_extension_events(Handle var0);

    protected static final native Handle gtk_widget_get_toplevel(Handle var0);

    protected static final native Handle gtk_widget_get_ancestor(Handle var0, int var1);

    protected static final native Handle gtk_widget_get_colormap(Handle var0);

    protected static final native Handle gtk_widget_get_visual(Handle var0);

    protected static final native Handle gtk_widget_get_screen(Handle var0);

    protected static final native boolean gtk_widget_has_screen(Handle var0);

    protected static final native Handle gtk_widget_get_display(Handle var0);

    protected static final native Handle gtk_widget_get_root_window(Handle var0);

    protected static final native boolean gtk_widget_get_sensitive(Handle var0);

    protected static final native Handle gtk_widget_get_settings(Handle var0);

    protected static final native Handle gtk_widget_get_accessible(Handle var0);

    protected static final native void gtk_widget_set_colormap(Handle var0, Handle var1);

    protected static final native int gtk_widget_get_events(Handle var0);

    protected static final native void gtk_widget_get_pointer(Handle var0, int[] var1, int[] var2);

    protected static final native boolean gtk_widget_is_ancestor(Handle var0, Handle var1);

    protected static final native boolean gtk_widget_translate_coordinates(Handle var0, Handle var1, int var2, int var3, int[] var4, int[] var5);

    protected static final native boolean gtk_widget_hide_on_delete(Handle var0);

    protected static final native void gtk_widget_set_style(Handle var0, Handle var1);

    protected static final native void gtk_widget_ensure_style(Handle var0);

    protected static final native Handle gtk_widget_get_style(Handle var0);

    protected static final native void gtk_widget_modify_style(Handle var0, Handle var1);

    protected static final native Handle gtk_widget_get_modifier_style(Handle var0);

    protected static final native void gtk_widget_modify_fg(Handle var0, int var1, Handle var2);

    protected static final native void gtk_widget_modify_bg(Handle var0, int var1, Handle var2);

    protected static final native void gtk_widget_modify_text(Handle var0, int var1, Handle var2);

    protected static final native void gtk_widget_modify_base(Handle var0, int var1, Handle var2);

    protected static final native void gtk_widget_modify_font(Handle var0, Handle var1);

    protected static final native Handle gtk_widget_create_pango_context(Handle var0);

    protected static final native Handle gtk_widget_get_pango_context(Handle var0);

    protected static final native Handle gtk_widget_create_pango_layout(Handle var0, String var1);

    protected static final native Handle gtk_widget_render_icon(Handle var0, String var1, int var2, String var3);

    protected static final native void gtk_widget_set_composite_name(Handle var0, String var1);

    protected static final native String gtk_widget_get_composite_name(Handle var0);

    protected static final native void gtk_widget_reset_rc_styles(Handle var0);

    protected static final native void gtk_widget_push_colormap(Handle var0);

    protected static final native void gtk_widget_pop_colormap();

    protected static final native void gtk_widget_push_composite_child();

    protected static final native void gtk_widget_pop_composite_child();

    protected static final native void gtk_widget_style_get_property(Handle var0, String var1, Handle var2);

    protected static final native void gtk_widget_set_default_colormap(Handle var0);

    protected static final native Handle gtk_widget_get_default_colormap();

    protected static final native Handle gtk_widget_get_default_visual();

    protected static final native Handle gtk_widget_get_default_style();

    protected static final native void gtk_widget_set_direction(Handle var0, int var1);

    protected static final native int gtk_widget_get_direction(Handle var0);

    protected static final native void gtk_widget_set_default_direction(int var0);

    protected static final native int gtk_widget_get_default_direction();

    protected static final native void gtk_widget_shape_combine_mask(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gtk_widget_path(Handle var0, int[] var1, String[] var2, String[] var3);

    protected static final native void gtk_widget_class_path(Handle var0, int[] var1, String[] var2, String[] var3);

    protected static final native Handle[] gtk_widget_list_mnemonic_labels(Handle var0);

    protected static final native void gtk_widget_add_mnemonic_label(Handle var0, Handle var1);

    protected static final native void gtk_widget_remove_mnemonic_label(Handle var0, Handle var1);

    protected static final native Allocation gtk_widget_get_allocation(Handle var0);

    protected static final native void gtk_drag_source_set(Handle var0, int var1, Handle[] var2, int var3);

    protected static final native void gtk_drag_source_unset(Handle var0);

    protected static final native void gtk_drag_source_set_icon(Handle var0, Handle var1, Handle var2, Handle var3);

    protected static final native void gtk_drag_source_set_icon_pixbuf(Handle var0, Handle var1);

    protected static final native void gtk_drag_source_set_icon_stock(Handle var0, String var1);

    protected static final native void gtk_drag_get_data(Handle var0, Handle var1, Handle var2, int var3);

    protected static final native void gtk_drag_finish(Handle var0, boolean var1, boolean var2, int var3);

    protected static final native void gtk_drag_highlight(Handle var0);

    protected static final native void gtk_drag_unhighlight(Handle var0);

    protected static final native void gtk_drag_dest_set(Handle var0, int var1, Handle[] var2, int var3);

    protected static final native void gtk_drag_dest_unset(Handle var0);

    static {
        Widget.addEvents(evtMap);
    }
}

