/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.Action;
import org.gnu.gtk.ActionGroup;
import org.gnu.gtk.UIManagerItemType;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.UIManagerEvent;
import org.gnu.gtk.event.UIManagerListener;

public class UIManager
extends GObject {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    public UIManager() {
        super(UIManager.gtk_ui_manager_new());
    }

    public void setAddTearoffs(boolean bl) {
        UIManager.gtk_ui_manager_set_add_tearoffs(this.getHandle(), bl);
    }

    public boolean getAddTearoffs() {
        return UIManager.gtk_ui_manager_get_add_tearoffs(this.getHandle());
    }

    public void insertActionGroup(ActionGroup actionGroup, int n) {
        UIManager.gtk_ui_manager_insert_action_group(this.getHandle(), actionGroup.getHandle(), n);
    }

    public void removeActionGroup(ActionGroup actionGroup) {
        UIManager.gtk_ui_manager_remove_action_group(this.getHandle(), actionGroup.getHandle());
    }

    public List getActionGroups() {
        Handle[] handleArray = UIManager.gtk_ui_manager_get_action_groups(this.getHandle());
        ArrayList<GObject> arrayList = new ArrayList<GObject>();
        for (int i = 0; i < handleArray.length; ++i) {
            GObject gObject = GObject.getGObjectFromHandle((Handle)handleArray[i]);
            if (gObject != null) {
                arrayList.add(gObject);
                continue;
            }
            arrayList.add(ActionGroup.getActionGroup(handleArray[i]));
        }
        return arrayList;
    }

    public AccelGroup getAccelGroup() {
        Handle handle = UIManager.gtk_ui_manager_get_accel_group(this.getHandle());
        return AccelGroup.getAccelGroup(handle);
    }

    public Widget getWidget(String string) {
        Handle handle = UIManager.gtk_ui_manager_get_widget(this.getHandle(), string);
        return Widget.getWidget(handle);
    }

    public Widget[] getToplevels(UIManagerItemType uIManagerItemType) {
        Handle[] handleArray = UIManager.gtk_ui_manager_get_toplevels(this.getHandle(), uIManagerItemType.getValue());
        Widget[] widgetArray = new Widget[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            widgetArray[i] = Widget.getWidget(handleArray[i]);
        }
        return widgetArray;
    }

    public Action getAction(String string) {
        return Action.getAction(UIManager.gtk_ui_manager_get_action(this.getHandle(), string));
    }

    public int addUIFromString(String string) {
        int n = UIManager.gtk_ui_manager_add_ui_from_string(this.getHandle(), string, string.length());
        if (n == 0) {
            throw new RuntimeException("An error occurred adding UI from String");
        }
        return n;
    }

    public int addUIFromFile(String string) {
        int n = UIManager.gtk_ui_manager_add_ui_from_file(this.getHandle(), string);
        if (n == 0) {
            throw new RuntimeException("An error occurred adding UI from file");
        }
        return n;
    }

    public int addUIFromReader(Reader reader) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return this.addUIFromString(stringBuffer.toString());
    }

    public void addUI(int n, String string, String string2, String string3, UIManagerItemType uIManagerItemType, boolean bl) {
        UIManager.gtk_ui_manager_add_ui(this.getHandle(), n, string, string2, string3, uIManagerItemType.getValue(), bl);
    }

    public void removeUI(int n) {
        UIManager.gtk_ui_manager_remove_ui(this.getHandle(), n);
    }

    public String getUI() {
        return UIManager.gtk_ui_manager_get_ui(this.getHandle());
    }

    public void ensureUpdate() {
        UIManager.gtk_ui_manager_ensure_update(this.getHandle());
    }

    public int newMergeId() {
        return UIManager.gtk_ui_manager_new_merge_id(this.getHandle());
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("add_widget", "handleAddWidget", (EventType)UIManagerEvent.Type.ADD_WIDGET, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
        eventMap.addEvent("actions_changed", "handleActionsChanged", (EventType)UIManagerEvent.Type.ACTIONS_CHANGED, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
        eventMap.addEvent("connect_proxy", "handleConnectProxy", (EventType)UIManagerEvent.Type.CONNECT_PROXY, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
        eventMap.addEvent("disconnect_proxy", "handleDisconnectProxy", (EventType)UIManagerEvent.Type.DISCONNECT_PROXY, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
        eventMap.addEvent("pre_activate", "handlePreActivate", (EventType)UIManagerEvent.Type.PRE_ACTIVATE, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
        eventMap.addEvent("post_activate", "handlePostActivate", (EventType)UIManagerEvent.Type.POST_ACTIVATE, UIManager.class$("org.gnu.gtk.event.UIManagerListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addListener(UIManagerListener uIManagerListener) {
        int n = UIManager.findListener(this.listeners, uIManagerListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.ACTIONS_CHANGED);
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.ADD_WIDGET);
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.CONNECT_PROXY);
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.DISCONNECT_PROXY);
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.POST_ACTIVATE);
                evtMap.initialize((GObject)this, (EventType)UIManagerEvent.Type.PRE_ACTIVATE);
                this.listeners = new Vector();
            }
            this.listeners.addElement(uIManagerListener);
        }
    }

    public void removeListener(UIManagerListener uIManagerListener) {
        int n = UIManager.findListener(this.listeners, uIManagerListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.ACTIONS_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.ADD_WIDGET);
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.CONNECT_PROXY);
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.DISCONNECT_PROXY);
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.POST_ACTIVATE);
            evtMap.uninitialize((GObject)this, (EventType)UIManagerEvent.Type.PRE_ACTIVATE);
            this.listeners = null;
        }
    }

    protected void fireUIManagerEvent(UIManagerEvent uIManagerEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            UIManagerListener uIManagerListener = (UIManagerListener)this.listeners.elementAt(i);
            uIManagerListener.uiManagerEvent(uIManagerEvent);
        }
    }

    private void handleAddWidget(Handle handle) {
    }

    private void handleActionsChanged() {
    }

    private void handleConnectProxy(Handle handle, Handle handle2) {
    }

    private void handleDisconnectProxy(Handle handle, Handle handle2) {
    }

    private void handlePreActivate(Handle handle) {
    }

    private void handlePostActivate(Handle handle) {
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    protected static final native int gtk_ui_manager_get_type();

    protected static final native Handle gtk_ui_manager_new();

    protected static final native void gtk_ui_manager_set_add_tearoffs(Handle var0, boolean var1);

    protected static final native boolean gtk_ui_manager_get_add_tearoffs(Handle var0);

    protected static final native void gtk_ui_manager_insert_action_group(Handle var0, Handle var1, int var2);

    protected static final native void gtk_ui_manager_remove_action_group(Handle var0, Handle var1);

    protected static final native Handle[] gtk_ui_manager_get_action_groups(Handle var0);

    protected static final native Handle gtk_ui_manager_get_accel_group(Handle var0);

    protected static final native Handle gtk_ui_manager_get_widget(Handle var0, String var1);

    protected static final native Handle[] gtk_ui_manager_get_toplevels(Handle var0, int var1);

    protected static final native Handle gtk_ui_manager_get_action(Handle var0, String var1);

    protected static final native int gtk_ui_manager_add_ui_from_string(Handle var0, String var1, int var2);

    protected static final native int gtk_ui_manager_add_ui_from_file(Handle var0, String var1);

    protected static final native void gtk_ui_manager_add_ui(Handle var0, int var1, String var2, String var3, String var4, int var5, boolean var6);

    protected static final native void gtk_ui_manager_remove_ui(Handle var0, int var1);

    protected static final native String gtk_ui_manager_get_ui(Handle var0);

    protected static final native void gtk_ui_manager_ensure_update(Handle var0);

    protected static final native int gtk_ui_manager_new_merge_id(Handle var0);

    static {
        UIManager.addEvents(evtMap);
    }
}

