/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Hashtable;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.DataColumnInt;
import org.gnu.gtk.SortType;
import org.gnu.gtk.TreeIterComparison;
import org.gnu.gtk.TreeSortable;

public class TreeSortableHelper {
    private static Hashtable sortMethods = null;

    private TreeSortableHelper() {
    }

    public static void setSortColumn(TreeSortable treeSortable, DataColumn dataColumn, SortType sortType) {
        TreeSortableHelper.gtk_tree_sortable_set_sort_column_id(treeSortable.getHandle(), dataColumn.getColumn(), sortType.getValue());
    }

    public static DataColumn getSortColumn(TreeSortable treeSortable) {
        int n = TreeSortableHelper.gtk_tree_sortable_get_sort_column_id(treeSortable.getHandle());
        if (n < 0) {
            return null;
        }
        DataColumnInt dataColumnInt = new DataColumnInt();
        dataColumnInt.setColumn(n);
        return dataColumnInt;
    }

    public static SortType getSortOrder(TreeSortable treeSortable) {
        int n = TreeSortableHelper.gtk_tree_sortable_get_sort_column_order(treeSortable.getHandle());
        if (n == -1) {
            return null;
        }
        return SortType.intern(n);
    }

    public static void setSortMethod(TreeSortable treeSortable, TreeIterComparison treeIterComparison, DataColumn dataColumn) {
        Hashtable<Integer, TreeIterComparison> hashtable;
        if (sortMethods == null) {
            sortMethods = new Hashtable();
        }
        if ((hashtable = (Hashtable<Integer, TreeIterComparison>)sortMethods.get(treeSortable)) == null) {
            hashtable = new Hashtable<Integer, TreeIterComparison>();
            sortMethods.put(treeSortable, hashtable);
        }
        hashtable.put(new Integer(dataColumn.getColumn()), treeIterComparison);
        TreeSortableHelper.gtk_tree_sortable_set_sort_func(treeSortable.getHandle(), treeSortable, "handleCompareFunc", dataColumn.getColumn());
    }

    public static TreeIterComparison getMethod(TreeSortable treeSortable, int n) {
        Hashtable hashtable = (Hashtable)sortMethods.get(treeSortable);
        if (hashtable == null) {
            return null;
        }
        return (TreeIterComparison)hashtable.get(new Integer(n));
    }

    public static Type getType() {
        return new Type(TreeSortableHelper.gtk_tree_sortable_get_type());
    }

    private static final native void gtk_tree_sortable_set_sort_column_id(Handle var0, int var1, int var2);

    private static final native int gtk_tree_sortable_get_sort_column_id(Handle var0);

    private static final native int gtk_tree_sortable_get_sort_column_order(Handle var0);

    private static final native void gtk_tree_sortable_set_sort_func(Handle var0, TreeSortable var1, String var2, int var3);

    private static final native int gtk_tree_sortable_get_type();
}

