/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.SelectionMode;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreePath;
import org.gnu.gtk.TreeSelectionForEach;
import org.gnu.gtk.TreeView;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.TreeSelectionEvent;
import org.gnu.gtk.event.TreeSelectionListener;

public class TreeSelection
extends GObject {
    private TreeSelectionForEach curForEach;
    private Vector selectionListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.selectionListeners = null;
    }

    protected TreeSelection(Handle handle) {
        super(handle);
        this.finit$();
    }

    protected static TreeSelection getTreeSelection(Handle handle) {
        if (handle == null) {
            return null;
        }
        TreeSelection treeSelection = (TreeSelection)GObject.getGObjectFromHandle((Handle)handle);
        if (treeSelection == null) {
            treeSelection = new TreeSelection(handle);
        }
        return treeSelection;
    }

    public void forEachSelected(TreeSelectionForEach treeSelectionForEach) {
        this.curForEach = treeSelectionForEach;
        TreeSelection.startForEach(this.getHandle(), this);
    }

    private void doEach(Handle handle, Handle handle2, Handle handle3) {
        TreeModel treeModel = TreeModel.getTreeModel(handle);
        this.curForEach.forEach(treeModel, TreePath.getTreePath(handle2), TreeIter.getTreeIter(handle3, treeModel));
    }

    public void setMode(SelectionMode selectionMode) {
        TreeSelection.gtk_tree_selection_set_mode(this.getHandle(), selectionMode.getValue());
    }

    public SelectionMode getMode() {
        return SelectionMode.intern(TreeSelection.gtk_tree_selection_get_mode(this.getHandle()));
    }

    public TreeView getTreeView() {
        Handle handle = TreeSelection.gtk_tree_selection_get_tree_view(this.getHandle());
        return TreeView.getTreeView(handle);
    }

    public void select(TreePath treePath) {
        TreeSelection.gtk_tree_selection_select_path(this.getHandle(), treePath.getHandle());
    }

    public void unselect(TreePath treePath) {
        TreeSelection.gtk_tree_selection_unselect_path(this.getHandle(), treePath.getHandle());
    }

    public boolean getSelected(TreePath treePath) {
        return TreeSelection.gtk_tree_selection_path_is_selected(this.getHandle(), treePath.getHandle());
    }

    public void select(TreeIter treeIter) {
        TreeSelection.gtk_tree_selection_select_iter(this.getHandle(), treeIter.getHandle());
    }

    public void unselect(TreeIter treeIter) {
        TreeSelection.gtk_tree_selection_unselect_iter(this.getHandle(), treeIter.getHandle());
    }

    public boolean getSelected(TreeIter treeIter) {
        return TreeSelection.gtk_tree_selection_iter_is_selected(this.getHandle(), treeIter.getHandle());
    }

    public void selectAll() {
        TreeSelection.gtk_tree_selection_select_all(this.getHandle());
    }

    public void unselectAll() {
        TreeSelection.gtk_tree_selection_unselect_all(this.getHandle());
    }

    public void select(TreePath treePath, TreePath treePath2) {
        TreeSelection.gtk_tree_selection_select_range(this.getHandle(), treePath.getHandle(), treePath2.getHandle());
    }

    public void unselect(TreePath treePath, TreePath treePath2) {
        TreeSelection.gtk_tree_selection_unselect_range(this.getHandle(), treePath.getHandle(), treePath2.getHandle());
    }

    public TreePath[] getSelectedRows() {
        Handle[] handleArray = TreeSelection.gtk_tree_selection_get_selected_rows(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        TreePath[] treePathArray = new TreePath[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            treePathArray[i] = TreePath.getTreePath(handleArray[i]);
        }
        return treePathArray;
    }

    public int countRows() {
        return TreeSelection.gtk_tree_selection_count_selected_rows(this.getHandle());
    }

    public void addListener(TreeSelectionListener treeSelectionListener) {
        int n = Widget.findListener(this.selectionListeners, treeSelectionListener);
        if (n == -1) {
            if (this.selectionListeners == null) {
                evtMap.initialize((GObject)this, (EventType)TreeSelectionEvent.Type.CHANGED);
                this.selectionListeners = new Vector();
            }
            this.selectionListeners.addElement(treeSelectionListener);
        }
    }

    public void removeListener(TreeSelectionListener treeSelectionListener) {
        int n = Widget.findListener(this.selectionListeners, treeSelectionListener);
        if (n > -1) {
            this.selectionListeners.remove(n);
        }
        if (this.selectionListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TreeSelectionEvent.Type.CHANGED);
            this.selectionListeners = null;
        }
    }

    protected void fireSelectionEvent(TreeSelectionEvent treeSelectionEvent) {
        if (this.selectionListeners == null) {
            return;
        }
        int n = this.selectionListeners.size();
        for (int i = 0; i < n; ++i) {
            TreeSelectionListener treeSelectionListener = (TreeSelectionListener)this.selectionListeners.elementAt(i);
            treeSelectionListener.selectionChangedEvent(treeSelectionEvent);
        }
    }

    private void handleChanged() {
        this.fireSelectionEvent(new TreeSelectionEvent((Object)this));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("changed", "handleChanged", (EventType)TreeSelectionEvent.Type.CHANGED, TreeSelection.class$("org.gnu.gtk.event.TreeSelectionListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(TreeSelection.gtk_tree_selection_get_type());
    }

    private static final native void startForEach(Handle var0, TreeSelection var1);

    protected static final native int gtk_tree_selection_get_type();

    protected static final native void gtk_tree_selection_set_mode(Handle var0, int var1);

    protected static final native int gtk_tree_selection_get_mode(Handle var0);

    protected static final native Handle gtk_tree_selection_get_tree_view(Handle var0);

    protected static final native Handle[] gtk_tree_selection_get_selected_rows(Handle var0);

    protected static final native int gtk_tree_selection_count_selected_rows(Handle var0);

    protected static final native void gtk_tree_selection_select_path(Handle var0, Handle var1);

    protected static final native void gtk_tree_selection_unselect_path(Handle var0, Handle var1);

    protected static final native void gtk_tree_selection_select_iter(Handle var0, Handle var1);

    protected static final native void gtk_tree_selection_unselect_iter(Handle var0, Handle var1);

    protected static final native boolean gtk_tree_selection_path_is_selected(Handle var0, Handle var1);

    protected static final native boolean gtk_tree_selection_iter_is_selected(Handle var0, Handle var1);

    protected static final native void gtk_tree_selection_select_all(Handle var0);

    protected static final native void gtk_tree_selection_unselect_all(Handle var0);

    protected static final native void gtk_tree_selection_select_range(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_tree_selection_unselect_range(Handle var0, Handle var1, Handle var2);

    static {
        TreeSelection.addEvents(evtMap);
    }
}

