/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class TreePath
extends Boxed {
    protected TreePath(Handle handle) {
        super(handle);
    }

    protected static TreePath getTreePath(Handle handle) {
        if (handle == null) {
            return null;
        }
        TreePath treePath = (TreePath)Boxed.getBoxedFromHandle((Handle)handle);
        if (treePath == null) {
            treePath = new TreePath(handle);
        }
        return treePath;
    }

    public TreePath() {
        super(TreePath.gtk_tree_path_new());
    }

    public TreePath(String string) {
        super(TreePath.gtk_tree_path_new_from_string(string));
    }

    public String toString() {
        return TreePath.gtk_tree_path_to_string(this.getHandle());
    }

    public int getDepth() {
        return TreePath.gtk_tree_path_get_depth(this.getHandle());
    }

    public int compare(TreePath treePath) {
        return TreePath.gtk_tree_path_compare(treePath.getHandle(), this.getHandle());
    }

    public void next() {
        TreePath.gtk_tree_path_next(this.getHandle());
    }

    public boolean previous() {
        return TreePath.gtk_tree_path_prev(this.getHandle());
    }

    public boolean up() {
        return TreePath.gtk_tree_path_up(this.getHandle());
    }

    public void down() {
        TreePath.gtk_tree_path_down(this.getHandle());
    }

    public boolean isAncestor(TreePath treePath) {
        return TreePath.gtk_tree_path_is_ancestor(this.getHandle(), treePath.getHandle());
    }

    public boolean isDescendant(TreePath treePath) {
        return TreePath.gtk_tree_path_is_descendant(this.getHandle(), treePath.getHandle());
    }

    public void appendIndex(int n) {
        TreePath.gtk_tree_path_append_index(this.getHandle(), n);
    }

    public void prependIndex(int n) {
        TreePath.gtk_tree_path_prepend_index(this.getHandle(), n);
    }

    public int[] getIndices() {
        return TreePath.gtk_tree_path_get_indices(this.getHandle());
    }

    protected static final native Handle gtk_tree_path_new();

    protected static final native Handle gtk_tree_path_new_from_string(String var0);

    protected static final native String gtk_tree_path_to_string(Handle var0);

    protected static final native Handle gtk_tree_path_new_first();

    protected static final native void gtk_tree_path_append_index(Handle var0, int var1);

    protected static final native void gtk_tree_path_prepend_index(Handle var0, int var1);

    protected static final native int gtk_tree_path_get_depth(Handle var0);

    protected static final native int[] gtk_tree_path_get_indices(Handle var0);

    protected static final native int gtk_tree_path_compare(Handle var0, Handle var1);

    protected static final native void gtk_tree_path_next(Handle var0);

    protected static final native boolean gtk_tree_path_prev(Handle var0);

    protected static final native boolean gtk_tree_path_up(Handle var0);

    protected static final native void gtk_tree_path_down(Handle var0);

    protected static final native boolean gtk_tree_path_is_ancestor(Handle var0, Handle var1);

    protected static final native boolean gtk_tree_path_is_descendant(Handle var0, Handle var1);
}

