/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.glib.Value;
import org.gnu.gtk.DataColumnBoolean;
import org.gnu.gtk.DataColumnDouble;
import org.gnu.gtk.DataColumnIconSize;
import org.gnu.gtk.DataColumnInt;
import org.gnu.gtk.DataColumnLong;
import org.gnu.gtk.DataColumnObject;
import org.gnu.gtk.DataColumnPixbuf;
import org.gnu.gtk.DataColumnStockItem;
import org.gnu.gtk.DataColumnString;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreePath;
import org.gnu.gtk.event.TreeModelEvent;
import org.gnu.gtk.event.TreeModelListener;

public class TreeModel
extends GObject {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    protected TreeModel(Handle handle) {
        super(handle);
        this.finit$();
    }

    protected static TreeModel getTreeModel(Handle handle) {
        if (handle == null) {
            return null;
        }
        TreeModel treeModel = (TreeModel)GObject.getGObjectFromHandle((Handle)handle);
        if (treeModel == null) {
            treeModel = new TreeModel(handle);
        }
        return treeModel;
    }

    public int getDataBlockCount() {
        return TreeModel.gtk_tree_model_get_n_columns(this.getHandle());
    }

    public int getColumnCount() {
        return TreeModel.gtk_tree_model_get_n_columns(this.getHandle());
    }

    public Type getType(int n) {
        return new Type(TreeModel.gtk_tree_model_get_column_type(this.getHandle(), n));
    }

    public TreeIter getIter(TreePath treePath) {
        Handle handle = TreeModel.gtk_tree_model_get_iter(this.getHandle(), treePath.getHandle());
        return this.iterFromHandle(handle);
    }

    public TreeIter getIter(String string) {
        Handle handle = TreeModel.gtk_tree_model_get_iter_from_string(this.getHandle(), string);
        return this.iterFromHandle(handle);
    }

    public TreeIter getFirstIter() {
        Handle handle = TreeModel.gtk_tree_model_get_iter_first(this.getHandle());
        return this.iterFromHandle(handle);
    }

    public String getValue(TreeIter treeIter, DataColumnString dataColumnString) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnString.getColumn());
        Value value = new Value(handle);
        return value.getString();
    }

    public int getValue(TreeIter treeIter, DataColumnInt dataColumnInt) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnInt.getColumn());
        Value value = new Value(handle);
        return value.getInt();
    }

    public long getValue(TreeIter treeIter, DataColumnLong dataColumnLong) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnLong.getColumn());
        Value value = new Value(handle);
        return value.getLong();
    }

    public boolean getValue(TreeIter treeIter, DataColumnBoolean dataColumnBoolean) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnBoolean.getColumn());
        Value value = new Value(handle);
        return value.getBoolean();
    }

    public double getValue(TreeIter treeIter, DataColumnDouble dataColumnDouble) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnDouble.getColumn());
        Value value = new Value(handle);
        return value.getDouble();
    }

    public Object getValue(TreeIter treeIter, DataColumnObject dataColumnObject) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnObject.getColumn());
        Value value = new Value(handle);
        return value.getJavaObject();
    }

    public Pixbuf getValue(TreeIter treeIter, DataColumnPixbuf dataColumnPixbuf) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnPixbuf.getColumn());
        Value value = new Value(handle);
        return (Pixbuf)((Object)value.getJavaObject());
    }

    public int getValue(TreeIter treeIter, DataColumnIconSize dataColumnIconSize) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnIconSize.getColumn());
        Value value = new Value(handle);
        return value.getInt();
    }

    public String getValue(TreeIter treeIter, DataColumnStockItem dataColumnStockItem) {
        Handle handle = TreeModel.gtk_tree_model_get_value(this.getHandle(), treeIter.getHandle(), dataColumnStockItem.getColumn());
        Value value = new Value(handle);
        return value.getString();
    }

    private TreeIter iterFromHandle(Handle handle) {
        return TreeIter.getTreeIter(handle, this);
    }

    public void addListener(TreeModelListener treeModelListener) {
        int n = TreeModel.findListener(this.listeners, treeModelListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_DELETED);
                evtMap.initialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_HAS_CHILD_TOGGLED);
                evtMap.initialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_INSERTED);
                evtMap.initialize((GObject)this, (EventType)TreeModelEvent.Type.ROWS_REORDERED);
                this.listeners = new Vector();
            }
            this.listeners.addElement(treeModelListener);
        }
    }

    public void removeListener(TreeModelListener treeModelListener) {
        int n = TreeModel.findListener(this.listeners, treeModelListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_DELETED);
            evtMap.uninitialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_HAS_CHILD_TOGGLED);
            evtMap.uninitialize((GObject)this, (EventType)TreeModelEvent.Type.ROW_INSERTED);
            evtMap.uninitialize((GObject)this, (EventType)TreeModelEvent.Type.ROWS_REORDERED);
            this.listeners = null;
        }
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    protected void fireTreeModelEvent(TreeModelEvent treeModelEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            TreeModelListener treeModelListener = (TreeModelListener)this.listeners.elementAt(i);
            treeModelListener.treeModelEvent(treeModelEvent);
        }
    }

    private void handleRowChanged(Handle handle, Handle handle2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, TreeModelEvent.Type.ROW_CHANGED);
        treeModelEvent.setTreePath(TreePath.getTreePath(handle));
        treeModelEvent.setTreeIter(TreeIter.getTreeIter(handle2, this));
        this.fireTreeModelEvent(treeModelEvent);
    }

    private void handleRowInserted(Handle handle, Handle handle2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, TreeModelEvent.Type.ROW_INSERTED);
        treeModelEvent.setTreePath(TreePath.getTreePath(handle));
        treeModelEvent.setTreeIter(TreeIter.getTreeIter(handle2, this));
        this.fireTreeModelEvent(treeModelEvent);
    }

    private void handleRowHasChildToggled(Handle handle, Handle handle2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, TreeModelEvent.Type.ROW_HAS_CHILD_TOGGLED);
        treeModelEvent.setTreePath(TreePath.getTreePath(handle));
        treeModelEvent.setTreeIter(TreeIter.getTreeIter(handle2, this));
        this.fireTreeModelEvent(treeModelEvent);
    }

    private void handleRowDeleted(Handle handle) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, TreeModelEvent.Type.ROW_DELETED);
        treeModelEvent.setTreePath(TreePath.getTreePath(handle));
        this.fireTreeModelEvent(treeModelEvent);
    }

    private void handleRowsReordered(Handle handle, Handle handle2, Handle handle3) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, TreeModelEvent.Type.ROWS_REORDERED);
        treeModelEvent.setTreePath(TreePath.getTreePath(handle));
        treeModelEvent.setTreeIter(TreeIter.getTreeIter(handle2, this));
        treeModelEvent.setNewOrder(new int[0]);
        this.fireTreeModelEvent(treeModelEvent);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("rows_reordered", "handleRowsReordered", (EventType)TreeModelEvent.Type.ROWS_REORDERED, TreeModel.class$("org.gnu.gtk.event.TreeModelListener"));
        eventMap.addEvent("row_changed", "handleRowChanged", (EventType)TreeModelEvent.Type.ROW_CHANGED, TreeModel.class$("org.gnu.gtk.event.TreeModelListener"));
        eventMap.addEvent("row_inserted", "handleRowInserted", (EventType)TreeModelEvent.Type.ROW_INSERTED, TreeModel.class$("org.gnu.gtk.event.TreeModelListener"));
        eventMap.addEvent("row_has_child_toggled", "handleRowHasChildToggled", (EventType)TreeModelEvent.Type.ROW_HAS_CHILD_TOGGLED, TreeModel.class$("org.gnu.gtk.event.TreeModelListener"));
        eventMap.addEvent("row_deleted", "handleRowDeleted", (EventType)TreeModelEvent.Type.ROW_DELETED, TreeModel.class$("org.gnu.gtk.event.TreeModelListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_tree_model_get_n_columns(Handle var0);

    protected static final native int gtk_tree_model_get_column_type(Handle var0, int var1);

    protected static final native Handle gtk_tree_model_get_iter(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_get_iter_from_string(Handle var0, String var1);

    protected static final native String gtk_tree_model_get_string_from_iter(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_get_iter_first(Handle var0);

    protected static final native Handle gtk_tree_model_get_path(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_get_value(Handle var0, Handle var1, int var2);

    protected static final native Handle gtk_tree_model_iter_next(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_iter_children(Handle var0, Handle var1);

    protected static final native boolean gtk_tree_model_iter_has_child(Handle var0, Handle var1);

    protected static final native int gtk_tree_model_iter_n_children(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_iter_nth_child(Handle var0, Handle var1, int var2);

    protected static final native Handle gtk_tree_model_iter_parent(Handle var0, Handle var1);

    static {
        TreeModel.addEvents(evtMap);
    }
}

