/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreePath;

public class TreeIter
extends Boxed {
    private TreeModel model;

    public TreeIter(Handle handle, TreeModel treeModel) {
        super(handle);
        this.model = treeModel;
    }

    protected static TreeIter getTreeIter(Handle handle, TreeModel treeModel) {
        if (handle == null) {
            return null;
        }
        TreeIter treeIter = (TreeIter)Boxed.getBoxedFromHandle((Handle)handle);
        if (treeIter == null) {
            treeIter = new TreeIter(handle, treeModel);
        }
        return treeIter;
    }

    public TreeModel getModel() {
        return this.model;
    }

    public TreePath getPath() {
        Handle handle = TreeIter.gtk_tree_model_get_path(this.model.getHandle(), this.getHandle());
        return TreePath.getTreePath(handle);
    }

    public TreeIter getNextIter() {
        Handle handle = TreeIter.gtk_tree_model_iter_next(this.model.getHandle(), this.getHandle());
        return this.iterFromHandle(handle);
    }

    public boolean getHasChild() {
        return TreeIter.gtk_tree_model_iter_has_child(this.model.getHandle(), this.getHandle());
    }

    public TreeIter getFirstChild() {
        Handle handle = TreeIter.gtk_tree_model_iter_children(this.model.getHandle(), this.getHandle());
        return this.iterFromHandle(handle);
    }

    public TreeIter getChild(int n) {
        Handle handle = TreeIter.gtk_tree_model_iter_nth_child(this.model.getHandle(), this.getHandle(), n);
        return this.iterFromHandle(handle);
    }

    public TreeIter getParent() {
        Handle handle = TreeIter.gtk_tree_model_get_parent(this.model.getHandle(), this.getHandle());
        return this.iterFromHandle(handle);
    }

    public int getChildCount() {
        return TreeIter.gtk_tree_model_iter_n_children(this.model.getHandle(), this.getHandle());
    }

    public String toString() {
        return TreeIter.gtk_tree_model_get_string_from_iter(this.model.getHandle(), this.getHandle());
    }

    private TreeIter iterFromHandle(Handle handle) {
        return TreeIter.getTreeIter(handle, this.model);
    }

    public static Type getType() {
        return new Type(TreeIter.gtk_tree_iter_get_type());
    }

    protected static final native int gtk_tree_iter_get_type();

    protected static final native void gtk_tree_iter_free(Handle var0);

    protected static final native String gtk_tree_model_get_string_from_iter(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_get_path(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_get_parent(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_iter_next(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_iter_children(Handle var0, Handle var1);

    protected static final native boolean gtk_tree_model_iter_has_child(Handle var0, Handle var1);

    protected static final native int gtk_tree_model_iter_n_children(Handle var0, Handle var1);

    protected static final native Handle gtk_tree_model_iter_nth_child(Handle var0, Handle var1, int var2);

    protected static final native Handle gtk_tree_model_iter_parent(Handle var0, Handle var1);
}

