/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Container;
import org.gnu.gtk.IconSize;
import org.gnu.gtk.Orientation;
import org.gnu.gtk.ReliefStyle;
import org.gnu.gtk.ToolBarStyle;
import org.gnu.gtk.ToolItem;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ToolBarEvent;
import org.gnu.gtk.event.ToolBarListener;

public class ToolBar
extends Container {
    private Vector tbListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.tbListeners = null;
    }

    public ToolBar() {
        super(ToolBar.gtk_toolbar_new());
        this.finit$();
    }

    public ToolBar(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static ToolBar getToolBar(Handle handle) {
        if (handle == null) {
            return null;
        }
        ToolBar toolBar = (ToolBar)GObject.getGObjectFromHandle((Handle)handle);
        if (toolBar == null) {
            toolBar = new ToolBar(handle);
        }
        return toolBar;
    }

    public void appendWidget(Widget widget, String string, String string2) {
        ToolBar.gtk_toolbar_append_widget(this.getHandle(), widget.getHandle(), string, string2);
    }

    public void prependWidget(Widget widget, String string, String string2) {
        ToolBar.gtk_toolbar_prepend_widget(this.getHandle(), widget.getHandle(), string, string2);
    }

    public void insertWidget(Widget widget, String string, String string2, int n) {
        ToolBar.gtk_toolbar_insert_widget(this.getHandle(), widget.getHandle(), string, string2, n);
    }

    public void appendSpace() {
        ToolBar.gtk_toolbar_append_space(this.getHandle());
    }

    public void prependSpace() {
        ToolBar.gtk_toolbar_prepend_space(this.getHandle());
    }

    public void insertSpace(int n) {
        ToolBar.gtk_toolbar_insert_space(this.getHandle(), n);
    }

    public void removeSpace(int n) {
        ToolBar.gtk_toolbar_remove_space(this.getHandle(), n);
    }

    public void setOrientation(Orientation orientation) {
        ToolBar.gtk_toolbar_set_orientation(this.getHandle(), orientation.getValue());
    }

    public void setStyle(ToolBarStyle toolBarStyle) {
        ToolBar.gtk_toolbar_set_style(this.getHandle(), toolBarStyle.getValue());
    }

    public boolean isToolTips() {
        return ToolBar.gtk_toolbar_get_tooltips(this.getHandle());
    }

    public void setToolTips(boolean bl) {
        ToolBar.gtk_toolbar_set_tooltips(this.getHandle(), bl);
    }

    public void setIconSize(IconSize iconSize) {
        ToolBar.gtk_toolbar_set_icon_size(this.getHandle(), iconSize.getValue());
    }

    public static Type getType() {
        return new Type(ToolBar.gtk_toolbar_get_type());
    }

    public void insert(ToolItem toolItem, int n) {
        ToolBar.gtk_toolbar_insert(this.getHandle(), toolItem.getHandle(), n);
    }

    public int getItemIndex(ToolItem toolItem) {
        return ToolBar.gtk_toolbar_get_item_index(this.getHandle(), toolItem.getHandle());
    }

    public int getNumItems() {
        return ToolBar.gtk_toolbar_get_n_items(this.getHandle());
    }

    public ToolItem getItem(int n) {
        Handle handle = ToolBar.gtk_toolbar_get_nth_item(this.getHandle(), n);
        return ToolItem.getToolItem(handle);
    }

    public boolean getShowArrow() {
        return ToolBar.gtk_toolbar_get_show_arrow(this.getHandle());
    }

    public void setShowArrow(boolean bl) {
        ToolBar.gtk_toolbar_set_show_arrow(this.getHandle(), bl);
    }

    public ReliefStyle getReliefStyle() {
        return ReliefStyle.intern(ToolBar.gtk_toolbar_get_relief_style(this.getHandle()));
    }

    public int getDropIndex(int n, int n2) {
        return ToolBar.gtk_toolbar_get_drop_index(this.getHandle(), n, n2);
    }

    public void setDropHighlightItem(ToolItem toolItem, int n) {
        ToolBar.gtk_toolbar_set_drop_highlight_item(this.getHandle(), toolItem.getHandle(), n);
    }

    public void addListener(ToolBarListener toolBarListener) {
        int n = Widget.findListener(this.tbListeners, toolBarListener);
        if (n == -1) {
            if (this.tbListeners == null) {
                evtMap.initialize((GObject)this, (EventType)ToolBarEvent.Type.ORIENTATION_CHANGED);
                evtMap.initialize((GObject)this, (EventType)ToolBarEvent.Type.POPUP_CONTEXT_MENU);
                evtMap.initialize((GObject)this, (EventType)ToolBarEvent.Type.STYLE_CHANGED);
                this.tbListeners = new Vector();
            }
            this.tbListeners.addElement(toolBarListener);
        }
    }

    public void removeListener(ToolBarListener toolBarListener) {
        int n = Widget.findListener(this.tbListeners, toolBarListener);
        if (n > -1) {
            this.tbListeners.remove(n);
        }
        if (this.tbListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ToolBarEvent.Type.ORIENTATION_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)ToolBarEvent.Type.POPUP_CONTEXT_MENU);
            evtMap.uninitialize((GObject)this, (EventType)ToolBarEvent.Type.STYLE_CHANGED);
            this.tbListeners = null;
        }
    }

    protected void fireToolBarEvent(ToolBarEvent toolBarEvent) {
        if (this.tbListeners == null) {
            return;
        }
        int n = this.tbListeners.size();
        for (int i = 0; i < n; ++i) {
            ToolBarListener toolBarListener = (ToolBarListener)this.tbListeners.elementAt(i);
            toolBarListener.toolBarEvent(toolBarEvent);
        }
    }

    private void handleOrientationChange(int n) {
        ToolBarEvent toolBarEvent = new ToolBarEvent((Object)this, ToolBarEvent.Type.ORIENTATION_CHANGED);
        toolBarEvent.setOrientation(Orientation.intern(n));
        this.fireToolBarEvent(toolBarEvent);
    }

    private void handleStyleChange(int n) {
        ToolBarEvent toolBarEvent = new ToolBarEvent((Object)this, ToolBarEvent.Type.STYLE_CHANGED);
        toolBarEvent.setStyle(ToolBarStyle.intern(n));
        this.fireToolBarEvent(toolBarEvent);
    }

    private boolean handlePopupContextMenu(int n, int n2, int n3) {
        ToolBarEvent toolBarEvent = new ToolBarEvent((Object)this, ToolBarEvent.Type.POPUP_CONTEXT_MENU);
        toolBarEvent.setX(n);
        toolBarEvent.setY(n2);
        toolBarEvent.setButtonNumber(n3);
        this.fireToolBarEvent(toolBarEvent);
        return true;
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("orientation_changed", "handleOrientationChange", (EventType)ToolBarEvent.Type.ORIENTATION_CHANGED, ToolBar.class$("org.gnu.gtk.event.ToolBarListener"));
        eventMap.addEvent("style_changed", "handleStyleChange", (EventType)ToolBarEvent.Type.STYLE_CHANGED, ToolBar.class$("org.gnu.gtk.event.ToolBarListener"));
        eventMap.addEvent("popup_context_menu", "handlePopupContextMenu", (EventType)ToolBarEvent.Type.POPUP_CONTEXT_MENU, ToolBar.class$("org.gnu.gtk.event.ToolBarListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_toolbar_get_type();

    protected static final native Handle gtk_toolbar_new();

    protected static final native void gtk_toolbar_set_orientation(Handle var0, int var1);

    protected static final native void gtk_toolbar_set_style(Handle var0, int var1);

    protected static final native void gtk_toolbar_set_tooltips(Handle var0, boolean var1);

    protected static final native void gtk_toolbar_unset_style(Handle var0);

    protected static final native int gtk_toolbar_get_orientation(Handle var0);

    protected static final native int gtk_toolbar_get_style(Handle var0);

    protected static final native int gtk_toolbar_get_icon_size(Handle var0);

    protected static final native boolean gtk_toolbar_get_tooltips(Handle var0);

    protected static final native void gtk_toolbar_append_space(Handle var0);

    protected static final native void gtk_toolbar_prepend_space(Handle var0);

    protected static final native void gtk_toolbar_insert_space(Handle var0, int var1);

    protected static final native void gtk_toolbar_remove_space(Handle var0, int var1);

    protected static final native void gtk_toolbar_append_widget(Handle var0, Handle var1, String var2, String var3);

    protected static final native void gtk_toolbar_prepend_widget(Handle var0, Handle var1, String var2, String var3);

    protected static final native void gtk_toolbar_insert_widget(Handle var0, Handle var1, String var2, String var3, int var4);

    protected static final native void gtk_toolbar_set_icon_size(Handle var0, int var1);

    protected static final native void gtk_toolbar_unset_icon_size(Handle var0);

    protected static final native void gtk_toolbar_insert(Handle var0, Handle var1, int var2);

    protected static final native int gtk_toolbar_get_item_index(Handle var0, Handle var1);

    protected static final native int gtk_toolbar_get_n_items(Handle var0);

    protected static final native Handle gtk_toolbar_get_nth_item(Handle var0, int var1);

    protected static final native boolean gtk_toolbar_get_show_arrow(Handle var0);

    protected static final native void gtk_toolbar_set_show_arrow(Handle var0, boolean var1);

    protected static final native int gtk_toolbar_get_relief_style(Handle var0);

    protected static final native int gtk_toolbar_get_drop_index(Handle var0, int var1, int var2);

    protected static final native void gtk_toolbar_set_drop_highlight_item(Handle var0, Handle var1, int var2);

    static {
        ToolBar.addEvents(evtMap);
    }
}

