/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Point;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Window;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Adjustment;
import org.gnu.gtk.Container;
import org.gnu.gtk.Justification;
import org.gnu.gtk.Menu;
import org.gnu.gtk.MovementStep;
import org.gnu.gtk.TextAttributes;
import org.gnu.gtk.TextBuffer;
import org.gnu.gtk.TextChildAnchor;
import org.gnu.gtk.TextIter;
import org.gnu.gtk.TextMark;
import org.gnu.gtk.TextWindowType;
import org.gnu.gtk.Widget;
import org.gnu.gtk.WrapMode;
import org.gnu.gtk.event.TextViewEvent;
import org.gnu.gtk.event.TextViewListener;
import org.gnu.pango.TabArray;

public class TextView
extends Container {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    public TextView() {
        super(TextView.gtk_text_view_new());
    }

    public TextView(TextBuffer textBuffer) {
        super(TextView.gtk_text_view_new_with_buffer(textBuffer.getHandle()));
    }

    public TextView(Handle handle) {
        super(handle);
    }

    public static TextView getTextView(Handle handle) {
        if (handle == null) {
            return null;
        }
        TextView textView = (TextView)GObject.getGObjectFromHandle((Handle)handle);
        if (textView == null) {
            textView = new TextView(handle);
        }
        return textView;
    }

    public void setBuffer(TextBuffer textBuffer) {
        TextView.gtk_text_view_set_buffer(this.getHandle(), textBuffer.getHandle());
    }

    public TextBuffer getBuffer() {
        Handle handle = TextView.gtk_text_view_get_buffer(this.getHandle());
        return TextBuffer.getTextBuffer(handle);
    }

    public void scrollToMark(TextMark textMark, double d, boolean bl, double d2, double d3) {
        TextView.gtk_text_view_scroll_to_mark(this.getHandle(), textMark.getHandle(), d, bl, d2, d3);
    }

    public void scrollToMark(TextMark textMark, double d) {
        TextView.gtk_text_view_scroll_to_mark(this.getHandle(), textMark.getHandle(), d, false, 0.0, 0.0);
    }

    public TextIter getIterAtLocation(int n, int n2) {
        Handle handle = TextView.gtk_text_view_get_iter_at_location(this.getHandle(), n, n2);
        return TextIter.getTextIter(handle);
    }

    public TextIter getIterAtLocation(Point point) {
        Handle handle = TextView.gtk_text_view_get_iter_at_location(this.getHandle(), point.getX(), point.getY());
        return TextIter.getTextIter(handle);
    }

    public Point windowToBufferCoords(TextWindowType textWindowType, int n, int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        TextView.gtk_text_view_window_to_buffer_coords(this.getHandle(), textWindowType.getValue(), n, n2, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public boolean scrollToIter(TextIter textIter, double d, double d2, double d3) {
        return TextView.gtk_text_view_scroll_to_iter(this.getHandle(), textIter.getHandle(), d, true, d2, d3);
    }

    public boolean scrollToIter(TextIter textIter, double d) {
        return TextView.gtk_text_view_scroll_to_iter(this.getHandle(), textIter.getHandle(), d, false, 0.0, 0.0);
    }

    public boolean moveCursorOnScreen() {
        return TextView.gtk_text_view_place_cursor_onscreen(this.getHandle());
    }

    public boolean moveMarkOnScreen(TextMark textMark) {
        return TextView.gtk_text_view_move_mark_onscreen(this.getHandle(), textMark.getHandle());
    }

    public void addChild(Widget widget, TextChildAnchor textChildAnchor) {
        TextView.gtk_text_view_add_child_at_anchor(this.getHandle(), widget.getHandle(), textChildAnchor.getHandle());
    }

    public WrapMode getWrapMode() {
        return WrapMode.intern(TextView.gtk_text_view_get_wrap_mode(this.getHandle()));
    }

    public void setWrapMode(WrapMode wrapMode) {
        TextView.gtk_text_view_set_wrap_mode(this.getHandle(), wrapMode.getValue());
    }

    public void setEditable(boolean bl) {
        TextView.gtk_text_view_set_editable(this.getHandle(), bl);
    }

    public boolean getEditable() {
        return TextView.gtk_text_view_get_editable(this.getHandle());
    }

    public boolean getCursorVisible() {
        return TextView.gtk_text_view_get_cursor_visible(this.getHandle());
    }

    public void setCursorVisible(boolean bl) {
        TextView.gtk_text_view_set_cursor_visible(this.getHandle(), bl);
    }

    public int getPixelsAboveLines() {
        return TextView.gtk_text_view_get_pixels_above_lines(this.getHandle());
    }

    public int getPixelsBelowLines() {
        return TextView.gtk_text_view_get_pixels_below_lines(this.getHandle());
    }

    public int getPixelsInsideWrap() {
        return TextView.gtk_text_view_get_pixels_inside_wrap(this.getHandle());
    }

    public void setPixelsAboveLines(int n) {
        TextView.gtk_text_view_set_pixels_above_lines(this.getHandle(), n);
    }

    public void setPixelsBelowLine(int n) {
        TextView.gtk_text_view_set_pixels_below_lines(this.getHandle(), n);
    }

    public void setPixelsBelowLines(int n) {
        TextView.gtk_text_view_set_pixels_below_lines(this.getHandle(), n);
    }

    public void setPixelsInsideWrap(int n) {
        TextView.gtk_text_view_set_pixels_inside_wrap(this.getHandle(), n);
    }

    public Justification getJustification() {
        return Justification.intern(TextView.gtk_text_view_get_justification(this.getHandle()));
    }

    public void setJustification(Justification justification) {
        TextView.gtk_text_view_set_justification(this.getHandle(), justification.getValue());
    }

    public int getLeftMargin() {
        return TextView.gtk_text_view_get_left_margin(this.getHandle());
    }

    public int getRightMargin() {
        return TextView.gtk_text_view_get_right_margin(this.getHandle());
    }

    public void setLeftMargin(int n) {
        TextView.gtk_text_view_set_left_margin(this.getHandle(), n);
    }

    public void setRightMargin(int n) {
        TextView.gtk_text_view_set_right_margin(this.getHandle(), n);
    }

    public int getIndent() {
        return TextView.gtk_text_view_get_indent(this.getHandle());
    }

    public void setIndent(int n) {
        TextView.gtk_text_view_set_indent(this.getHandle(), n);
    }

    public TabArray getTabs() {
        return TabArray.getTabArray(TextView.gtk_text_view_get_tabs(this.getHandle()));
    }

    public void setTabs(TabArray tabArray) {
        TextView.gtk_text_view_set_tabs(this.getHandle(), tabArray.getHandle());
    }

    public TextAttributes getDefaultAttributes() {
        Handle handle = TextView.gtk_text_view_get_default_attributes(this.getHandle());
        return TextAttributes.getTextAttributes(handle);
    }

    public void setAcceptsTab(boolean bl) {
        TextView.gtk_text_view_set_accepts_tab(this.getHandle(), bl);
    }

    public boolean getAcceptsTab() {
        return TextView.gtk_text_view_get_accepts_tab(this.getHandle());
    }

    public void setOverwrite(boolean bl) {
        TextView.gtk_text_view_set_overwrite(this.getHandle(), bl);
    }

    public boolean getOverwrite() {
        return TextView.gtk_text_view_get_overwrite(this.getHandle());
    }

    public Adjustment getHAdjustment() {
        return Adjustment.getAdjustment(TextView.getHAdjustment(this.getHandle()));
    }

    public Adjustment getVAdjustment() {
        return Adjustment.getAdjustment(TextView.getVAdjustment(this.getHandle()));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    public VerticalLineRange getLineYRange(TextIter textIter) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        TextView.gtk_text_view_get_line_yrange(this.getHandle(), textIter.getHandle(), nArray, nArray2);
        return new VerticalLineRange(nArray[0], nArray2[0]);
    }

    public Point bufferToWindowCoords(TextWindowType textWindowType, int n, int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        TextView.gtk_text_view_buffer_to_window_coords(this.getHandle(), textWindowType.getValue(), n, n2, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public void setBorderWindowSize(TextWindowType textWindowType, int n) {
        TextView.gtk_text_view_set_border_window_size(this.getHandle(), textWindowType.getValue(), n);
    }

    public int getBorderWindowSize(TextWindowType textWindowType) {
        return TextView.gtk_text_view_get_border_window_size(this.getHandle(), textWindowType.getValue());
    }

    public Window getWindow(TextWindowType textWindowType) {
        Handle handle = TextView.gtk_text_view_get_window(this.getHandle(), textWindowType.getValue());
        return Window.getWindowFromHandle(handle);
    }

    public TextWindowType getWindowType(Window window) {
        return TextWindowType.intern(TextView.gtk_text_view_get_window_type(this.getHandle(), window.getHandle()));
    }

    public void scrollMarkOnScreen(TextMark textMark) {
        TextView.gtk_text_view_scroll_mark_onscreen(this.getHandle(), textMark.getHandle());
    }

    public Rectangle getVisibleRectangle() {
        return Rectangle.getRectangle(TextView.gtk_text_view_get_visible_rect(this.getHandle()));
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("copy_clipboard", "handleCopyClipboard", (EventType)TextViewEvent.Type.COPY_CLIPBOARD, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("cut_clipboard", "handleCutClipboard", (EventType)TextViewEvent.Type.CUT_CLIPBOARD, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("paste_clipboard", "handlePasteClipboard", (EventType)TextViewEvent.Type.PASTE_CLIPBOARD, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("delete_from_cursor", "handleDeleteFromCursor", (EventType)TextViewEvent.Type.DELETE_FROM_CURSOR, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("insert_at_cursor", "handleInsertAtCursor", (EventType)TextViewEvent.Type.INSERT_AT_CURSOR, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("move_cursor", "handleMoveCursor", (EventType)TextViewEvent.Type.MOVE_CURSOR, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("move_focus", "handleMoveFocus", (EventType)TextViewEvent.Type.MOVE_FOCUS, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("page_horizontally", "handlePageHorizontally", (EventType)TextViewEvent.Type.PAGE_HORIZONTALLY, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("populate_popup", "handlePopulatePopup", (EventType)TextViewEvent.Type.POPULATE_POPUP, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("set_anchor", "handleSetAnchor", (EventType)TextViewEvent.Type.SET_ANCHOR, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("set_scroll_adjustments", "handleSetScrollAdjustments", (EventType)TextViewEvent.Type.SET_SCROLL_ADJUSTMENTS, TextView.class$("org.gnu.gtk.event.TextViewListener"));
        eventMap.addEvent("toggle_overwrite", "handleToggleOverwrite", (EventType)TextViewEvent.Type.TOGGLE_OVERWRITE, TextView.class$("org.gnu.gtk.event.TextViewListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addListener(TextViewListener textViewListener) {
        int n = Widget.findListener(this.listeners, textViewListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.COPY_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.CUT_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.PASTE_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.PASTE_CLIPBOARD);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.INSERT_AT_CURSOR);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.MOVE_CURSOR);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.MOVE_FOCUS);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.PAGE_HORIZONTALLY);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.POPULATE_POPUP);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.POPULATE_POPUP);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.SET_SCROLL_ADJUSTMENTS);
                evtMap.initialize((GObject)this, (EventType)TextViewEvent.Type.TOGGLE_OVERWRITE);
                this.listeners = new Vector();
            }
            this.listeners.addElement(textViewListener);
        }
    }

    public void removeListener(TextViewListener textViewListener) {
        int n = Widget.findListener(this.listeners, textViewListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.COPY_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.CUT_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.PASTE_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.PASTE_CLIPBOARD);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.INSERT_AT_CURSOR);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.MOVE_CURSOR);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.MOVE_FOCUS);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.PAGE_HORIZONTALLY);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.POPULATE_POPUP);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.POPULATE_POPUP);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.SET_SCROLL_ADJUSTMENTS);
            evtMap.uninitialize((GObject)this, (EventType)TextViewEvent.Type.TOGGLE_OVERWRITE);
            this.listeners = null;
        }
    }

    protected void fireTextViewEvent(TextViewEvent textViewEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            TextViewListener textViewListener = (TextViewListener)this.listeners.elementAt(i);
            textViewListener.textViewEvent(textViewEvent);
        }
    }

    private void handleCopyClipboard() {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.COPY_CLIPBOARD));
    }

    private void handleCutClipboard() {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.CUT_CLIPBOARD));
    }

    private void handlePasteClipboard() {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.PASTE_CLIPBOARD));
    }

    private void handleInsertAtCursor(String string) {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.INSERT_AT_CURSOR));
    }

    private void handleDeleteFromCursor(int n, int n2) {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.DELETE_FROM_CURSOR));
    }

    private void handleMoveCursor(int n, int n2, boolean bl) {
        TextViewEvent textViewEvent = new TextViewEvent((Object)this, TextViewEvent.Type.MOVE_CURSOR);
        textViewEvent.setMovementStep(MovementStep.intern(n));
        textViewEvent.setCount(n2);
        this.fireTextViewEvent(textViewEvent);
    }

    private void handleMoveFocus(int n) {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.MOVE_FOCUS));
    }

    private void handlePageHorizontally(int n, boolean bl) {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.PAGE_HORIZONTALLY));
    }

    private void handlePopulatePopup(Handle handle) {
        TextViewEvent textViewEvent = new TextViewEvent((Object)this, TextViewEvent.Type.POPULATE_POPUP);
        textViewEvent.setMenu(Menu.getMenu(handle));
        this.fireTextViewEvent(textViewEvent);
    }

    private void handleSetScrollAdjustments(Handle handle, Handle handle2) {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.SET_SCROLL_ADJUSTMENTS));
    }

    private void handleSetAnchor() {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.SET_ANCHOR));
    }

    private void handleToggleOverwrite() {
        this.fireTextViewEvent(new TextViewEvent((Object)this, TextViewEvent.Type.TOGGLE_OVERWRITE));
    }

    public static Type getType() {
        return new Type(TextView.gtk_text_view_get_type());
    }

    protected static final native Handle getHAdjustment(Handle var0);

    protected static final native Handle getVAdjustment(Handle var0);

    protected static final native int gtk_text_view_get_type();

    protected static final native Handle gtk_text_view_new();

    protected static final native Handle gtk_text_view_new_with_buffer(Handle var0);

    protected static final native void gtk_text_view_set_buffer(Handle var0, Handle var1);

    protected static final native Handle gtk_text_view_get_buffer(Handle var0);

    protected static final native boolean gtk_text_view_scroll_to_iter(Handle var0, Handle var1, double var2, boolean var4, double var5, double var7);

    protected static final native void gtk_text_view_scroll_to_mark(Handle var0, Handle var1, double var2, boolean var4, double var5, double var7);

    protected static final native void gtk_text_view_scroll_mark_onscreen(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_move_mark_onscreen(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_place_cursor_onscreen(Handle var0);

    protected static final native Handle gtk_text_view_get_visible_rect(Handle var0);

    protected static final native void gtk_text_view_set_cursor_visible(Handle var0, boolean var1);

    protected static final native boolean gtk_text_view_get_cursor_visible(Handle var0);

    protected static final native Handle gtk_text_view_get_iter_location(Handle var0, Handle var1);

    protected static final native Handle gtk_text_view_get_iter_at_location(Handle var0, int var1, int var2);

    protected static final native void gtk_text_view_get_line_yrange(Handle var0, Handle var1, int[] var2, int[] var3);

    protected static final native void gtk_text_view_get_line_at_y(Handle var0, Handle var1, int var2, int[] var3);

    protected static final native void gtk_text_view_buffer_to_window_coords(Handle var0, int var1, int var2, int var3, int[] var4, int[] var5);

    protected static final native void gtk_text_view_window_to_buffer_coords(Handle var0, int var1, int var2, int var3, int[] var4, int[] var5);

    protected static final native Handle gtk_text_view_get_window(Handle var0, int var1);

    protected static final native int gtk_text_view_get_window_type(Handle var0, Handle var1);

    protected static final native void gtk_text_view_set_border_window_size(Handle var0, int var1, int var2);

    protected static final native int gtk_text_view_get_border_window_size(Handle var0, int var1);

    protected static final native boolean gtk_text_view_forward_display_line(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_backward_display_line(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_forward_display_line_end(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_backward_display_line_start(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_starts_display_line(Handle var0, Handle var1);

    protected static final native boolean gtk_text_view_move_visually(Handle var0, Handle var1, int var2);

    protected static final native void gtk_text_view_add_child_at_anchor(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_text_view_add_child_in_window(Handle var0, Handle var1, int var2, int var3, int var4);

    protected static final native void gtk_text_view_move_child(Handle var0, Handle var1, int var2, int var3);

    protected static final native void gtk_text_view_set_wrap_mode(Handle var0, int var1);

    protected static final native int gtk_text_view_get_wrap_mode(Handle var0);

    protected static final native void gtk_text_view_set_editable(Handle var0, boolean var1);

    protected static final native boolean gtk_text_view_get_editable(Handle var0);

    protected static final native void gtk_text_view_set_pixels_above_lines(Handle var0, int var1);

    protected static final native int gtk_text_view_get_pixels_above_lines(Handle var0);

    protected static final native void gtk_text_view_set_pixels_below_lines(Handle var0, int var1);

    protected static final native int gtk_text_view_get_pixels_below_lines(Handle var0);

    protected static final native void gtk_text_view_set_pixels_inside_wrap(Handle var0, int var1);

    protected static final native int gtk_text_view_get_pixels_inside_wrap(Handle var0);

    protected static final native void gtk_text_view_set_justification(Handle var0, int var1);

    protected static final native int gtk_text_view_get_justification(Handle var0);

    protected static final native void gtk_text_view_set_left_margin(Handle var0, int var1);

    protected static final native int gtk_text_view_get_left_margin(Handle var0);

    protected static final native void gtk_text_view_set_right_margin(Handle var0, int var1);

    protected static final native int gtk_text_view_get_right_margin(Handle var0);

    protected static final native void gtk_text_view_set_indent(Handle var0, int var1);

    protected static final native int gtk_text_view_get_indent(Handle var0);

    protected static final native void gtk_text_view_set_tabs(Handle var0, Handle var1);

    protected static final native Handle gtk_text_view_get_tabs(Handle var0);

    protected static final native Handle gtk_text_view_get_default_attributes(Handle var0);

    protected static final native void gtk_text_view_set_accepts_tab(Handle var0, boolean var1);

    protected static final native boolean gtk_text_view_get_accepts_tab(Handle var0);

    protected static final native void gtk_text_view_set_overwrite(Handle var0, boolean var1);

    protected static final native boolean gtk_text_view_get_overwrite(Handle var0);

    static {
        TextView.addEvents(evtMap);
    }

    public static final class VerticalLineRange {
        private final int y;
        private final int height;

        public VerticalLineRange(int n, int n2) {
            this.y = n;
            this.height = n2;
        }

        public final int getY() {
            return this.y;
        }

        public final int getHeight() {
            return this.height;
        }
    }
}

