/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
import org.gnu.gtk.TextAttributes;
import org.gnu.gtk.TextBuffer;
import org.gnu.gtk.TextChildAnchor;
import org.gnu.gtk.TextSearchFlags;
import org.gnu.gtk.TextTag;
import org.gnu.pango.Language;

public class TextIter
extends Boxed {
    protected TextIter(Handle handle) {
        super(handle);
    }

    protected static TextIter getTextIter(Handle handle) {
        if (handle == null) {
            return null;
        }
        TextIter textIter = (TextIter)Boxed.getBoxedFromHandle((Handle)handle);
        if (textIter == null) {
            textIter = new TextIter(handle);
        }
        return textIter;
    }

    public TextBuffer getBuffer() {
        return TextBuffer.getTextBuffer(TextIter.gtk_text_iter_get_buffer(this.getHandle()));
    }

    public int getOffset() {
        return TextIter.gtk_text_iter_get_offset(this.getHandle());
    }

    public int getLineNumber() {
        return TextIter.gtk_text_iter_get_line(this.getHandle());
    }

    public int getLineOffset() {
        return TextIter.gtk_text_iter_get_line_offset(this.getHandle());
    }

    public int getVisibleLineOffset() {
        return TextIter.gtk_text_iter_get_visible_line_offset(this.getHandle());
    }

    public char getChar() {
        return TextIter.gtk_text_iter_get_char(this.getHandle());
    }

    public Pixbuf getPixbuf() {
        if (this.isPixbuf()) {
            return new Pixbuf(TextIter.gtk_text_iter_get_pixbuf(this.getHandle()));
        }
        return null;
    }

    public boolean isPixbuf() {
        return TextIter.gtk_text_iter_isPixbuf(this.getHandle());
    }

    public TextChildAnchor getChildAnchor() {
        if (this.isChildAnchor()) {
            return TextChildAnchor.getTextChildAnchor(TextIter.gtk_text_iter_get_child_anchor(this.getHandle()));
        }
        return null;
    }

    public boolean isChildAnchor() {
        return TextIter.gtk_text_iter_isChildAnchor(this.getHandle());
    }

    public boolean beginsTag(TextTag textTag) {
        return TextIter.gtk_text_iter_begins_tag(this.getHandle(), textTag.getHandle());
    }

    public boolean endsTag(TextTag textTag) {
        return TextIter.gtk_text_iter_ends_tag(this.getHandle(), textTag.getHandle());
    }

    public boolean hasTag(TextTag textTag) {
        return TextIter.gtk_text_iter_has_tag(this.getHandle(), textTag.getHandle());
    }

    public boolean getEditable(boolean bl) {
        return TextIter.gtk_text_iter_editable(this.getHandle(), bl);
    }

    public boolean getCanInsert(boolean bl) {
        return TextIter.gtk_text_iter_can_insert(this.getHandle(), bl);
    }

    public boolean getStartsWord() {
        return TextIter.gtk_text_iter_starts_word(this.getHandle());
    }

    public boolean getEndsWord() {
        return TextIter.gtk_text_iter_ends_word(this.getHandle());
    }

    public boolean getInsideWord() {
        return TextIter.gtk_text_iter_inside_word(this.getHandle());
    }

    public boolean getStartsLine() {
        return TextIter.gtk_text_iter_starts_line(this.getHandle());
    }

    public boolean getEndsLine() {
        return TextIter.gtk_text_iter_ends_line(this.getHandle());
    }

    public boolean getStartsSentence() {
        return TextIter.gtk_text_iter_starts_sentence(this.getHandle());
    }

    public boolean getEndsSentence() {
        return TextIter.gtk_text_iter_ends_sentence(this.getHandle());
    }

    public boolean getInsideSentence() {
        return TextIter.gtk_text_iter_inside_sentence(this.getHandle());
    }

    public boolean getIsCursorPosition() {
        return TextIter.gtk_text_iter_is_cursor_position(this.getHandle());
    }

    public int getCharsInLine() {
        return TextIter.gtk_text_iter_get_chars_in_line(this.getHandle());
    }

    public boolean getAttributes(TextAttributes textAttributes) {
        return TextIter.gtk_text_iter_get_attributes(this.getHandle(), textAttributes.getHandle());
    }

    public Language getLanguage() {
        return new Language(TextIter.gtk_text_iter_get_language(this.getHandle()));
    }

    public boolean getIsEndIter() {
        return TextIter.gtk_text_iter_is_end(this.getHandle());
    }

    public boolean getIsStartIter() {
        return TextIter.gtk_text_iter_is_start(this.getHandle());
    }

    public boolean moveForwardChar() {
        return TextIter.gtk_text_iter_forward_char(this.getHandle());
    }

    public boolean moveBackwardChar() {
        return TextIter.gtk_text_iter_backward_char(this.getHandle());
    }

    public boolean moveForwardChar(int n) {
        return TextIter.gtk_text_iter_forward_chars(this.getHandle(), n);
    }

    public boolean moveBackwardChar(int n) {
        return TextIter.gtk_text_iter_backward_chars(this.getHandle(), n);
    }

    public boolean moveForwardLine() {
        return TextIter.gtk_text_iter_forward_line(this.getHandle());
    }

    public boolean moveBackwardLine() {
        return TextIter.gtk_text_iter_backward_line(this.getHandle());
    }

    public boolean moveForwardLine(int n) {
        return TextIter.gtk_text_iter_forward_lines(this.getHandle(), n);
    }

    public boolean moveBackwardLine(int n) {
        return TextIter.gtk_text_iter_backward_lines(this.getHandle(), n);
    }

    public boolean moveForwardWordEnd(int n) {
        return TextIter.gtk_text_iter_forward_word_ends(this.getHandle(), n);
    }

    public boolean moveBackwardWordStart(int n) {
        return TextIter.gtk_text_iter_backward_word_starts(this.getHandle(), n);
    }

    public boolean moveForwardWordEnd() {
        return TextIter.gtk_text_iter_forward_word_end(this.getHandle());
    }

    public boolean moveBackwardWordStart() {
        return TextIter.gtk_text_iter_backward_word_start(this.getHandle());
    }

    public boolean moveForwardCursorPosition() {
        return TextIter.gtk_text_iter_forward_cursor_position(this.getHandle());
    }

    public boolean moveBackwardCursorPosition() {
        return TextIter.gtk_text_iter_backward_cursor_position(this.getHandle());
    }

    public boolean moveForwardCursorPosition(int n) {
        return TextIter.gtk_text_iter_forward_cursor_positions(this.getHandle(), n);
    }

    public boolean moveBackwardCursorPosition(int n) {
        return TextIter.gtk_text_iter_backward_cursor_positions(this.getHandle(), n);
    }

    public boolean moveBackwardSentenceStart() {
        return TextIter.gtk_text_iter_backward_sentence_start(this.getHandle());
    }

    public boolean moveBackwardSentenceStart(int n) {
        return TextIter.gtk_text_iter_backward_sentence_starts(this.getHandle(), n);
    }

    public boolean moveForwardSentenceEnd() {
        return TextIter.gtk_text_iter_forward_sentence_end(this.getHandle());
    }

    public boolean moveForwardSentenceEnd(int n) {
        return TextIter.gtk_text_iter_forward_sentence_ends(this.getHandle(), n);
    }

    public void setCharOffset(int n) {
        TextIter.gtk_text_iter_set_offset(this.getHandle(), n);
    }

    public void setLine(int n) {
        TextIter.gtk_text_iter_set_line(this.getHandle(), n);
    }

    public void setLineOffset(int n) {
        TextIter.gtk_text_iter_set_line_offset(this.getHandle(), n);
    }

    public void setVisibleLineOffset(int n) {
        TextIter.gtk_text_iter_set_visible_line_offset(this.getHandle(), n);
    }

    public void moveToEnd() {
        TextIter.gtk_text_iter_forward_to_end(this.getHandle());
    }

    public boolean moveToLineEnd() {
        return TextIter.gtk_text_iter_forward_to_line_end(this.getHandle());
    }

    public boolean moveForwardToggle(TextTag textTag) {
        return TextIter.gtk_text_iter_forward_to_tag_toggle(this.getHandle(), textTag.getHandle());
    }

    public boolean moveBackwardToggle(TextTag textTag) {
        return TextIter.gtk_text_iter_backward_to_tag_toggle(this.getHandle(), textTag.getHandle());
    }

    public boolean searchForward(String string, TextSearchFlags textSearchFlags, TextIter textIter, TextIter textIter2, TextIter textIter3) {
        return TextIter.gtk_text_iter_forward_search(this.getHandle(), string, textSearchFlags.getValue(), textIter.getHandle(), textIter2.getHandle(), textIter3.getHandle());
    }

    public boolean searchBackward(String string, TextSearchFlags textSearchFlags, TextIter textIter, TextIter textIter2, TextIter textIter3) {
        return TextIter.gtk_text_iter_backward_search(this.getHandle(), string, textSearchFlags.getValue(), textIter.getHandle(), textIter2.getHandle(), textIter3.getHandle());
    }

    public boolean equals(TextIter textIter) {
        return TextIter.gtk_text_iter_equal(this.getHandle(), textIter.getHandle());
    }

    public int cmp(TextIter textIter) {
        return TextIter.gtk_text_iter_compare(this.getHandle(), textIter.getHandle());
    }

    public boolean inRange(TextIter textIter, TextIter textIter2) {
        return TextIter.gtk_text_iter_in_range(this.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    protected static final native Handle gtk_text_iter_get_buffer(Handle var0);

    protected static final native void gtk_text_iter_free(Handle var0);

    protected static final native int gtk_text_iter_get_offset(Handle var0);

    protected static final native int gtk_text_iter_get_line(Handle var0);

    protected static final native int gtk_text_iter_get_line_offset(Handle var0);

    protected static final native int gtk_text_iter_get_line_index(Handle var0);

    protected static final native int gtk_text_iter_get_visible_line_offset(Handle var0);

    protected static final native int gtk_text_iter_get_visible_line_index(Handle var0);

    protected static final native char gtk_text_iter_get_char(Handle var0);

    protected static final native String gtk_text_iter_get_slice(Handle var0, Handle var1);

    protected static final native String gtk_text_iter_get_text(Handle var0, Handle var1);

    protected static final native String gtk_text_iter_get_visible_slice(Handle var0, Handle var1);

    protected static final native String gtk_text_iter_get_visible_text(Handle var0, Handle var1);

    protected static final native Handle gtk_text_iter_get_pixbuf(Handle var0);

    protected static final native Handle gtk_text_iter_get_child_anchor(Handle var0);

    protected static final native boolean gtk_text_iter_begins_tag(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_ends_tag(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_toggles_tag(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_has_tag(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_editable(Handle var0, boolean var1);

    protected static final native boolean gtk_text_iter_can_insert(Handle var0, boolean var1);

    protected static final native boolean gtk_text_iter_starts_word(Handle var0);

    protected static final native boolean gtk_text_iter_ends_word(Handle var0);

    protected static final native boolean gtk_text_iter_inside_word(Handle var0);

    protected static final native boolean gtk_text_iter_starts_sentence(Handle var0);

    protected static final native boolean gtk_text_iter_ends_sentence(Handle var0);

    protected static final native boolean gtk_text_iter_inside_sentence(Handle var0);

    protected static final native boolean gtk_text_iter_starts_line(Handle var0);

    protected static final native boolean gtk_text_iter_ends_line(Handle var0);

    protected static final native boolean gtk_text_iter_is_cursor_position(Handle var0);

    protected static final native int gtk_text_iter_get_chars_in_line(Handle var0);

    protected static final native int gtk_text_iter_get_bytes_in_line(Handle var0);

    protected static final native boolean gtk_text_iter_get_attributes(Handle var0, Handle var1);

    protected static final native Handle gtk_text_iter_get_language(Handle var0);

    protected static final native boolean gtk_text_iter_is_end(Handle var0);

    protected static final native boolean gtk_text_iter_is_start(Handle var0);

    protected static final native boolean gtk_text_iter_forward_char(Handle var0);

    protected static final native boolean gtk_text_iter_backward_char(Handle var0);

    protected static final native boolean gtk_text_iter_forward_chars(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_backward_chars(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_forward_line(Handle var0);

    protected static final native boolean gtk_text_iter_backward_line(Handle var0);

    protected static final native boolean gtk_text_iter_forward_lines(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_backward_lines(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_forward_word_end(Handle var0);

    protected static final native boolean gtk_text_iter_backward_word_start(Handle var0);

    protected static final native boolean gtk_text_iter_forward_word_ends(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_backward_word_starts(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_forward_sentence_end(Handle var0);

    protected static final native boolean gtk_text_iter_backward_sentence_start(Handle var0);

    protected static final native boolean gtk_text_iter_forward_sentence_ends(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_backward_sentence_starts(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_forward_cursor_position(Handle var0);

    protected static final native boolean gtk_text_iter_backward_cursor_position(Handle var0);

    protected static final native boolean gtk_text_iter_forward_cursor_positions(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_backward_cursor_positions(Handle var0, int var1);

    protected static final native void gtk_text_iter_set_offset(Handle var0, int var1);

    protected static final native void gtk_text_iter_set_line(Handle var0, int var1);

    protected static final native void gtk_text_iter_set_line_offset(Handle var0, int var1);

    protected static final native void gtk_text_iter_set_line_index(Handle var0, int var1);

    protected static final native void gtk_text_iter_forward_to_end(Handle var0);

    protected static final native boolean gtk_text_iter_forward_to_line_end(Handle var0);

    protected static final native void gtk_text_iter_set_visible_line_offset(Handle var0, int var1);

    protected static final native void gtk_text_iter_set_visible_line_index(Handle var0, int var1);

    protected static final native boolean gtk_text_iter_forward_to_tag_toggle(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_backward_to_tag_toggle(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_forward_search(Handle var0, String var1, int var2, Handle var3, Handle var4, Handle var5);

    protected static final native boolean gtk_text_iter_backward_search(Handle var0, String var1, int var2, Handle var3, Handle var4, Handle var5);

    protected static final native boolean gtk_text_iter_equal(Handle var0, Handle var1);

    protected static final native int gtk_text_iter_compare(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_in_range(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_text_iter_order(Handle var0, Handle var1);

    protected static final native boolean gtk_text_iter_isChildAnchor(Handle var0);

    protected static final native boolean gtk_text_iter_isPixbuf(Handle var0);
}

