/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Clipboard;
import org.gnu.gtk.TextChildAnchor;
import org.gnu.gtk.TextIter;
import org.gnu.gtk.TextMark;
import org.gnu.gtk.TextTag;
import org.gnu.gtk.TextTagTable;
import org.gnu.gtk.event.TextBufferEvent;
import org.gnu.gtk.event.TextBufferListener;

public class TextBuffer
extends GObject {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    protected TextBuffer(Handle handle) {
        super(handle);
    }

    protected static TextBuffer getTextBuffer(Handle handle) {
        if (handle == null) {
            return null;
        }
        TextBuffer textBuffer = (TextBuffer)GObject.getGObjectFromHandle((Handle)handle);
        if (textBuffer == null) {
            textBuffer = new TextBuffer(handle);
        }
        return textBuffer;
    }

    public TextBuffer(TextTagTable textTagTable) {
        super(TextBuffer.gtk_text_buffer_new(textTagTable.getHandle()));
    }

    public TextBuffer() {
        super(TextBuffer.gtk_text_buffer_new_noTable());
    }

    public int getLineCount() {
        return TextBuffer.gtk_text_buffer_get_line_count(this.getHandle());
    }

    public int getCharCount() {
        return TextBuffer.gtk_text_buffer_get_char_count(this.getHandle());
    }

    public TextTagTable getTextTagTable() {
        Handle handle = TextBuffer.gtk_text_buffer_get_tag_table(this.getHandle());
        return TextTagTable.getTextTagTable(handle);
    }

    public void insertText(TextIter textIter, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TextBuffer.gtk_text_buffer_insert(this.getHandle(), textIter.getHandle(), string);
    }

    public void insertText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TextBuffer.gtk_text_buffer_insert_at_cursor(this.getHandle(), string);
    }

    public boolean insertTextInteractive(TextIter textIter, String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        return TextBuffer.gtk_text_buffer_insert_interactive(this.getHandle(), textIter.getHandle(), string, bl);
    }

    public boolean insertTextInteractive(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        return TextBuffer.gtk_text_buffer_insert_interactive_at_cursor(this.getHandle(), string, bl);
    }

    public void insertRange(TextIter textIter, TextIter textIter2, TextIter textIter3) {
        TextBuffer.gtk_text_buffer_insert_range(this.getHandle(), textIter.getHandle(), textIter2.getHandle(), textIter3.getHandle());
    }

    public void insertText(TextIter textIter, String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TextBuffer.insert_with_tag(this.getHandle(), textIter.getHandle(), string, string2);
    }

    public void insertText(TextIter textIter, String string, String[] stringArray) {
        TextMark textMark = this.createMark("jginternal", this.getEndIter(), true);
        this.insertText(textIter, string);
        TextIter textIter2 = this.getIter(textMark);
        this.deleteMark("jginternal");
        for (int i = 0; i < stringArray.length; ++i) {
            this.applyTag(stringArray[i], textIter2, textIter);
        }
    }

    public boolean insertRangeInteractive(TextIter textIter, TextIter textIter2, TextIter textIter3, boolean bl) {
        return TextBuffer.gtk_text_buffer_insert_range_interactive(this.getHandle(), textIter.getHandle(), textIter2.getHandle(), textIter3.getHandle(), bl);
    }

    public void deleteText(TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_delete(this.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    public boolean deleteTextInteractive(TextIter textIter, TextIter textIter2, boolean bl) {
        return TextBuffer.gtk_text_buffer_delete_interactive(this.getHandle(), textIter.getHandle(), textIter2.getHandle(), bl);
    }

    public void setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        TextBuffer.gtk_text_buffer_set_text(this.getHandle(), string);
    }

    public String getText(TextIter textIter, TextIter textIter2, boolean bl) {
        return TextBuffer.gtk_text_buffer_get_text(this.getHandle(), textIter.getHandle(), textIter2.getHandle(), bl);
    }

    public String getSlice(TextIter textIter, TextIter textIter2, boolean bl) {
        return TextBuffer.gtk_text_buffer_get_slice(this.getHandle(), textIter.getHandle(), textIter2.getHandle(), bl);
    }

    public void insertPixbuf(TextIter textIter, Pixbuf pixbuf) {
        TextBuffer.gtk_text_buffer_insert_pixbuf(this.getHandle(), textIter.getHandle(), pixbuf.getHandle());
    }

    public void inserChildAnchor(TextIter textIter, TextChildAnchor textChildAnchor) {
        TextBuffer.gtk_text_buffer_insert_child_anchor(this.getHandle(), textIter.getHandle(), textChildAnchor.getHandle());
    }

    public TextChildAnchor createChildAnchor(TextIter textIter) {
        return new TextChildAnchor(TextBuffer.gtk_text_buffer_create_child_anchor(this.getHandle(), textIter.getHandle()));
    }

    public TextMark createMark(String string, TextIter textIter, boolean bl) {
        return TextMark.getTextMark(TextBuffer.gtk_text_buffer_create_mark(this.getHandle(), string, textIter.getHandle(), bl));
    }

    public void moveMark(TextMark textMark, TextIter textIter) {
        TextBuffer.gtk_text_buffer_move_mark(this.getHandle(), textMark.getHandle(), textIter.getHandle());
    }

    public void moveMark(String string, TextIter textIter) {
        TextBuffer.gtk_text_buffer_move_mark_by_name(this.getHandle(), string, textIter.getHandle());
    }

    public void deleteMark(TextMark textMark) {
        TextBuffer.gtk_text_buffer_delete_mark(this.getHandle(), textMark.getHandle());
    }

    public void deleteMark(String string) {
        TextBuffer.gtk_text_buffer_delete_mark_by_name(this.getHandle(), string);
    }

    public boolean markExists(String string) {
        return TextBuffer.gtk_text_buffer_get_mark(this.getHandle(), string) != null;
    }

    public TextMark getMark(String string) {
        Handle handle = TextBuffer.gtk_text_buffer_get_mark(this.getHandle(), string);
        return TextMark.getTextMark(handle);
    }

    public TextMark getInsert() {
        Handle handle = TextBuffer.gtk_text_buffer_get_insert(this.getHandle());
        return TextMark.getTextMark(handle);
    }

    public TextMark getSelectionBound() {
        Handle handle = TextBuffer.gtk_text_buffer_get_selection_bound(this.getHandle());
        return TextMark.getTextMark(handle);
    }

    public void placeCursor(TextIter textIter) {
        TextBuffer.gtk_text_buffer_place_cursor(this.getHandle(), textIter.getHandle());
    }

    public void applyTag(TextTag textTag, TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_apply_tag(this.getHandle(), textTag.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    public void removeTag(TextTag textTag, TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_remove_tag(this.getHandle(), textTag.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    public void applyTag(String string, TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_apply_tag_by_name(this.getHandle(), string, textIter.getHandle(), textIter2.getHandle());
    }

    public void removeTag(String string, TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_remove_tag_by_name(this.getHandle(), string, textIter.getHandle(), textIter2.getHandle());
    }

    public void removeAllTags(TextTag textTag, TextTag textTag2) {
        TextBuffer.gtk_text_buffer_remove_all_tags(this.getHandle(), textTag.getHandle(), textTag2.getHandle());
    }

    public void removeAllTags(TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_remove_all_tags(this.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    public TextIter getIter(int n, int n2) {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_iter_at_line_offset(this.getHandle(), n, n2));
    }

    public TextIter getIter(int n) {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_iter_at_offset(this.getHandle(), n));
    }

    public TextIter getLineIter(int n) {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_iter_at_line(this.getHandle(), n));
    }

    public TextIter getIter(TextMark textMark) {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_iter_at_mark(this.getHandle(), textMark.getHandle()));
    }

    public TextIter getIter(TextChildAnchor textChildAnchor) {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_iter_at_child_anchor(this.getHandle(), textChildAnchor.getHandle()));
    }

    public TextIter getStartIter() {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_start_iter(this.getHandle()));
    }

    public TextIter getEndIter() {
        return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_end_iter(this.getHandle()));
    }

    public boolean getModified() {
        return TextBuffer.gtk_text_buffer_get_modified(this.getHandle());
    }

    public void setModified(boolean bl) {
        TextBuffer.gtk_text_buffer_set_modified(this.getHandle(), bl);
    }

    public boolean deleteSelection(boolean bl, boolean bl2) {
        return TextBuffer.gtk_text_buffer_delete_selection(this.getHandle(), bl, bl2);
    }

    public void pasteClipboard(Clipboard clipboard, TextIter textIter, boolean bl) {
        TextBuffer.gtk_text_buffer_paste_clipboard(this.getHandle(), clipboard.getHandle(), textIter.getHandle(), bl);
    }

    public void pasteClipboard(Clipboard clipboard, boolean bl) {
        TextBuffer.gtk_text_buffer_paste_clipboardInsertPosition(this.getHandle(), clipboard.getHandle(), bl);
    }

    public void copyClipboard(Clipboard clipboard) {
        TextBuffer.gtk_text_buffer_copy_clipboard(this.getHandle(), clipboard.getHandle());
    }

    public void cutClipboard(Clipboard clipboard, boolean bl) {
        TextBuffer.gtk_text_buffer_cut_clipboard(this.getHandle(), clipboard.getHandle(), bl);
    }

    public boolean getSelected() {
        return TextBuffer.gtk_text_buffer_get_selection_exists(this.getHandle());
    }

    public TextIter getSelectionStart() {
        if (this.getSelected()) {
            return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_selection_start(this.getHandle()));
        }
        return null;
    }

    public TextIter getSelectionEnd() {
        if (this.getSelected()) {
            return TextIter.getTextIter(TextBuffer.gtk_text_buffer_get_selection_end(this.getHandle()));
        }
        return null;
    }

    public void beginUserAction() {
        TextBuffer.gtk_text_buffer_begin_user_action(this.getHandle());
    }

    public void endUserAction() {
        TextBuffer.gtk_text_buffer_end_user_action(this.getHandle());
    }

    public void addClipboard(Clipboard clipboard) {
        TextBuffer.gtk_text_buffer_add_selection_clipboard(this.getHandle(), clipboard.getHandle());
    }

    public void removeClipboard(Clipboard clipboard) {
        TextBuffer.gtk_text_buffer_remove_selection_clipboard(this.getHandle(), clipboard.getHandle());
    }

    public void selectRange(TextIter textIter, TextIter textIter2) {
        TextBuffer.gtk_text_buffer_select_range(this.getHandle(), textIter.getHandle(), textIter2.getHandle());
    }

    public boolean backspace(TextIter textIter, boolean bl, boolean bl2) {
        return TextBuffer.gtk_text_buffer_backspace(this.getHandle(), textIter.getHandle(), bl, bl2);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("apply_tag", "handleApplyTag", (EventType)TextBufferEvent.Type.APPLY_TAG, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("changed", "handleChanged", (EventType)TextBufferEvent.Type.CHANGED, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("delete_range", "handleDeleteRange", (EventType)TextBufferEvent.Type.DELETE_RANGE, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("insert_child_anchor", "handleInsertChildAnchor", (EventType)TextBufferEvent.Type.INSERT_CHILD_ANCHOR, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("insert_pixbuf", "handleInsertPixbuf", (EventType)TextBufferEvent.Type.INSERT_PIXBUF, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("insert_text", "handleInsertText", (EventType)TextBufferEvent.Type.INSERT_TEXT, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("mark_deleted", "handleMarkDelete", (EventType)TextBufferEvent.Type.MARK_DELETED, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("mark_set", "handleMarkSet", (EventType)TextBufferEvent.Type.MARK_SET, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("modified_changed", "handleModifiedChanged", (EventType)TextBufferEvent.Type.MODIFIED_CHANGED, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
        eventMap.addEvent("remove_tag", "handleRemoveTag", (EventType)TextBufferEvent.Type.REMOVE_TAG, TextBuffer.class$("org.gnu.gtk.event.TextBufferListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addListener(TextBufferListener textBufferListener) {
        int n = TextBuffer.findListener(this.listeners, textBufferListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.APPLY_TAG);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.CHANGED);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.DELETE_RANGE);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_CHILD_ANCHOR);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_PIXBUF);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_TEXT);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.MARK_DELETED);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.MARK_SET);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.MODIFIED_CHANGED);
                evtMap.initialize((GObject)this, (EventType)TextBufferEvent.Type.REMOVE_TAG);
                this.listeners = new Vector();
            }
            this.listeners.addElement(textBufferListener);
        }
    }

    public void removeListener(TextBufferListener textBufferListener) {
        int n = TextBuffer.findListener(this.listeners, textBufferListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.APPLY_TAG);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.DELETE_RANGE);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_CHILD_ANCHOR);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_PIXBUF);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.INSERT_TEXT);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.MARK_DELETED);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.MARK_SET);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.MODIFIED_CHANGED);
            evtMap.uninitialize((GObject)this, (EventType)TextBufferEvent.Type.REMOVE_TAG);
            this.listeners = null;
        }
    }

    protected void fireTextBufferEvent(TextBufferEvent textBufferEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            TextBufferListener textBufferListener = (TextBufferListener)this.listeners.elementAt(i);
            textBufferListener.textBufferEvent(textBufferEvent);
        }
    }

    protected static int findListener(Vector vector, Object object) {
        if (vector == null || object == null) {
            return -1;
        }
        return vector.indexOf(object);
    }

    private void handleApplyTag(Handle handle, Handle handle2, Handle handle3) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.APPLY_TAG));
    }

    private void handleChanged() {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.CHANGED));
    }

    private void handleDeleteRange(Handle handle, Handle handle2) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.DELETE_RANGE));
    }

    private void handleInsertChildAnchor(Handle handle, Handle handle2) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.INSERT_CHILD_ANCHOR));
    }

    private void handleInsertPixbuf(Handle handle, Handle handle2) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.INSERT_PIXBUF));
    }

    private void handleInsertText(Handle handle, String string, int n) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.INSERT_TEXT));
    }

    private void handleMarkDelete(Handle handle) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.MARK_DELETED));
    }

    private void handleMarkSet(Handle handle, Handle handle2) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.MARK_SET));
    }

    private void handleModifiedChanged() {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.MODIFIED_CHANGED));
    }

    private void handleRemoveTag(Handle handle, Handle handle2, Handle handle3) {
        this.fireTextBufferEvent(new TextBufferEvent((Object)this, TextBufferEvent.Type.REMOVE_TAG));
    }

    public static Type getType() {
        return new Type(TextBuffer.gtk_text_buffer_get_type());
    }

    public TextTag createTag(String string) {
        Handle handle = TextBuffer.create_tag(this.getHandle(), string);
        return TextTag.getTextTag(handle);
    }

    protected static final native int gtk_text_buffer_get_type();

    protected static final native Handle gtk_text_buffer_new(Handle var0);

    protected static final native int gtk_text_buffer_get_line_count(Handle var0);

    protected static final native int gtk_text_buffer_get_char_count(Handle var0);

    protected static final native Handle gtk_text_buffer_get_tag_table(Handle var0);

    protected static final native void gtk_text_buffer_set_text(Handle var0, String var1);

    protected static final native void gtk_text_buffer_insert(Handle var0, Handle var1, String var2);

    protected static final native void gtk_text_buffer_insert_at_cursor(Handle var0, String var1);

    protected static final native boolean gtk_text_buffer_insert_interactive(Handle var0, Handle var1, String var2, boolean var3);

    protected static final native boolean gtk_text_buffer_insert_interactive_at_cursor(Handle var0, String var1, boolean var2);

    protected static final native void gtk_text_buffer_insert_range(Handle var0, Handle var1, Handle var2, Handle var3);

    protected static final native boolean gtk_text_buffer_insert_range_interactive(Handle var0, Handle var1, Handle var2, Handle var3, boolean var4);

    protected static final native void gtk_text_buffer_delete(Handle var0, Handle var1, Handle var2);

    protected static final native boolean gtk_text_buffer_delete_interactive(Handle var0, Handle var1, Handle var2, boolean var3);

    protected static final native String gtk_text_buffer_get_text(Handle var0, Handle var1, Handle var2, boolean var3);

    protected static final native String gtk_text_buffer_get_slice(Handle var0, Handle var1, Handle var2, boolean var3);

    protected static final native void gtk_text_buffer_insert_pixbuf(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_text_buffer_insert_child_anchor(Handle var0, Handle var1, Handle var2);

    protected static final native Handle gtk_text_buffer_create_child_anchor(Handle var0, Handle var1);

    protected static final native Handle gtk_text_buffer_create_mark(Handle var0, String var1, Handle var2, boolean var3);

    protected static final native void gtk_text_buffer_move_mark(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_text_buffer_delete_mark(Handle var0, Handle var1);

    protected static final native Handle gtk_text_buffer_get_mark(Handle var0, String var1);

    protected static final native void gtk_text_buffer_move_mark_by_name(Handle var0, String var1, Handle var2);

    protected static final native void gtk_text_buffer_delete_mark_by_name(Handle var0, String var1);

    protected static final native Handle gtk_text_buffer_get_insert(Handle var0);

    protected static final native Handle gtk_text_buffer_get_selection_bound(Handle var0);

    protected static final native void gtk_text_buffer_place_cursor(Handle var0, Handle var1);

    protected static final native void gtk_text_buffer_apply_tag(Handle var0, Handle var1, Handle var2, Handle var3);

    protected static final native void gtk_text_buffer_remove_tag(Handle var0, Handle var1, Handle var2, Handle var3);

    protected static final native void gtk_text_buffer_apply_tag_by_name(Handle var0, String var1, Handle var2, Handle var3);

    protected static final native void gtk_text_buffer_remove_tag_by_name(Handle var0, String var1, Handle var2, Handle var3);

    protected static final native void gtk_text_buffer_remove_all_tags(Handle var0, Handle var1, Handle var2);

    protected static final native boolean gtk_text_buffer_get_modified(Handle var0);

    protected static final native void gtk_text_buffer_set_modified(Handle var0, boolean var1);

    protected static final native void gtk_text_buffer_add_selection_clipboard(Handle var0, Handle var1);

    protected static final native void gtk_text_buffer_remove_selection_clipboard(Handle var0, Handle var1);

    protected static final native void gtk_text_buffer_cut_clipboard(Handle var0, Handle var1, boolean var2);

    protected static final native void gtk_text_buffer_copy_clipboard(Handle var0, Handle var1);

    protected static final native void gtk_text_buffer_paste_clipboard(Handle var0, Handle var1, Handle var2, boolean var3);

    protected static final native boolean gtk_text_buffer_delete_selection(Handle var0, boolean var1, boolean var2);

    protected static final native void gtk_text_buffer_begin_user_action(Handle var0);

    protected static final native void gtk_text_buffer_end_user_action(Handle var0);

    protected static final native Handle gtk_text_buffer_new_noTable();

    protected static final native Handle create_tag(Handle var0, String var1);

    protected static final native void insert_with_tag(Handle var0, Handle var1, String var2, String var3);

    protected static final native void gtk_text_buffer_select_range(Handle var0, Handle var1, Handle var2);

    protected static final native boolean gtk_text_buffer_get_selection_exists(Handle var0);

    protected static final native Handle gtk_text_buffer_get_selection_start(Handle var0);

    protected static final native Handle gtk_text_buffer_get_selection_end(Handle var0);

    protected static final native Handle gtk_text_buffer_get_iter_at_line_offset(Handle var0, int var1, int var2);

    protected static final native Handle gtk_text_buffer_get_iter_at_offset(Handle var0, int var1);

    protected static final native Handle gtk_text_buffer_get_iter_at_line(Handle var0, int var1);

    protected static final native Handle gtk_text_buffer_get_iter_at_mark(Handle var0, Handle var1);

    protected static final native Handle gtk_text_buffer_get_iter_at_child_anchor(Handle var0, Handle var1);

    protected static final native Handle gtk_text_buffer_get_start_iter(Handle var0);

    protected static final native Handle gtk_text_buffer_get_end_iter(Handle var0);

    protected static final native void gtk_text_buffer_paste_clipboardInsertPosition(Handle var0, Handle var1, boolean var2);

    private static final native boolean gtk_text_buffer_backspace(Handle var0, Handle var1, boolean var2, boolean var3);

    static {
        TextBuffer.addEvents(evtMap);
    }
}

