/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.HBox;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.StatusBarEvent;
import org.gnu.gtk.event.StatusBarListener;

public class StatusBar
extends HBox {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    public StatusBar() {
        super(StatusBar.gtk_statusbar_new());
        this.finit$();
    }

    public StatusBar(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static StatusBar getStatusBar(Handle handle) {
        if (handle == null) {
            return null;
        }
        StatusBar statusBar = (StatusBar)GObject.getGObjectFromHandle((Handle)handle);
        if (statusBar == null) {
            statusBar = new StatusBar(handle);
        }
        return statusBar;
    }

    public int getContextID(String string) {
        return StatusBar.gtk_statusbar_get_context_id(this.getHandle(), string);
    }

    public int push(int n, String string) {
        return StatusBar.gtk_statusbar_push(this.getHandle(), n, string);
    }

    public void pop(int n) {
        StatusBar.gtk_statusbar_pop(this.getHandle(), n);
    }

    public void remove(int n, int n2) {
        StatusBar.gtk_statusbar_remove(this.getHandle(), n, n2);
    }

    public void setHasResizeGrip(boolean bl) {
        StatusBar.gtk_statusbar_set_has_resize_grip(this.getHandle(), bl);
    }

    public boolean getHasResizeGrip() {
        return StatusBar.gtk_statusbar_get_has_resize_grip(this.getHandle());
    }

    public static Type getType() {
        return new Type(StatusBar.gtk_statusbar_get_type());
    }

    public void addListener(StatusBarListener statusBarListener) {
        int n = Widget.findListener(this.listeners, statusBarListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)StatusBarEvent.Type.TEXT_POPPED);
                evtMap.initialize((GObject)this, (EventType)StatusBarEvent.Type.TEXT_PUSHED);
                this.listeners = new Vector();
            }
            this.listeners.addElement(statusBarListener);
        }
    }

    public void removeListener(StatusBarListener statusBarListener) {
        int n = Widget.findListener(this.listeners, statusBarListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)StatusBarEvent.Type.TEXT_POPPED);
            evtMap.uninitialize((GObject)this, (EventType)StatusBarEvent.Type.TEXT_PUSHED);
            this.listeners = null;
        }
    }

    protected void fireStatusBarEvent(StatusBarEvent statusBarEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            StatusBarListener statusBarListener = (StatusBarListener)this.listeners.elementAt(i);
            statusBarListener.statusBarEvent(statusBarEvent);
        }
    }

    private void handleTextPushed(int n, String string) {
        StatusBarEvent statusBarEvent = new StatusBarEvent((Object)this, StatusBarEvent.Type.TEXT_PUSHED);
        statusBarEvent.setText(string);
        this.fireStatusBarEvent(statusBarEvent);
    }

    private void handleTextPopped(int n, String string) {
        StatusBarEvent statusBarEvent = new StatusBarEvent((Object)this, StatusBarEvent.Type.TEXT_POPPED);
        statusBarEvent.setText(string);
        this.fireStatusBarEvent(statusBarEvent);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("text_pushed", "handleTextPushed", (EventType)StatusBarEvent.Type.TEXT_PUSHED, StatusBar.class$("org.gnu.gtk.event.StatusBarListener"));
        eventMap.addEvent("text_popped", "handleTextPopped", (EventType)StatusBarEvent.Type.TEXT_POPPED, StatusBar.class$("org.gnu.gtk.event.StatusBarListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native Handle getFrame(Handle var0);

    protected static final native Handle getLabel(Handle var0);

    protected static final native int gtk_statusbar_get_type();

    protected static final native Handle gtk_statusbar_new();

    protected static final native int gtk_statusbar_get_context_id(Handle var0, String var1);

    protected static final native int gtk_statusbar_push(Handle var0, int var1, String var2);

    protected static final native void gtk_statusbar_pop(Handle var0, int var1);

    protected static final native void gtk_statusbar_remove(Handle var0, int var1, int var2);

    protected static final native void gtk_statusbar_set_has_resize_grip(Handle var0, boolean var1);

    protected static final native boolean gtk_statusbar_get_has_resize_grip(Handle var0);

    static {
        StatusBar.addEvents(evtMap);
    }
}

