/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Adjustment;
import org.gnu.gtk.Entry;
import org.gnu.gtk.SpinButtonUpdatePolicy;
import org.gnu.gtk.SpinType;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.SpinEvent;
import org.gnu.gtk.event.SpinListener;

public class SpinButton
extends Entry {
    private Vector spinListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.spinListeners = null;
    }

    public SpinButton(Adjustment adjustment, double d, int n) {
        super(SpinButton.gtk_spin_button_new(adjustment.getHandle(), d, n));
        this.finit$();
    }

    public SpinButton(double d, double d2, double d3) {
        super(SpinButton.gtk_spin_button_new_with_range(d, d2, d3));
        this.finit$();
    }

    public SpinButton(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static SpinButton getSpinButton(Handle handle) {
        if (handle == null) {
            return null;
        }
        SpinButton spinButton = (SpinButton)GObject.getGObjectFromHandle((Handle)handle);
        if (spinButton == null) {
            spinButton = new SpinButton(handle);
        }
        return spinButton;
    }

    public void configure(Adjustment adjustment, double d, int n) {
        SpinButton.gtk_spin_button_configure(this.getHandle(), adjustment.getHandle(), d, n);
    }

    public void setAdjustment(Adjustment adjustment) {
        SpinButton.gtk_spin_button_set_adjustment(this.getHandle(), adjustment.getHandle());
    }

    public Adjustment getAdjustment() {
        Handle handle = SpinButton.gtk_spin_button_get_adjustment(this.getHandle());
        return Adjustment.getAdjustment(handle);
    }

    public void setPrecision(int n) {
        SpinButton.gtk_spin_button_set_digits(this.getHandle(), n);
    }

    public void setIncrements(double d, double d2) {
        SpinButton.gtk_spin_button_set_increments(this.getHandle(), d, d2);
    }

    public void setRange(double d, double d2) {
        SpinButton.gtk_spin_button_set_range(this.getHandle(), d, d2);
    }

    public int getIntValue() {
        return SpinButton.gtk_spin_button_get_value_as_int(this.getHandle());
    }

    public void setValue(double d) {
        SpinButton.gtk_spin_button_set_value(this.getHandle(), d);
    }

    public void setUpdatePolicy(SpinButtonUpdatePolicy spinButtonUpdatePolicy) {
        SpinButton.gtk_spin_button_set_update_policy(this.getHandle(), spinButtonUpdatePolicy.getValue());
    }

    public void spin(SpinType spinType, double d) {
        SpinButton.gtk_spin_button_spin(this.getHandle(), spinType.getValue(), d);
    }

    public void setWrap(boolean bl) {
        SpinButton.gtk_spin_button_set_wrap(this.getHandle(), bl);
    }

    public void setSnap(boolean bl) {
        SpinButton.gtk_spin_button_set_snap_to_ticks(this.getHandle(), bl);
    }

    public double getValue() {
        return SpinButton.gtk_spin_button_get_value(this.getHandle());
    }

    public void setNumeric(boolean bl) {
        SpinButton.gtk_spin_button_set_numeric(this.getHandle(), bl);
    }

    public void addListener(SpinListener spinListener) {
        int n = Widget.findListener(this.spinListeners, spinListener);
        if (n == -1) {
            if (this.spinListeners == null) {
                evtMap.initialize((GObject)this, (EventType)SpinEvent.Type.VALUE_CHANGED);
                this.spinListeners = new Vector();
            }
            this.spinListeners.addElement(spinListener);
        }
    }

    public void removeListener(SpinListener spinListener) {
        int n = Widget.findListener(this.spinListeners, spinListener);
        if (n > -1) {
            this.spinListeners.remove(n);
        }
        if (this.spinListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)SpinEvent.Type.VALUE_CHANGED);
            this.spinListeners = null;
        }
    }

    protected void fireSpinEvent(SpinEvent spinEvent) {
        if (this.spinListeners == null) {
            return;
        }
        int n = this.spinListeners.size();
        for (int i = 0; i < n; ++i) {
            SpinListener spinListener = (SpinListener)this.spinListeners.elementAt(i);
            spinListener.spinEvent(spinEvent);
        }
    }

    private void handleValueChanged() {
        this.fireSpinEvent(new SpinEvent(this));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("value_changed", "handleValueChanged", (EventType)SpinEvent.Type.VALUE_CHANGED, SpinButton.class$("org.gnu.gtk.event.SpinListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(SpinButton.gtk_spin_button_get_type());
    }

    protected static final native int gtk_spin_button_get_type();

    protected static final native void gtk_spin_button_configure(Handle var0, Handle var1, double var2, int var4);

    protected static final native Handle gtk_spin_button_new(Handle var0, double var1, int var3);

    protected static final native Handle gtk_spin_button_new_with_range(double var0, double var2, double var4);

    protected static final native void gtk_spin_button_set_adjustment(Handle var0, Handle var1);

    protected static final native Handle gtk_spin_button_get_adjustment(Handle var0);

    protected static final native void gtk_spin_button_set_digits(Handle var0, int var1);

    protected static final native int gtk_spin_button_get_digits(Handle var0);

    protected static final native void gtk_spin_button_set_increments(Handle var0, double var1, double var3);

    protected static final native void gtk_spin_button_get_increments(Handle var0, double[] var1, double[] var2);

    protected static final native void gtk_spin_button_set_range(Handle var0, double var1, double var3);

    protected static final native void gtk_spin_button_get_range(Handle var0, double[] var1, double[] var2);

    protected static final native double gtk_spin_button_get_value(Handle var0);

    protected static final native int gtk_spin_button_get_value_as_int(Handle var0);

    protected static final native void gtk_spin_button_set_value(Handle var0, double var1);

    protected static final native void gtk_spin_button_set_update_policy(Handle var0, int var1);

    protected static final native int gtk_spin_button_get_update_policy(Handle var0);

    protected static final native void gtk_spin_button_set_numeric(Handle var0, boolean var1);

    protected static final native boolean gtk_spin_button_get_numeric(Handle var0);

    protected static final native void gtk_spin_button_spin(Handle var0, int var1, double var2);

    protected static final native void gtk_spin_button_set_wrap(Handle var0, boolean var1);

    protected static final native boolean gtk_spin_button_get_wrap(Handle var0);

    protected static final native void gtk_spin_button_set_snap_to_ticks(Handle var0, boolean var1);

    protected static final native boolean gtk_spin_button_get_snap_to_ticks(Handle var0);

    protected static final native void gtk_spin_button_update(Handle var0);

    static {
        SpinButton.addEvents(evtMap);
    }
}

