/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import org.gnu.gtk.CellRendererText;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.DataColumnString;
import org.gnu.gtk.ListStore;
import org.gnu.gtk.SelectionMode;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreePath;
import org.gnu.gtk.TreeSelection;
import org.gnu.gtk.TreeView;
import org.gnu.gtk.TreeViewColumn;
import org.gnu.gtk.Widget;

public class SimpleList
extends Widget {
    private int size;
    private TreeView view;
    private ListStore store;
    private TreeViewColumn column;
    private CellRendererText renderer;
    private DataColumnString dataBlock;

    private /* synthetic */ void finit$() {
        this.size = 0;
    }

    public SimpleList() {
        this(new TreeView());
    }

    private SimpleList(TreeView treeView) {
        super(treeView.getHandle());
        this.finit$();
        this.dataBlock = new DataColumnString();
        this.store = new ListStore(new DataColumn[]{this.dataBlock});
        this.view = treeView;
        this.view.setModel(this.store);
        this.column = new TreeViewColumn();
        this.renderer = new CellRendererText();
        this.column.packStart(this.renderer, false);
        this.column.addAttributeMapping(this.renderer, CellRendererText.Attribute.TEXT, this.dataBlock);
        this.view.appendColumn(this.column);
        this.view.setHeadersVisible(false);
        this.size = 0;
    }

    public void addStart(String string) {
        TreeIter treeIter = this.store.prependRow();
        this.store.setValue(treeIter, this.dataBlock, string);
        ++this.size;
    }

    public void addEnd(String string) {
        TreeIter treeIter = this.store.appendRow();
        this.store.setValue(treeIter, this.dataBlock, string);
        ++this.size;
    }

    public void add(String string, int n) {
        TreeIter treeIter = this.store.insertRow(n);
        this.store.setValue(treeIter, this.dataBlock, string);
        ++this.size;
    }

    public String getValue(int n) {
        return this.store.getValue(this.store.getIter("" + n), this.dataBlock);
    }

    public boolean getSelected(int n) {
        return this.view.getSelection().getSelected(this.store.getIter("" + n));
    }

    public void select(int n) {
        this.view.getSelection().select(this.store.getIter("" + n));
    }

    public void setSelectable(SelectionMode selectionMode) {
        this.view.getSelection().setMode(selectionMode);
    }

    public void remove(int n) {
        this.store.removeRow(this.store.getIter("" + n));
        --this.size;
    }

    public void remove(String string) {
        TreeIter treeIter = this.store.getFirstIter();
        boolean bl = false;
        while (treeIter != null && !bl) {
            if (this.store.getValue(treeIter, this.dataBlock).equals(string)) {
                bl = true;
                continue;
            }
            treeIter = treeIter.getNextIter();
        }
        if (bl) {
            this.store.removeRow(treeIter);
            --this.size;
        }
    }

    public void setEditable(boolean bl) {
        this.renderer.setEditable(bl);
    }

    public int getSize() {
        return this.size;
    }

    public String[] getSelected() {
        TreeSelection treeSelection = this.view.getSelection();
        TreePath[] treePathArray = treeSelection.getSelectedRows();
        if (treePathArray == null) {
            return null;
        }
        String[] stringArray = new String[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            TreeIter treeIter = this.store.getIter(treePathArray[i]);
            stringArray[i] = this.store.getValue(treeIter, this.dataBlock);
        }
        return stringArray;
    }

    public String[] getEntries() {
        TreeIter treeIter = this.store.getFirstIter();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (treeIter != null) {
            arrayList.add(this.store.getValue(treeIter, this.dataBlock));
            treeIter.getNextIter();
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }
}

