/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Atom;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

public class SelectionData
extends Boxed {
    public SelectionData(Handle handle) {
        super(handle);
    }

    public static SelectionData getSelectionData(Handle handle) {
        if (handle == null) {
            return null;
        }
        SelectionData selectionData = (SelectionData)Boxed.getBoxedFromHandle((Handle)handle);
        if (selectionData == null) {
            selectionData = new SelectionData(handle);
        }
        return selectionData;
    }

    public void setTarget(Atom atom) {
        SelectionData.setTarget(this.getHandle(), atom.getHandle());
    }

    public Atom getSelection() {
        return new Atom(SelectionData.getSelection(this.getHandle()));
    }

    public Atom getTarget() {
        return new Atom(SelectionData.getTarget(this.getHandle()));
    }

    public Atom getType() {
        Handle handle = SelectionData.getType(this.getHandle());
        if (handle == null) {
            return null;
        }
        return new Atom(handle);
    }

    public int getFormat() {
        return SelectionData.getFormat(this.getHandle());
    }

    public int getLength() {
        return SelectionData.getLength(this.getHandle());
    }

    public byte[] getData() {
        return SelectionData.getData(this.getHandle());
    }

    public void setData(byte[] byArray, String string) {
        SelectionData.setData(this.getHandle(), new Atom(string, false).getHandle(), 8, byArray, byArray.length);
    }

    public String getText() {
        return SelectionData.gtk_selection_data_get_text(this.getHandle());
    }

    public boolean setText(String string) {
        this.setTarget(new Atom("UTF8_STRING", false));
        return SelectionData.gtk_selection_data_set_text(this.getHandle(), string);
    }

    public boolean targetsIncludText() {
        return SelectionData.gtk_selection_data_targets_include_text(this.getHandle());
    }

    public boolean targetsIncludeImage(boolean bl) {
        return SelectionData.gtk_selection_data_targets_include_image(this.getHandle(), bl);
    }

    public Atom[] getTargets() {
        Handle[] handleArray = SelectionData.gtk_selection_data_get_targets(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        Atom[] atomArray = new Atom[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            atomArray[i] = new Atom(handleArray[i]);
        }
        return atomArray;
    }

    public boolean setPixbuf(Pixbuf pixbuf) {
        return SelectionData.gtk_selection_data_set_pixbuf(this.getHandle(), pixbuf.getHandle());
    }

    public Pixbuf getPixbuf() {
        Handle handle = SelectionData.gtk_selection_data_get_pixbuf(this.getHandle());
        if (handle == null) {
            return null;
        }
        return new Pixbuf(handle);
    }

    public boolean setUris(String[] stringArray) {
        return SelectionData.gtk_selection_data_set_uris(this.getHandle(), stringArray);
    }

    public String[] getUris() {
        return SelectionData.gtk_selection_data_get_uris(this.getHandle());
    }

    public int getInt() {
        return Integer.parseInt(this.getText());
    }

    public double getDouble() {
        return Double.parseDouble(this.getText());
    }

    public long getLong() {
        return Long.parseLong(this.getText());
    }

    public void setInt(int n) {
        this.setText(String.valueOf(n));
    }

    public void setLong(long l) {
        this.setText(String.valueOf(l));
    }

    public void setDouble(double d) {
        this.setText(String.valueOf(d));
    }

    protected static final native Handle getSelection(Handle var0);

    protected static final native Handle getTarget(Handle var0);

    protected static final native Handle getType(Handle var0);

    protected static final native int getFormat(Handle var0);

    protected static final native int getLength(Handle var0);

    protected static final native Handle getDisplay(Handle var0);

    protected static final native byte[] getData(Handle var0);

    protected static final native void setData(Handle var0, Handle var1, int var2, byte[] var3, int var4);

    protected static final native String gtk_selection_data_get_text(Handle var0);

    protected static final native boolean gtk_selection_data_set_text(Handle var0, String var1);

    protected static final native Handle[] gtk_selection_data_get_targets(Handle var0);

    protected static final native boolean gtk_selection_data_targets_include_text(Handle var0);

    private static final native boolean gtk_selection_data_targets_include_image(Handle var0, boolean var1);

    protected static final native boolean gtk_selection_data_set_pixbuf(Handle var0, Handle var1);

    protected static final native Handle gtk_selection_data_get_pixbuf(Handle var0);

    protected static final native boolean gtk_selection_data_set_uris(Handle var0, String[] var1);

    protected static final native String[] gtk_selection_data_get_uris(Handle var0);

    private static final native void setTarget(Handle var0, Handle var1);
}

