/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Adjustment;
import org.gnu.gtk.Bin;
import org.gnu.gtk.CornerType;
import org.gnu.gtk.HScrollBar;
import org.gnu.gtk.PolicyType;
import org.gnu.gtk.ShadowType;
import org.gnu.gtk.VScrollBar;
import org.gnu.gtk.Widget;

public class ScrolledWindow
extends Bin {
    public ScrolledWindow(Adjustment adjustment, Adjustment adjustment2) {
        super(ScrolledWindow.init(adjustment, adjustment2));
    }

    private static Handle init(Adjustment adjustment, Adjustment adjustment2) {
        Handle handle = null;
        Handle handle2 = null;
        if (adjustment != null) {
            handle = adjustment.getHandle();
        }
        if (adjustment2 != null) {
            handle2 = adjustment2.getHandle();
        }
        return ScrolledWindow.gtk_scrolled_window_new(handle, handle2);
    }

    public ScrolledWindow() {
        super(ScrolledWindow.gtk_scrolled_window_new(null, null));
    }

    public ScrolledWindow(Handle handle) {
        super(handle);
    }

    public static ScrolledWindow getScrolledWindow(Handle handle) {
        if (handle == null) {
            return null;
        }
        ScrolledWindow scrolledWindow = (ScrolledWindow)GObject.getGObjectFromHandle((Handle)handle);
        if (scrolledWindow == null) {
            scrolledWindow = new ScrolledWindow(handle);
        }
        return scrolledWindow;
    }

    public Adjustment getHAdjustment() {
        Handle handle = ScrolledWindow.gtk_scrolled_window_get_hadjustment(this.getHandle());
        return Adjustment.getAdjustment(handle);
    }

    public void setHAdjustment(Adjustment adjustment) {
        ScrolledWindow.gtk_scrolled_window_set_hadjustment(this.getHandle(), adjustment.getHandle());
    }

    public Adjustment getVAdjustment() {
        Handle handle = ScrolledWindow.gtk_scrolled_window_get_vadjustment(this.getHandle());
        return Adjustment.getAdjustment(handle);
    }

    public void setVAdjustment(Adjustment adjustment) {
        ScrolledWindow.gtk_scrolled_window_set_vadjustment(this.getHandle(), adjustment.getHandle());
    }

    public void setPolicy(PolicyType policyType, PolicyType policyType2) {
        ScrolledWindow.gtk_scrolled_window_set_policy(this.getHandle(), policyType.getValue(), policyType2.getValue());
    }

    public void addWithViewport(Widget widget) {
        ScrolledWindow.gtk_scrolled_window_add_with_viewport(this.getHandle(), widget.getHandle());
    }

    public void setPlacement(CornerType cornerType) {
        ScrolledWindow.gtk_scrolled_window_set_placement(this.getHandle(), cornerType.getValue());
    }

    public void setShadowType(ShadowType shadowType) {
        ScrolledWindow.gtk_scrolled_window_set_shadow_type(this.getHandle(), shadowType.getValue());
    }

    public static Type getType() {
        return new Type(ScrolledWindow.gtk_scrolled_window_get_type());
    }

    public HScrollBar getHScrollBar() {
        return HScrollBar.getHScrollBar(ScrolledWindow.gtk_scrolled_window_get_hscrollbar(this.getHandle()));
    }

    public VScrollBar getVScrollBar() {
        return VScrollBar.getVScrollBar(ScrolledWindow.gtk_scrolled_window_get_vscrollbar(this.getHandle()));
    }

    protected static final native int gtk_scrolled_window_get_type();

    protected static final native Handle gtk_scrolled_window_new(Handle var0, Handle var1);

    protected static final native void gtk_scrolled_window_set_hadjustment(Handle var0, Handle var1);

    protected static final native void gtk_scrolled_window_set_vadjustment(Handle var0, Handle var1);

    protected static final native Handle gtk_scrolled_window_get_hadjustment(Handle var0);

    protected static final native Handle gtk_scrolled_window_get_vadjustment(Handle var0);

    protected static final native void gtk_scrolled_window_set_policy(Handle var0, int var1, int var2);

    protected static final native void gtk_scrolled_window_get_policy(Handle var0, int[] var1, int[] var2);

    protected static final native void gtk_scrolled_window_set_placement(Handle var0, int var1);

    protected static final native int gtk_scrolled_window_get_placement(Handle var0);

    protected static final native void gtk_scrolled_window_set_shadow_type(Handle var0, int var1);

    protected static final native int gtk_scrolled_window_get_shadow_type(Handle var0);

    protected static final native void gtk_scrolled_window_add_with_viewport(Handle var0, Handle var1);

    protected static final native Handle gtk_scrolled_window_get_hscrollbar(Handle var0);

    protected static final native Handle gtk_scrolled_window_get_vscrollbar(Handle var0);
}

