/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Progress;
import org.gnu.gtk.ProgressBarOrientation;
import org.gnu.pango.EllipsizeMode;

public class ProgressBar
extends Progress {
    public ProgressBar() {
        super(ProgressBar.gtk_progress_bar_new());
    }

    public ProgressBar(Handle handle) {
        super(handle);
    }

    public static ProgressBar getProgressBar(Handle handle) {
        if (handle == null) {
            return null;
        }
        ProgressBar progressBar = (ProgressBar)GObject.getGObjectFromHandle((Handle)handle);
        if (progressBar == null) {
            progressBar = new ProgressBar(handle);
        }
        return progressBar;
    }

    public void pulse() {
        ProgressBar.gtk_progress_bar_pulse(this.getHandle());
    }

    public void setText(String string) {
        ProgressBar.gtk_progress_bar_set_text(this.getHandle(), string);
    }

    public void setFraction(double d) {
        double d2 = d;
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        ProgressBar.gtk_progress_bar_set_fraction(this.getHandle(), d2);
    }

    public double getFraction() {
        return ProgressBar.gtk_progress_bar_get_fraction(this.getHandle());
    }

    public void setPulseStep(double d) {
        ProgressBar.gtk_progress_bar_set_pulse_step(this.getHandle(), d);
    }

    public void setOrientation(ProgressBarOrientation progressBarOrientation) {
        ProgressBar.gtk_progress_bar_set_orientation(this.getHandle(), progressBarOrientation.getValue());
    }

    public void setEllipsize(EllipsizeMode ellipsizeMode) {
        ProgressBar.gtk_progress_bar_set_ellipsize(this.getHandle(), ellipsizeMode.getValue());
    }

    public EllipsizeMode getEllipsize() {
        return EllipsizeMode.intern(ProgressBar.gtk_progress_bar_get_ellipsize(this.getHandle()));
    }

    public static Type getType() {
        return new Type(ProgressBar.gtk_progress_bar_get_type());
    }

    protected static final native int gtk_progress_bar_get_type();

    protected static final native Handle gtk_progress_bar_new();

    protected static final native void gtk_progress_bar_pulse(Handle var0);

    protected static final native void gtk_progress_bar_set_text(Handle var0, String var1);

    protected static final native void gtk_progress_bar_set_fraction(Handle var0, double var1);

    protected static final native void gtk_progress_bar_set_pulse_step(Handle var0, double var1);

    protected static final native void gtk_progress_bar_set_orientation(Handle var0, int var1);

    protected static final native String gtk_progress_bar_get_text(Handle var0);

    protected static final native double gtk_progress_bar_get_fraction(Handle var0);

    protected static final native double gtk_progress_bar_get_pulse_step(Handle var0);

    protected static final native int gtk_progress_bar_get_orientation(Handle var0);

    private static final native void gtk_progress_bar_set_ellipsize(Handle var0, int var1);

    private static final native int gtk_progress_bar_get_ellipsize(Handle var0);
}

