/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Button;
import org.gnu.gtk.Menu;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.OptionMenuEvent;
import org.gnu.gtk.event.OptionMenuListener;

public class OptionMenu
extends Button {
    private Vector optionMenuListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.optionMenuListeners = null;
    }

    public OptionMenu() {
        super(OptionMenu.gtk_option_menu_new());
        this.finit$();
    }

    public OptionMenu(Handle handle) {
        super(handle);
        this.finit$();
    }

    public void setMenu(Menu menu) {
        OptionMenu.gtk_option_menu_set_menu(this.getHandle(), menu.getHandle());
    }

    public Menu getMenu() {
        Handle handle = OptionMenu.gtk_option_menu_get_menu(this.getHandle());
        return Menu.getMenu(handle);
    }

    public void removeMenu() {
        OptionMenu.gtk_option_menu_remove_menu(this.getHandle());
    }

    public static Type getType() {
        return new Type(OptionMenu.gtk_option_menu_get_type());
    }

    public int getHistory() {
        return OptionMenu.gtk_option_menu_get_history(this.getHandle());
    }

    public void setHistory(int n) {
        OptionMenu.gtk_option_menu_set_history(this.getHandle(), n);
    }

    public void addListener(OptionMenuListener optionMenuListener) {
        int n = Widget.findListener(this.optionMenuListeners, optionMenuListener);
        if (n == -1) {
            if (this.optionMenuListeners == null) {
                evtMap.initialize((GObject)this, (EventType)OptionMenuEvent.Type.CHANGE);
                this.optionMenuListeners = new Vector();
            }
            this.optionMenuListeners.addElement(optionMenuListener);
        }
    }

    public void removeListener(OptionMenuListener optionMenuListener) {
        int n = Widget.findListener(this.optionMenuListeners, optionMenuListener);
        if (n > -1) {
            this.optionMenuListeners.remove(n);
        }
        if (this.optionMenuListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)OptionMenuEvent.Type.CHANGE);
            this.optionMenuListeners = null;
        }
    }

    protected void fireOptionMenuEvent(OptionMenuEvent optionMenuEvent) {
        if (this.optionMenuListeners == null) {
            return;
        }
        int n = this.optionMenuListeners.size();
        for (int i = 0; i < n; ++i) {
            OptionMenuListener optionMenuListener = (OptionMenuListener)this.optionMenuListeners.elementAt(i);
            optionMenuListener.optionMenuEvent(optionMenuEvent);
        }
    }

    private void handleChange() {
        this.fireOptionMenuEvent(new OptionMenuEvent((Object)this, OptionMenuEvent.Type.CHANGE));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    protected static void addEvents(EventMap eventMap) {
        eventMap.addEvent("changed", "handleChange", (EventType)OptionMenuEvent.Type.CHANGE, OptionMenu.class$("org.gnu.gtk.event.OptionMenuListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final native int gtk_option_menu_get_type();

    protected static final native Handle gtk_option_menu_new();

    protected static final native Handle gtk_option_menu_get_menu(Handle var0);

    protected static final native void gtk_option_menu_set_menu(Handle var0, Handle var1);

    protected static final native void gtk_option_menu_remove_menu(Handle var0);

    protected static final native int gtk_option_menu_get_history(Handle var0);

    protected static final native void gtk_option_menu_set_history(Handle var0, int var1);

    static {
        OptionMenu.addEvents(evtMap);
    }
}

