/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Item;
import org.gnu.gtk.Menu;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.MenuItemEvent;
import org.gnu.gtk.event.MenuItemListener;

public class MenuItem
extends Item {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    public MenuItem() {
        super(MenuItem.gtk_menu_item_new());
        this.finit$();
    }

    public MenuItem(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static MenuItem getMenuItem(Handle handle) {
        if (handle == null) {
            return null;
        }
        MenuItem menuItem = (MenuItem)GObject.getGObjectFromHandle((Handle)handle);
        if (menuItem == null) {
            menuItem = new MenuItem(handle);
        }
        return menuItem;
    }

    public MenuItem(String string, boolean bl) {
        super(MenuItem.init(string, bl));
        this.finit$();
    }

    private static Handle init(String string, boolean bl) {
        if (bl) {
            return MenuItem.gtk_menu_item_new_with_mnemonic(string);
        }
        return MenuItem.gtk_menu_item_new_with_label(string);
    }

    public void setRightJustified() {
        MenuItem.gtk_menu_item_set_right_justified(this.getHandle(), true);
    }

    public void setLeftJustified() {
        MenuItem.gtk_menu_item_set_right_justified(this.getHandle(), false);
    }

    public void setSubmenu(Menu menu) {
        MenuItem.gtk_menu_item_set_submenu(this.getHandle(), menu.getHandle());
    }

    public void removeSubmenu() {
        MenuItem.gtk_menu_item_remove_submenu(this.getHandle());
    }

    public void emitDeselect() {
        MenuItem.gtk_menu_item_deselect(this.getHandle());
    }

    public void emitActivate() {
        MenuItem.gtk_menu_item_activate(this.getHandle());
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("activate", "handleActivate", (EventType)MenuItemEvent.Type.ACTIVATE, MenuItem.class$("org.gnu.gtk.event.MenuItemListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addListener(MenuItemListener menuItemListener) {
        int n = Widget.findListener(this.listeners, menuItemListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)MenuItemEvent.Type.ACTIVATE);
                this.listeners = new Vector();
            }
            this.listeners.addElement(menuItemListener);
        }
    }

    public void removeListener(MenuItemListener menuItemListener) {
        int n = Widget.findListener(this.listeners, menuItemListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)MenuItemEvent.Type.ACTIVATE);
            this.listeners = null;
        }
    }

    protected void fireMenuItemEvent(MenuItemEvent menuItemEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            MenuItemListener menuItemListener = (MenuItemListener)this.listeners.elementAt(i);
            menuItemListener.menuItemEvent(menuItemEvent);
        }
    }

    private void handleActivate() {
        this.fireMenuItemEvent(new MenuItemEvent((Object)this));
    }

    public static Type getType() {
        return new Type(MenuItem.gtk_menu_item_get_type());
    }

    protected static final native int gtk_menu_item_get_type();

    protected static final native Handle gtk_menu_item_new();

    protected static final native Handle gtk_menu_item_new_with_label(String var0);

    protected static final native Handle gtk_menu_item_new_with_mnemonic(String var0);

    protected static final native void gtk_menu_item_set_submenu(Handle var0, Handle var1);

    protected static final native Handle gtk_menu_item_get_submenu(Handle var0);

    protected static final native void gtk_menu_item_remove_submenu(Handle var0);

    protected static final native void gtk_menu_item_select(Handle var0);

    protected static final native void gtk_menu_item_deselect(Handle var0);

    protected static final native void gtk_menu_item_activate(Handle var0);

    protected static final native void gtk_menu_item_toggle_size_request(Handle var0, int[] var1);

    protected static final native void gtk_menu_item_toggle_size_allocate(Handle var0, int var1);

    protected static final native void gtk_menu_item_set_right_justified(Handle var0, boolean var1);

    protected static final native boolean gtk_menu_item_get_right_justified(Handle var0);

    protected static final native void gtk_menu_item_set_accel_path(Handle var0, String var1);

    static {
        MenuItem.addEvents(evtMap);
    }
}

