/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gnu.gdk.Pixbuf;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.glib.Value;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.DataColumnBoolean;
import org.gnu.gtk.DataColumnDouble;
import org.gnu.gtk.DataColumnIconSize;
import org.gnu.gtk.DataColumnInt;
import org.gnu.gtk.DataColumnLong;
import org.gnu.gtk.DataColumnObject;
import org.gnu.gtk.DataColumnPixbuf;
import org.gnu.gtk.DataColumnStockItem;
import org.gnu.gtk.DataColumnString;
import org.gnu.gtk.DataRow;
import org.gnu.gtk.GtkStockItem;
import org.gnu.gtk.IconSize;
import org.gnu.gtk.SortType;
import org.gnu.gtk.TreeDragDest;
import org.gnu.gtk.TreeDragDestListener;
import org.gnu.gtk.TreeDragSource;
import org.gnu.gtk.TreeDragSourceListener;
import org.gnu.gtk.TreeIter;
import org.gnu.gtk.TreeIterComparison;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreeSortable;
import org.gnu.gtk.TreeSortableHelper;

public class ListStore
extends TreeModel
implements TreeSortable,
TreeDragSource,
TreeDragDest {
    protected HashMap sortMethods;
    private List columnTypes;

    private /* synthetic */ void finit$() {
        this.sortMethods = null;
        this.columnTypes = new ArrayList();
    }

    public ListStore(DataColumn[] dataColumnArray) {
        super(ListStore.initListStore(dataColumnArray));
        this.finit$();
        for (int i = 0; i < dataColumnArray.length; ++i) {
            this.columnTypes.add(dataColumnArray[i]);
        }
    }

    private static Handle initListStore(DataColumn[] dataColumnArray) {
        int[] nArray = new int[dataColumnArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataColumnArray[i].getType().getTypeHandle();
            dataColumnArray[i].setColumn(i);
        }
        return ListStore.gtk_list_store_newv(dataColumnArray.length, nArray);
    }

    public void addRow(DataRow dataRow) {
        TreeIter treeIter = this.appendRow();
        int n = this.columnTypes.size();
        for (int i = 0; i < n; ++i) {
            DataColumn dataColumn = this.getDataColumn(i);
            Object object = dataRow.get(i);
            this.trySetValue(treeIter, dataColumn, object);
        }
    }

    public void addRowAt(DataRow dataRow, int n) {
        TreeIter treeIter = this.insertRow(n);
        int n2 = this.columnTypes.size();
        for (int i = 0; i < n2; ++i) {
            DataColumn dataColumn = this.getDataColumn(i);
            Object object = dataRow.get(i);
            this.trySetValue(treeIter, dataColumn, object);
        }
    }

    private void trySetValue(TreeIter treeIter, DataColumn dataColumn, Object object) {
        if (dataColumn instanceof DataColumnBoolean) {
            this.setValue(treeIter, (DataColumnBoolean)dataColumn, (Boolean)object);
        } else if (dataColumn instanceof DataColumnDouble) {
            this.setValue(treeIter, (DataColumnDouble)dataColumn, (Double)object);
        } else if (dataColumn instanceof DataColumnIconSize) {
            this.setValue(treeIter, (DataColumnIconSize)dataColumn, (IconSize)((Object)object));
        } else if (dataColumn instanceof DataColumnInt) {
            this.setValue(treeIter, (DataColumnInt)dataColumn, (Integer)object);
        } else if (dataColumn instanceof DataColumnObject) {
            this.setValue(treeIter, (DataColumnObject)dataColumn, object);
        } else if (dataColumn instanceof DataColumnPixbuf) {
            this.setValue(treeIter, (DataColumnPixbuf)dataColumn, (Pixbuf)((Object)object));
        } else if (dataColumn instanceof DataColumnStockItem) {
            this.setValue(treeIter, (DataColumnStockItem)dataColumn, (GtkStockItem)object);
        } else if (dataColumn instanceof DataColumnString) {
            this.setValue(treeIter, (DataColumnString)dataColumn, (String)object);
        }
    }

    public DataRow getRowAt(TreeIter treeIter) {
        DataRow dataRow = new DataRow();
        int n = this.columnTypes.size();
        for (int i = 0; i < n; ++i) {
            DataColumn dataColumn = this.getDataColumn(i);
            if (dataColumn instanceof DataColumnBoolean) {
                dataRow.add(this.getValue(treeIter, (DataColumnBoolean)dataColumn));
                continue;
            }
            if (dataColumn instanceof DataColumnDouble) {
                dataRow.add(new Double(this.getValue(treeIter, (DataColumnDouble)dataColumn)));
                continue;
            }
            if (dataColumn instanceof DataColumnIconSize) {
                dataRow.add(new Integer(this.getValue(treeIter, (DataColumnIconSize)dataColumn)));
                continue;
            }
            if (dataColumn instanceof DataColumnInt) {
                dataRow.add(new Integer(this.getValue(treeIter, (DataColumnInt)dataColumn)));
                continue;
            }
            if (dataColumn instanceof DataColumnObject) {
                dataRow.add(this.getValue(treeIter, (DataColumnObject)dataColumn));
                continue;
            }
            if (dataColumn instanceof DataColumnPixbuf) {
                dataRow.add((Object)this.getValue(treeIter, (DataColumnPixbuf)dataColumn));
                continue;
            }
            if (dataColumn instanceof DataColumnStockItem) {
                dataRow.add(this.getValue(treeIter, (DataColumnStockItem)dataColumn));
                continue;
            }
            if (!(dataColumn instanceof DataColumnString)) continue;
            dataRow.add(this.getValue(treeIter, (DataColumnString)dataColumn));
        }
        return dataRow;
    }

    public void setRowAt(DataRow dataRow, TreeIter treeIter) {
        int n = this.columnTypes.size();
        for (int i = 0; i < n; ++i) {
            this.trySetValue(treeIter, this.getDataColumn(i), dataRow.get(i));
        }
    }

    public void setColumnTypes(DataColumn[] dataColumnArray) {
        int[] nArray = new int[dataColumnArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataColumnArray[i].getType().getTypeHandle();
            dataColumnArray[i].setColumn(i);
            this.columnTypes.add(dataColumnArray[i]);
        }
        ListStore.gtk_list_store_set_column_types(this.getHandle(), dataColumnArray.length, nArray);
    }

    public DataColumn getDataColumn(int n) {
        return (DataColumn)this.columnTypes.get(n);
    }

    public List getAllDataColumns() {
        return this.columnTypes;
    }

    public void setValue(TreeIter treeIter, DataColumnString dataColumnString, String string) {
        Value value = new Value(Type.STRING());
        value.setString(string);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnString.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnStockItem dataColumnStockItem, GtkStockItem gtkStockItem) {
        Value value = new Value(Type.STRING());
        value.setString(gtkStockItem.getString());
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnStockItem.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnIconSize dataColumnIconSize, IconSize iconSize) {
        Value value = new Value(Type.INT());
        value.setInteger(iconSize.getValue());
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnIconSize.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnInt dataColumnInt, int n) {
        Value value = new Value(Type.INT());
        value.setInteger(n);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnInt.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnLong dataColumnLong, long l) {
        Value value = new Value(Type.LONG());
        value.setLong(l);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnLong.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnBoolean dataColumnBoolean, boolean bl) {
        Value value = new Value(Type.BOOLEAN());
        value.setBoolean(bl);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnBoolean.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnDouble dataColumnDouble, double d) {
        Value value = new Value(Type.DOUBLE());
        value.setDouble(d);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnDouble.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnObject dataColumnObject, Object object) {
        Value value = new Value(Type.JAVA_OBJECT());
        value.setJavaObject(object);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnObject.getColumn(), value.getHandle());
    }

    public void setValue(TreeIter treeIter, DataColumnPixbuf dataColumnPixbuf, Pixbuf pixbuf) {
        Value value = new Value(Type.OBJECT());
        value.setJavaObject((Object)pixbuf);
        ListStore.gtk_list_store_set_value(this.getHandle(), treeIter.getHandle(), dataColumnPixbuf.getColumn(), value.getHandle());
    }

    public boolean removeRow(TreeIter treeIter) {
        return ListStore.gtk_list_store_remove(this.getHandle(), treeIter.getHandle());
    }

    public TreeIter insertRow(int n) {
        return TreeIter.getTreeIter(ListStore.gtk_list_store_insert(this.getHandle(), n), this);
    }

    public TreeIter insertRowBefore(TreeIter treeIter) {
        Handle handle = treeIter == null ? null : treeIter.getHandle();
        return TreeIter.getTreeIter(ListStore.gtk_list_store_insert_before(this.getHandle(), handle), this);
    }

    public TreeIter insertRowAfter(TreeIter treeIter) {
        Handle handle = treeIter == null ? null : treeIter.getHandle();
        return TreeIter.getTreeIter(ListStore.gtk_list_store_insert_after(this.getHandle(), handle), this);
    }

    public TreeIter prependRow() {
        return TreeIter.getTreeIter(ListStore.gtk_list_store_prepend(this.getHandle()), this);
    }

    public TreeIter appendRow() {
        return TreeIter.getTreeIter(ListStore.gtk_list_store_append(this.getHandle()), this);
    }

    public void clear() {
        ListStore.gtk_list_store_clear(this.getHandle());
    }

    public static Type getType() {
        return new Type(ListStore.gtk_list_store_get_type());
    }

    public void setSortColumn(DataColumn dataColumn, SortType sortType) {
        TreeSortableHelper.setSortColumn(this, dataColumn, sortType);
    }

    public DataColumn getSortColumn() {
        return TreeSortableHelper.getSortColumn(this);
    }

    public SortType getSortOrder() {
        return TreeSortableHelper.getSortOrder(this);
    }

    public void setSortMethod(TreeIterComparison treeIterComparison, DataColumn dataColumn) {
        TreeSortableHelper.setSortMethod(this, treeIterComparison, dataColumn);
    }

    public int handleCompareFunc(Handle handle, Handle handle2, Handle handle3, int n) {
        TreeIterComparison treeIterComparison = TreeSortableHelper.getMethod(this, n);
        if (treeIterComparison != null) {
            TreeModel treeModel = (TreeModel)GObject.getGObjectFromHandle((Handle)handle);
            TreeIter treeIter = TreeIter.getTreeIter(handle2, treeModel);
            TreeIter treeIter2 = TreeIter.getTreeIter(handle3, treeModel);
            return treeIterComparison.compareTreeIters(treeModel, treeIter, treeIter2);
        }
        return 0;
    }

    public void setDragDestListener(TreeDragDestListener treeDragDestListener) {
        throw new RuntimeException("Not yet implemented");
    }

    public void setDragSourceListener(TreeDragSourceListener treeDragSourceListener) {
        throw new RuntimeException("Not yet implemented");
    }

    public void swapRows(TreeIter treeIter, TreeIter treeIter2) {
        ListStore.gtk_list_store_swap(this.getHandle(), treeIter.getHandle(), treeIter2.getHandle());
    }

    public void moveRowToEnd(TreeIter treeIter) {
        ListStore.gtk_list_store_move_before(this.getHandle(), treeIter.getHandle(), null);
    }

    public void moveRowAfter(TreeIter treeIter, TreeIter treeIter2) {
        ListStore.gtk_list_store_move_after(this.getHandle(), treeIter.getHandle(), treeIter2.getHandle());
    }

    public void moveRowToStart(TreeIter treeIter) {
        ListStore.gtk_list_store_move_after(this.getHandle(), treeIter.getHandle(), null);
    }

    public void moveRowBefore(TreeIter treeIter, TreeIter treeIter2) {
        ListStore.gtk_list_store_move_before(this.getHandle(), treeIter.getHandle(), treeIter2.getHandle());
    }

    public boolean isIterValid(TreeIter treeIter) {
        if (treeIter == null) {
            return false;
        }
        return ListStore.gtk_list_store_iter_is_valid(this.getHandle(), treeIter.getHandle());
    }

    public void reorder(int[] nArray) {
        ListStore.gtk_list_store_reorder(this.getHandle(), nArray);
    }

    protected static final native int gtk_list_store_get_type();

    protected static final native Handle gtk_list_store_newv(int var0, int[] var1);

    protected static final native void gtk_list_store_set_column_types(Handle var0, int var1, int[] var2);

    protected static final native void gtk_list_store_set_value(Handle var0, Handle var1, int var2, Handle var3);

    protected static final native boolean gtk_list_store_remove(Handle var0, Handle var1);

    protected static final native Handle gtk_list_store_insert(Handle var0, int var1);

    protected static final native Handle gtk_list_store_insert_before(Handle var0, Handle var1);

    protected static final native Handle gtk_list_store_insert_after(Handle var0, Handle var1);

    protected static final native Handle gtk_list_store_prepend(Handle var0);

    protected static final native Handle gtk_list_store_append(Handle var0);

    protected static final native void gtk_list_store_clear(Handle var0);

    protected static final native boolean gtk_list_store_iter_is_valid(Handle var0, Handle var1);

    protected static final native void gtk_list_store_reorder(Handle var0, int[] var1);

    protected static final native void gtk_list_store_swap(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_list_store_move_after(Handle var0, Handle var1, Handle var2);

    protected static final native void gtk_list_store_move_before(Handle var0, Handle var1, Handle var2);

    protected static native void tree_sortable_set_sort_column_id(Handle var0, int var1, int var2);
}

