/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Struct;
import org.gnu.glib.Type;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.GtkObject;
import org.gnu.gtk.ItemFactoryEntry;
import org.gnu.gtk.Widget;

public class ItemFactory
extends GtkObject {
    public ItemFactory(Type type, String string, AccelGroup accelGroup) {
        super(ItemFactory.init(type, string, accelGroup));
    }

    protected ItemFactory(Handle handle) {
        super(handle);
    }

    static ItemFactory getItemFactory(Handle handle) {
        if (handle == null) {
            return null;
        }
        ItemFactory itemFactory = (ItemFactory)GObject.getGObjectFromHandle((Handle)handle);
        if (itemFactory == null) {
            itemFactory = new ItemFactory(handle);
        }
        return itemFactory;
    }

    private static Handle init(Type type, String string, AccelGroup accelGroup) {
        Handle handle = Struct.getNullHandle();
        if (accelGroup != null) {
            handle = accelGroup.getHandle();
        }
        return ItemFactory.gtk_item_factory_new(type.getTypeHandle(), string, handle);
    }

    public static ItemFactory fromWidget(Widget widget) {
        return ItemFactory.getItemFactory(ItemFactory.gtk_item_factory_from_widget(widget.getHandle()));
    }

    public void createItem(ItemFactoryEntry itemFactoryEntry) {
        ItemFactory.gtk_item_factory_create_item(this.getHandle(), itemFactoryEntry.getHandle(), null, 0);
    }

    public void createItems(ItemFactoryEntry[] itemFactoryEntryArray) {
        Handle[] handleArray = new Handle[itemFactoryEntryArray.length];
        for (int i = 0; i < itemFactoryEntryArray.length; ++i) {
            handleArray[i] = itemFactoryEntryArray[i].getHandle();
        }
        ItemFactory.gtk_item_factory_create_items(this.getHandle(), handleArray.length, handleArray, 0);
    }

    public void deleteItem(String string) {
        ItemFactory.gtk_item_factory_delete_item(this.getHandle(), string);
    }

    public void deleteEntry(ItemFactoryEntry itemFactoryEntry) {
        ItemFactory.gtk_item_factory_delete_entry(this.getHandle(), itemFactoryEntry.getHandle());
    }

    public void deleteEntries(ItemFactoryEntry[] itemFactoryEntryArray) {
        Handle[] handleArray = new Handle[itemFactoryEntryArray.length];
        for (int i = 0; i < itemFactoryEntryArray.length; ++i) {
            handleArray[i] = itemFactoryEntryArray[i].getHandle();
        }
        ItemFactory.gtk_item_factory_delete_entries(this.getHandle(), handleArray.length, handleArray);
    }

    public Widget getItem(String string) {
        Handle handle = ItemFactory.gtk_item_factory_get_item(this.getHandle(), string);
        return Widget.getWidget(handle);
    }

    public Widget getWidget(String string) {
        Handle handle = ItemFactory.gtk_item_factory_get_widget(this.getHandle(), string);
        return Widget.getWidget(handle);
    }

    public void popup(int n, int n2, int n3) {
        if (n3 != 1 && n3 != 2 && n3 != 3) {
            return;
        }
        ItemFactory.gtk_item_factory_popup(this.getHandle(), n, n2, n3, 0);
    }

    public static Type getType() {
        return new Type(ItemFactory.gtk_item_factory_get_type());
    }

    protected static final native int gtk_item_factory_get_type();

    protected static final native Handle gtk_item_factory_new(int var0, String var1, Handle var2);

    protected static final native void gtk_item_factory_construct(Handle var0, int var1, String var2, Handle var3);

    protected static final native void gtk_item_factory_add_foreign(Handle var0, String var1, Handle var2, int var3, int var4);

    protected static final native Handle gtk_item_factory_from_widget(Handle var0);

    protected static final native String gtk_item_factory_path_from_widget(Handle var0);

    protected static final native Handle gtk_item_factory_get_item(Handle var0, String var1);

    protected static final native Handle gtk_item_factory_get_widget(Handle var0, String var1);

    protected static final native Handle gtk_item_factory_get_widget_by_action(Handle var0, Handle var1);

    protected static final native Handle gtk_item_factory_get_item_by_action(Handle var0, Handle var1);

    protected static final native void gtk_item_factory_create_item(Handle var0, Handle var1, Object var2, int var3);

    protected static final native void gtk_item_factory_create_items(Handle var0, int var1, Handle[] var2, int var3);

    protected static final native void gtk_item_factory_delete_item(Handle var0, String var1);

    protected static final native void gtk_item_factory_delete_entry(Handle var0, Handle var1);

    protected static final native void gtk_item_factory_delete_entries(Handle var0, int var1, Handle[] var2);

    protected static final native void gtk_item_factory_popup(Handle var0, int var1, int var2, int var3, int var4);
}

