/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Bin;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.ItemEvent;
import org.gnu.gtk.event.ItemListener;

public class Item
extends Bin {
    private Vector listeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.listeners = null;
    }

    protected Item(Handle handle) {
        super(handle);
        this.finit$();
    }

    protected static Item getItem(Handle handle) {
        if (handle == null) {
            return null;
        }
        Item item = (Item)GObject.getGObjectFromHandle((Handle)handle);
        if (item == null) {
            item = new Item(handle);
        }
        return item;
    }

    public void select() {
        Item.gtk_item_select(this.getHandle());
    }

    public void deselect() {
        Item.gtk_item_deselect(this.getHandle());
    }

    public void toggle() {
        Item.gtk_item_toggle(this.getHandle());
    }

    public void addListener(ItemListener itemListener) {
        int n = Widget.findListener(this.listeners, itemListener);
        if (n == -1) {
            if (this.listeners == null) {
                evtMap.initialize((GObject)this, (EventType)ItemEvent.Type.DESELECT);
                evtMap.initialize((GObject)this, (EventType)ItemEvent.Type.SELECT);
                evtMap.initialize((GObject)this, (EventType)ItemEvent.Type.TOGGLE);
                this.listeners = new Vector();
            }
            this.listeners.addElement(itemListener);
        }
    }

    public void removeListener(ItemListener itemListener) {
        int n = Widget.findListener(this.listeners, itemListener);
        if (n > -1) {
            this.listeners.remove(n);
        }
        if (this.listeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)ItemEvent.Type.DESELECT);
            evtMap.uninitialize((GObject)this, (EventType)ItemEvent.Type.SELECT);
            evtMap.uninitialize((GObject)this, (EventType)ItemEvent.Type.TOGGLE);
            this.listeners = null;
        }
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        if (this.listeners == null) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ItemListener itemListener = (ItemListener)this.listeners.elementAt(i);
            itemListener.itemEvent(itemEvent);
        }
    }

    private void handleSelect() {
        this.fireItemEvent(new ItemEvent((Object)this, ItemEvent.Type.SELECT));
    }

    private void handleDeselect() {
        this.fireItemEvent(new ItemEvent((Object)this, ItemEvent.Type.DESELECT));
    }

    private void handleToggle() {
        this.fireItemEvent(new ItemEvent((Object)this, ItemEvent.Type.TOGGLE));
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("select", "handleSelect", (EventType)ItemEvent.Type.SELECT, Item.class$("org.gnu.gtk.event.ItemListener"));
        eventMap.addEvent("deselect", "handleDeselect", (EventType)ItemEvent.Type.DESELECT, Item.class$("org.gnu.gtk.event.ItemListener"));
        eventMap.addEvent("toggle", "handleToggle", (EventType)ItemEvent.Type.TOGGLE, Item.class$("org.gnu.gtk.event.ItemListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(Item.gtk_item_get_type());
    }

    protected static final native int gtk_item_get_type();

    protected static final native void gtk_item_select(Handle var0);

    protected static final native void gtk_item_deselect(Handle var0);

    protected static final native void gtk_item_toggle(Handle var0);

    static {
        Item.addEvents(evtMap);
    }
}

