/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.Adjustment;
import org.gnu.gtk.CellLayout;
import org.gnu.gtk.CellLayoutHelper;
import org.gnu.gtk.CellRenderer;
import org.gnu.gtk.CellRendererAttribute;
import org.gnu.gtk.Container;
import org.gnu.gtk.DataColumn;
import org.gnu.gtk.Orientation;
import org.gnu.gtk.SelectionMode;
import org.gnu.gtk.TreeModel;
import org.gnu.gtk.TreePath;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.IconViewEvent;
import org.gnu.gtk.event.IconViewListener;

public class IconView
extends Container
implements CellLayout {
    private Vector ivListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.ivListeners = null;
    }

    public IconView() {
        super(IconView.gtk_icon_view_new());
        this.finit$();
    }

    public IconView(TreeModel treeModel) {
        super(IconView.gtk_icon_view_new_with_model(treeModel.getHandle()));
        this.finit$();
    }

    public IconView(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static IconView getIconView(Handle handle) {
        if (handle == null) {
            return null;
        }
        IconView iconView = (IconView)GObject.getGObjectFromHandle((Handle)handle);
        if (iconView == null) {
            iconView = new IconView(handle);
        }
        return iconView;
    }

    public void setModel(TreeModel treeModel) {
        Handle handle = treeModel == null ? null : treeModel.getHandle();
        IconView.gtk_icon_view_set_model(this.getHandle(), handle);
    }

    public TreeModel getModel() {
        Handle handle = IconView.gtk_icon_view_get_model(this.getHandle());
        return TreeModel.getTreeModel(handle);
    }

    public void setTextColumn(int n) {
        IconView.gtk_icon_view_set_text_column(this.getHandle(), n);
    }

    public int getTextColumn() {
        return IconView.gtk_icon_view_get_text_column(this.getHandle());
    }

    public void setMarkupColumn(int n) {
        IconView.gtk_icon_view_set_markup_column(this.getHandle(), n);
    }

    public int getMarkupColumn() {
        return IconView.gtk_icon_view_get_markup_column(this.getHandle());
    }

    public void setPixbufColumn(int n) {
        IconView.gtk_icon_view_set_pixbuf_column(this.getHandle(), n);
    }

    public int getPixbufColumn() {
        return IconView.gtk_icon_view_get_pixbuf_column(this.getHandle());
    }

    public void setOrientation(Orientation orientation) {
        IconView.gtk_icon_view_set_orientation(this.getHandle(), orientation.getValue());
    }

    public Orientation getOrientation() {
        return Orientation.intern(IconView.gtk_icon_view_get_orientation(this.getHandle()));
    }

    public void setColumns(int n) {
        IconView.gtk_icon_view_set_columns(this.getHandle(), n);
    }

    public int getColumns() {
        return IconView.gtk_icon_view_get_columns(this.getHandle());
    }

    public void setItemWidth(int n) {
        IconView.gtk_icon_view_set_item_width(this.getHandle(), n);
    }

    public int getItemWidth() {
        return IconView.gtk_icon_view_get_item_width(this.getHandle());
    }

    public void setSpacing(int n) {
        IconView.gtk_icon_view_set_spacing(this.getHandle(), n);
    }

    public int getSpacing() {
        return IconView.gtk_icon_view_get_spacing(this.getHandle());
    }

    public void setRowSpacing(int n) {
        IconView.gtk_icon_view_set_row_spacing(this.getHandle(), n);
    }

    public int getRowSpacing() {
        return IconView.gtk_icon_view_get_row_spacing(this.getHandle());
    }

    public void setColumnSpacing(int n) {
        IconView.gtk_icon_view_set_column_spacing(this.getHandle(), n);
    }

    public int getColumnSpacing() {
        return IconView.gtk_icon_view_get_column_spacing(this.getHandle());
    }

    public void setMargin(int n) {
        IconView.gtk_icon_view_set_margin(this.getHandle(), n);
    }

    public int getMargin() {
        return IconView.gtk_icon_view_get_margin(this.getHandle());
    }

    public void setReorderable(boolean bl) {
        IconView.gtk_icon_view_set_reorderable(this.getHandle(), bl);
    }

    public boolean getReorderable() {
        return IconView.gtk_icon_view_get_reorderable(this.getHandle());
    }

    public TreePath getPathAtPosition(int n, int n2) {
        Handle handle = IconView.gtk_icon_view_get_path_at_pos(this.getHandle(), n, n2);
        return TreePath.getTreePath(handle);
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        IconView.gtk_icon_view_set_selection_mode(this.getHandle(), selectionMode.getValue());
    }

    public SelectionMode getSelectionMode() {
        return SelectionMode.intern(IconView.gtk_icon_view_get_selection_mode(this.getHandle()));
    }

    public void selectPath(TreePath treePath) {
        IconView.gtk_icon_view_select_path(this.getHandle(), treePath.getHandle());
    }

    public void unselectPath(TreePath treePath) {
        IconView.gtk_icon_view_unselect_path(this.getHandle(), treePath.getHandle());
    }

    public boolean pathIsSelected(TreePath treePath) {
        return IconView.gtk_icon_view_path_is_selected(this.getHandle(), treePath.getHandle());
    }

    public TreePath[] getSelectedItems() {
        Handle[] handleArray = IconView.gtk_icon_view_get_selected_items(this.getHandle());
        if (handleArray == null) {
            return null;
        }
        TreePath[] treePathArray = new TreePath[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            treePathArray[i] = TreePath.getTreePath(handleArray[i]);
        }
        return treePathArray;
    }

    public void selectAll() {
        IconView.gtk_icon_view_select_all(this.getHandle());
    }

    public void unselectAll() {
        IconView.gtk_icon_view_unselect_all(this.getHandle());
    }

    public void itemActivated(TreePath treePath) {
        IconView.gtk_icon_view_item_activated(this.getHandle(), treePath.getHandle());
    }

    public void setCursor(TreePath treePath, CellRenderer cellRenderer, boolean bl) {
        Handle handle = null;
        if (cellRenderer != null) {
            handle = cellRenderer.getHandle();
        } else if (bl) {
            throw new IllegalArgumentException("Cannot start editing on a null CellRenderer");
        }
        IconView.gtk_icon_view_set_cursor(this.getHandle(), treePath.getHandle(), handle, bl);
    }

    public TreePath getCursorPath() {
        Handle handle = IconView.gtk_icon_view_get_cursor_path(this.getHandle());
        return TreePath.getTreePath(handle);
    }

    public CellRenderer getCursorCellRenderer() {
        Handle handle = IconView.gtk_icon_view_get_cursor_cell_renderer(this.getHandle());
        return CellRenderer.getCellRenderer(handle);
    }

    public CellRenderer getCellRendererAtPosition(int n, int n2) {
        Handle handle = IconView.gtk_icon_view_get_cell_renderer_at_pos(this.getHandle(), n, n2);
        return CellRenderer.getCellRenderer(handle);
    }

    public void addListener(IconViewListener iconViewListener) {
        int n = Widget.findListener(this.ivListeners, iconViewListener);
        if (n == -1) {
            if (this.ivListeners == null) {
                evtMap.initialize((GObject)this, (EventType)IconViewEvent.Type.SET_SCROLL_ADJUSTMENTS);
                evtMap.initialize((GObject)this, (EventType)IconViewEvent.Type.ITEM_ACTIVATED);
                evtMap.initialize((GObject)this, (EventType)IconViewEvent.Type.SELECTION_CHANGED);
                this.ivListeners = new Vector();
            }
            this.ivListeners.addElement(iconViewListener);
        }
    }

    public void removeListener(IconViewListener iconViewListener) {
        int n = Widget.findListener(this.ivListeners, iconViewListener);
        if (n > -1) {
            this.ivListeners.remove(n);
        }
        if (this.ivListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)IconViewEvent.Type.SET_SCROLL_ADJUSTMENTS);
            evtMap.uninitialize((GObject)this, (EventType)IconViewEvent.Type.ITEM_ACTIVATED);
            evtMap.uninitialize((GObject)this, (EventType)IconViewEvent.Type.SELECTION_CHANGED);
            this.ivListeners = null;
        }
    }

    protected void fireIconViewEvent(IconViewEvent iconViewEvent) {
        if (this.ivListeners == null) {
            return;
        }
        int n = this.ivListeners.size();
        for (int i = 0; i < n; ++i) {
            IconViewListener iconViewListener = (IconViewListener)this.ivListeners.elementAt(i);
            iconViewListener.iconViewEvent(iconViewEvent);
        }
    }

    private void handleSetScrollAdjustment(Handle handle, Handle handle2) {
        IconViewEvent iconViewEvent = new IconViewEvent(this, IconViewEvent.Type.SET_SCROLL_ADJUSTMENTS);
        Adjustment adjustment = Adjustment.getAdjustment(handle);
        Adjustment adjustment2 = Adjustment.getAdjustment(handle2);
        iconViewEvent.setHorizontalAdjustment(adjustment);
        iconViewEvent.setVerticalAdjustment(adjustment2);
        this.fireIconViewEvent(iconViewEvent);
    }

    private void handleItemActivated(Handle handle) {
        if (handle == null) {
            return;
        }
        IconViewEvent iconViewEvent = new IconViewEvent(this, IconViewEvent.Type.ITEM_ACTIVATED);
        iconViewEvent.setPath(TreePath.getTreePath(handle));
        this.fireIconViewEvent(iconViewEvent);
    }

    private void handleSelectionChanged() {
        IconViewEvent iconViewEvent = new IconViewEvent(this, IconViewEvent.Type.SELECTION_CHANGED);
        this.fireIconViewEvent(iconViewEvent);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("set_scroll_adjustments", "handleSetScrollAdjustment", (EventType)IconViewEvent.Type.SET_SCROLL_ADJUSTMENTS, IconView.class$("org.gnu.gtk.event.IconViewListener"));
        eventMap.addEvent("item_activated", "handleItemActivated", (EventType)IconViewEvent.Type.ITEM_ACTIVATED, IconView.class$("org.gnu.gtk.event.IconViewListener"));
        eventMap.addEvent("selection_changed", "handleSelectionChanged", (EventType)IconViewEvent.Type.SELECTION_CHANGED, IconView.class$("org.gnu.gtk.event.IconViewListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void packStart(CellRenderer cellRenderer, boolean bl) {
        CellLayoutHelper.packStart(this, cellRenderer, bl);
    }

    public void packEnd(CellRenderer cellRenderer, boolean bl) {
        CellLayoutHelper.packEnd(this, cellRenderer, bl);
    }

    public void clear() {
        CellLayoutHelper.clear(this);
    }

    public void addAttributeMapping(CellRenderer cellRenderer, CellRendererAttribute cellRendererAttribute, DataColumn dataColumn) {
        CellLayoutHelper.addAttributeMapping(this, cellRenderer, cellRendererAttribute, dataColumn);
    }

    public void clearAttributeMappings(CellRenderer cellRenderer) {
        CellLayoutHelper.clearAttributeMappings(this, cellRenderer);
    }

    public void reorder(CellRenderer cellRenderer, int n) {
        CellLayoutHelper.reorder(this, cellRenderer, n);
    }

    protected static final native int gtk_icon_view_get_type();

    protected static final native Handle gtk_icon_view_new();

    protected static final native Handle gtk_icon_view_new_with_model(Handle var0);

    protected static final native void gtk_icon_view_set_model(Handle var0, Handle var1);

    protected static final native Handle gtk_icon_view_get_model(Handle var0);

    protected static final native void gtk_icon_view_set_text_column(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_text_column(Handle var0);

    protected static final native void gtk_icon_view_set_markup_column(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_markup_column(Handle var0);

    protected static final native void gtk_icon_view_set_pixbuf_column(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_pixbuf_column(Handle var0);

    protected static final native void gtk_icon_view_set_orientation(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_orientation(Handle var0);

    protected static final native void gtk_icon_view_set_columns(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_columns(Handle var0);

    protected static final native void gtk_icon_view_set_item_width(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_item_width(Handle var0);

    protected static final native void gtk_icon_view_set_spacing(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_spacing(Handle var0);

    protected static final native void gtk_icon_view_set_row_spacing(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_row_spacing(Handle var0);

    protected static final native void gtk_icon_view_set_column_spacing(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_column_spacing(Handle var0);

    protected static final native void gtk_icon_view_set_margin(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_margin(Handle var0);

    protected static final native Handle gtk_icon_view_get_path_at_pos(Handle var0, int var1, int var2);

    protected static final native void gtk_icon_view_set_selection_mode(Handle var0, int var1);

    protected static final native int gtk_icon_view_get_selection_mode(Handle var0);

    protected static final native void gtk_icon_view_select_path(Handle var0, Handle var1);

    protected static final native void gtk_icon_view_unselect_path(Handle var0, Handle var1);

    protected static final native boolean gtk_icon_view_path_is_selected(Handle var0, Handle var1);

    protected static final native Handle[] gtk_icon_view_get_selected_items(Handle var0);

    protected static final native void gtk_icon_view_select_all(Handle var0);

    protected static final native void gtk_icon_view_unselect_all(Handle var0);

    protected static final native void gtk_icon_view_item_activated(Handle var0, Handle var1);

    protected static final native Handle gtk_icon_view_get_cell_renderer_at_pos(Handle var0, int var1, int var2);

    protected static final native void gtk_icon_view_set_cursor(Handle var0, Handle var1, Handle var2, boolean var3);

    protected static final native Handle gtk_icon_view_get_cursor_path(Handle var0);

    protected static final native Handle gtk_icon_view_get_cursor_cell_renderer(Handle var0);

    protected static final native boolean gtk_icon_view_get_reorderable(Handle var0);

    protected static final native void gtk_icon_view_set_reorderable(Handle var0, boolean var1);

    static {
        IconView.addEvents(evtMap);
    }
}

