/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Screen;
import org.gnu.glib.Boxed;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.IconInfo;
import org.gnu.gtk.IconLookupFlags;
import org.gnu.gtk.IconSize;

public class IconTheme
extends GObject {
    public IconTheme() {
        super(IconTheme.gtk_icon_theme_new());
    }

    private IconTheme(Handle handle) {
        super(handle);
    }

    private static IconTheme getIconTheme(Handle handle) {
        if (handle == null) {
            return null;
        }
        IconTheme iconTheme = (IconTheme)GObject.getGObjectFromHandle((Handle)handle);
        if (iconTheme == null) {
            iconTheme = new IconTheme(handle);
        }
        return iconTheme;
    }

    public static IconTheme getDefault() {
        return IconTheme.getIconTheme(IconTheme.gtk_icon_theme_get_default());
    }

    public static IconTheme getForSceen(Screen screen) {
        return IconTheme.getIconTheme(IconTheme.gtk_icon_theme_get_for_screen(screen.getHandle()));
    }

    public void setScreen(Screen screen) {
        IconTheme.gtk_icon_theme_set_screen(this.getHandle(), screen.getHandle());
    }

    public void setSearchPath(String[] stringArray) {
        IconTheme.gtk_icon_theme_set_search_path(this.getHandle(), stringArray, stringArray.length);
    }

    public String[] getSearchPath() {
        return IconTheme.gtk_icon_theme_get_search_path(this.getHandle());
    }

    public void appendSearchPath(String string) {
        IconTheme.gtk_icon_theme_append_search_path(this.getHandle(), string);
    }

    public void prependSearchPath(String string) {
        IconTheme.gtk_icon_theme_prepend_search_path(this.getHandle(), string);
    }

    public void setCustomtTheme(String string) {
        IconTheme.gtk_icon_theme_set_custom_theme(this.getHandle(), string);
    }

    public boolean hasIcon(String string) {
        return IconTheme.gtk_icon_theme_has_icon(this.getHandle(), string);
    }

    public IconInfo lookupIcon(String string, int n, IconLookupFlags iconLookupFlags) {
        Handle handle = IconTheme.gtk_icon_theme_lookup_icon(this.getHandle(), string, n, iconLookupFlags.getValue());
        if (handle == null) {
            return null;
        }
        IconInfo iconInfo = (IconInfo)Boxed.getBoxedFromHandle((Handle)handle);
        if (iconInfo == null) {
            iconInfo = new IconInfo(handle);
        }
        return iconInfo;
    }

    public Pixbuf loadIcon(String string, int n, IconLookupFlags iconLookupFlags) {
        Handle handle = IconTheme.gtk_icon_theme_load_icon(this.getHandle(), string, n, iconLookupFlags.getValue());
        if (handle == null) {
            return null;
        }
        return new Pixbuf(handle);
    }

    public String[] listIcons(String string) {
        return IconTheme.gtk_icon_theme_list_icons(this.getHandle(), string);
    }

    public boolean rescanIfNeeded() {
        return IconTheme.gtk_icon_theme_rescan_if_needed(this.getHandle());
    }

    public static void addBuiltinIcon(String string, int n, Pixbuf pixbuf) {
        IconTheme.gtk_icon_theme_add_builtin_icon(string, n, pixbuf.getHandle());
    }

    public IconSize[] getIconSizes(String string) {
        int[] nArray = IconTheme.gtk_icon_theme_get_icon_sizes(this.getHandle(), string);
        IconSize[] iconSizeArray = new IconSize[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            iconSizeArray[i] = IconSize.intern(nArray[i]);
        }
        return iconSizeArray;
    }

    protected static final native int gtk_icon_theme_get_type();

    protected static final native Handle gtk_icon_theme_new();

    protected static final native Handle gtk_icon_theme_get_default();

    protected static final native Handle gtk_icon_theme_get_for_screen(Handle var0);

    protected static final native void gtk_icon_theme_set_screen(Handle var0, Handle var1);

    protected static final native void gtk_icon_theme_set_search_path(Handle var0, String[] var1, int var2);

    protected static final native String[] gtk_icon_theme_get_search_path(Handle var0);

    protected static final native void gtk_icon_theme_append_search_path(Handle var0, String var1);

    protected static final native void gtk_icon_theme_prepend_search_path(Handle var0, String var1);

    protected static final native void gtk_icon_theme_set_custom_theme(Handle var0, String var1);

    protected static final native boolean gtk_icon_theme_has_icon(Handle var0, String var1);

    protected static final native Handle gtk_icon_theme_lookup_icon(Handle var0, String var1, int var2, int var3);

    protected static final native Handle gtk_icon_theme_load_icon(Handle var0, String var1, int var2, int var3);

    protected static final native String[] gtk_icon_theme_list_icons(Handle var0, String var1);

    protected static final native String gtk_icon_theme_get_example_icon_name(Handle var0);

    protected static final native boolean gtk_icon_theme_rescan_if_needed(Handle var0);

    protected static final native void gtk_icon_theme_add_builtin_icon(String var0, int var1, Handle var2);

    private static final native int[] gtk_icon_theme_get_icon_sizes(Handle var0, String var1);
}

