/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.Vector;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;
import org.gnu.gtk.Bin;
import org.gnu.gtk.PositionType;
import org.gnu.gtk.ShadowType;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.HandleBoxEvent;
import org.gnu.gtk.event.HandleBoxListener;

public class HandleBox
extends Bin {
    private Vector hbListeners;
    private static EventMap evtMap = new EventMap();

    private /* synthetic */ void finit$() {
        this.hbListeners = null;
    }

    public HandleBox() {
        super(HandleBox.gtk_handle_box_new());
        this.finit$();
    }

    public HandleBox(Handle handle) {
        super(handle);
        this.finit$();
    }

    public static HandleBox getHandleBox(Handle handle) {
        if (handle == null) {
            return null;
        }
        HandleBox handleBox = (HandleBox)GObject.getGObjectFromHandle((Handle)handle);
        if (handleBox == null) {
            handleBox = new HandleBox(handle);
        }
        return handleBox;
    }

    public void setShadowType(ShadowType shadowType) {
        HandleBox.gtk_handle_box_set_shadow_type(this.getHandle(), shadowType.getValue());
    }

    public ShadowType getShadowType() {
        return ShadowType.intern(HandleBox.gtk_handle_box_get_shadow_type(this.getHandle()));
    }

    public void setHandlePosition(PositionType positionType) {
        HandleBox.gtk_handle_box_set_handle_position(this.getHandle(), positionType.getValue());
    }

    public PositionType getHandlePosition() {
        return PositionType.intern(HandleBox.gtk_handle_box_get_handle_position(this.getHandle()));
    }

    public void setShapEdge(PositionType positionType) {
        HandleBox.gtk_handle_box_set_snap_edge(this.getHandle(), positionType.getValue());
    }

    public PositionType getShapEdge() {
        return PositionType.intern(HandleBox.gtk_handle_box_get_snap_edge(this.getHandle()));
    }

    public void addListener(HandleBoxListener handleBoxListener) {
        int n = Widget.findListener(this.hbListeners, handleBoxListener);
        if (n == -1) {
            if (this.hbListeners == null) {
                evtMap.initialize((GObject)this, (EventType)HandleBoxEvent.Type.CHILD_ATTACHED);
                evtMap.initialize((GObject)this, (EventType)HandleBoxEvent.Type.CHILD_DETACHED);
                this.hbListeners = new Vector();
            }
            this.hbListeners.addElement(handleBoxListener);
        }
    }

    public void removeListener(HandleBoxListener handleBoxListener) {
        int n = Widget.findListener(this.hbListeners, handleBoxListener);
        if (n > -1) {
            this.hbListeners.remove(n);
        }
        if (this.hbListeners.size() == 0) {
            evtMap.uninitialize((GObject)this, (EventType)HandleBoxEvent.Type.CHILD_ATTACHED);
            evtMap.uninitialize((GObject)this, (EventType)HandleBoxEvent.Type.CHILD_DETACHED);
            this.hbListeners = null;
        }
    }

    protected void fireHandleBoxEvent(HandleBoxEvent handleBoxEvent) {
        if (this.hbListeners == null) {
            return;
        }
        int n = this.hbListeners.size();
        for (int i = 0; i < n; ++i) {
            HandleBoxListener handleBoxListener = (HandleBoxListener)this.hbListeners.elementAt(i);
            handleBoxListener.handleBoxEvent(handleBoxEvent);
        }
    }

    private void handleChildAttached(Handle handle) {
        HandleBoxEvent handleBoxEvent = new HandleBoxEvent((Object)this, HandleBoxEvent.Type.CHILD_ATTACHED);
        handleBoxEvent.setWidget(Widget.getWidget(handle));
        this.fireHandleBoxEvent(handleBoxEvent);
    }

    private void handleChildDetached(Handle handle) {
        HandleBoxEvent handleBoxEvent = new HandleBoxEvent((Object)this, HandleBoxEvent.Type.CHILD_DETACHED);
        handleBoxEvent.setWidget(Widget.getWidget(handle));
        this.fireHandleBoxEvent(handleBoxEvent);
    }

    public Class getEventListenerClass(String string) {
        Class clazz = evtMap.getEventListenerClass(string);
        if (clazz == null) {
            clazz = super.getEventListenerClass(string);
        }
        return clazz;
    }

    public EventType getEventType(String string) {
        EventType eventType = evtMap.getEventType(string);
        if (eventType == null) {
            eventType = super.getEventType(string);
        }
        return eventType;
    }

    private static void addEvents(EventMap eventMap) {
        eventMap.addEvent("child_attached", "handleChildAttached", (EventType)HandleBoxEvent.Type.CHILD_ATTACHED, HandleBox.class$("org.gnu.gtk.event.HandleBoxListener"));
        eventMap.addEvent("child_detached", "handleChildDetached", (EventType)HandleBoxEvent.Type.CHILD_DETACHED, HandleBox.class$("org.gnu.gtk.event.HandleBoxListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Type getType() {
        return new Type(HandleBox.gtk_handle_box_get_type());
    }

    protected static final native int gtk_handle_box_get_type();

    protected static final native Handle gtk_handle_box_new();

    protected static final native void gtk_handle_box_set_shadow_type(Handle var0, int var1);

    protected static final native int gtk_handle_box_get_shadow_type(Handle var0);

    protected static final native void gtk_handle_box_set_handle_position(Handle var0, int var1);

    protected static final native int gtk_handle_box_get_handle_position(Handle var0);

    protected static final native void gtk_handle_box_set_snap_edge(Handle var0, int var1);

    protected static final native int gtk_handle_box_get_snap_edge(Handle var0);

    static {
        HandleBox.addEvents(evtMap);
    }
}

