/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import org.gnu.gdk.Event;
import org.gnu.gdk.EventKey;
import org.gnu.glib.Handle;
import org.gnu.gtk.GtkInitException;
import org.gnu.gtk.KeySnoopMethod;
import org.gnu.gtk.Widget;

public class Gtk {
    private static Thread gtkThread;
    private static KeySnoopMethod keySnooperMethod;
    private static int keySnooperId;

    private static String[] initArgs(String[] stringArray) {
        String string = System.getProperty("gnome.appName", "java-gnome");
        if (stringArray == null) {
            stringArray = new String[]{string};
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = string;
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static void init(String[] stringArray) {
        int[] nArray = new int[1];
        stringArray = Gtk.initArgs(stringArray);
        nArray[0] = stringArray.length;
        Gtk.gtk_init(nArray, stringArray);
    }

    public static void initCheck(String[] stringArray) throws GtkInitException {
        int[] nArray = new int[1];
        stringArray = Gtk.initArgs(stringArray);
        nArray[0] = stringArray.length;
        if (!Gtk.gtk_init_check(nArray, stringArray)) {
            throw new GtkInitException();
        }
    }

    public static void main() {
        gtkThread = Thread.currentThread();
        Gtk.gtk_main();
    }

    public static boolean isGtkThread() {
        return gtkThread == Thread.currentThread();
    }

    public static boolean mainIteration() {
        return Gtk.gtk_main_iteration();
    }

    public static void mainQuit() {
        Gtk.gtk_main_quit();
    }

    public static boolean eventsPending() {
        return Gtk.gtk_events_pending();
    }

    static String getTypeName(Handle handle) {
        try {
            return Gtk.gtk_type_name(handle);
        }
        catch (Throwable throwable) {
            System.err.println(throwable.toString());
            return null;
        }
    }

    public static boolean getTrue() {
        return Gtk.gtk_true();
    }

    public static boolean getFalse() {
        return Gtk.gtk_false();
    }

    public static boolean mainIterationDo(boolean bl) {
        return Gtk.gtk_main_iteration_do(bl);
    }

    public static void setKeySnoopMethod(KeySnoopMethod keySnoopMethod) {
        keySnooperId = Gtk.gtk_key_snooper_install(keySnoopMethod, "handleKeySnoopEvent");
        keySnooperMethod = keySnoopMethod;
    }

    public static void removeKeySnoopMethod() {
        Gtk.gtk_key_snooper_remove(keySnooperId);
        keySnooperMethod = null;
        keySnooperId = 0;
    }

    protected static boolean handleKeySnoopEvent(Handle handle, Handle handle2) {
        if (keySnooperMethod != null) {
            Widget widget = Widget.getWidget(handle);
            EventKey eventKey = EventKey.getEventKey(handle2);
            return keySnooperMethod.keyEvent(widget, eventKey);
        }
        return false;
    }

    public void propagateEvent(Widget widget, Event event) {
        Gtk.gtk_propagate_event(widget.getHandle(), event.getHandle());
    }

    protected static final native void gtk_init(int[] var0, String[] var1);

    protected static final native boolean gtk_init_check(int[] var0, String[] var1);

    protected static final native void gtk_disable_setlocale();

    protected static final native String gtk_set_locale();

    protected static final native Handle gtk_get_default_language();

    protected static final native boolean gtk_events_pending();

    protected static final native void gtk_main_do_event(Handle var0);

    protected static final native void gtk_main();

    protected static final native int gtk_main_level();

    protected static final native void gtk_main_quit();

    protected static final native boolean gtk_main_iteration();

    protected static final native void gtk_grab_add(Handle var0);

    protected static final native Handle gtk_grab_get_current();

    protected static final native void gtk_grab_remove(Handle var0);

    protected static final native Handle gtk_get_current_event();

    protected static final native int gtk_get_current_event_time();

    protected static final native Handle gtk_get_event_widget(Handle var0);

    protected static final native String gtk_type_name(Handle var0);

    private static final native boolean gtk_true();

    private static final native boolean gtk_false();

    private static final native boolean gtk_main_iteration_do(boolean var0);

    private static final native int gtk_key_snooper_install(KeySnoopMethod var0, String var1);

    private static final native void gtk_key_snooper_remove(int var0);

    private static final native void gtk_propagate_event(Handle var0, Handle var1);

    private Gtk() {
    }

    static {
        keySnooperMethod = null;
        keySnooperId = 0;
        System.loadLibrary("gtkjni-2.10");
    }
}

