/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;
import org.gnu.glib.EventMap;
import org.gnu.glib.EventType;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.gtk.FileChooser;
import org.gnu.gtk.FileChooserAction;
import org.gnu.gtk.FileChooserException;
import org.gnu.gtk.FileChooserHelper;
import org.gnu.gtk.FileFilter;
import org.gnu.gtk.VBox;
import org.gnu.gtk.Widget;
import org.gnu.gtk.event.FileChooserEvent;
import org.gnu.gtk.event.FileChooserListener;

public class FileChooserWidget
extends VBox
implements FileChooser {
    private List listeners;
    private static EventMap eventMap = new EventMap();

    public FileChooserWidget(Handle handle) {
        super(handle);
    }

    public static FileChooserWidget getFileChooserWidget(Handle handle) {
        if (handle == null) {
            return null;
        }
        FileChooserWidget fileChooserWidget = (FileChooserWidget)GObject.getGObjectFromHandle((Handle)handle);
        if (fileChooserWidget == null) {
            fileChooserWidget = new FileChooserWidget(handle);
        }
        return fileChooserWidget;
    }

    public FileChooserWidget(FileChooserAction fileChooserAction) {
        super(FileChooserWidget.gtk_file_chooser_widget_new(fileChooserAction.getValue()));
    }

    public void setAction(FileChooserAction fileChooserAction) {
        FileChooserHelper.gtk_file_chooser_set_action(this.getHandle(), fileChooserAction.getValue());
    }

    public FileChooserAction getAction() {
        return FileChooserAction.intern(FileChooserHelper.gtk_file_chooser_get_action(this.getHandle()));
    }

    public void setLocalOnly(boolean bl) {
        FileChooserHelper.gtk_file_chooser_set_local_only(this.getHandle(), bl);
    }

    public boolean getLocalOnly() {
        return FileChooserHelper.gtk_file_chooser_get_local_only(this.getHandle());
    }

    public void setSelectMultiple(boolean bl) {
        FileChooserHelper.gtk_file_chooser_set_select_multiple(this.getHandle(), bl);
    }

    public boolean getSelectMultiple() {
        return FileChooserHelper.gtk_file_chooser_get_select_multiple(this.getHandle());
    }

    public void setCurrentName(String string) {
        FileChooserHelper.gtk_file_chooser_set_current_name(this.getHandle(), string);
    }

    public String getFilename() {
        return FileChooserHelper.gtk_file_chooser_get_filename(this.getHandle());
    }

    public boolean setFilename(String string) {
        return FileChooserHelper.setFilename(this.getHandle(), string);
    }

    public boolean selectFilename(String string) {
        return FileChooserHelper.gtk_file_chooser_select_filename(this.getHandle(), string);
    }

    public void unselectFilename(String string) {
        FileChooserHelper.gtk_file_chooser_unselect_filename(this.getHandle(), string);
    }

    public void selectAll() {
        FileChooserHelper.gtk_file_chooser_select_all(this.getHandle());
    }

    public void unselectAll() {
        FileChooserHelper.gtk_file_chooser_unselect_all(this.getHandle());
    }

    public String[] getFilenames() {
        return FileChooserHelper.gtk_file_chooser_get_filenames(this.getHandle());
    }

    public boolean setCurrentFolder(String string) {
        return FileChooserHelper.gtk_file_chooser_set_current_folder(this.getHandle(), string);
    }

    public String getCurrentFolder() {
        return FileChooserHelper.gtk_file_chooser_get_current_folder(this.getHandle());
    }

    public String getURI() {
        return FileChooserHelper.gtk_file_chooser_get_uri(this.getHandle());
    }

    public boolean setURI(String string) {
        return FileChooserHelper.gtk_file_chooser_set_uri(this.getHandle(), string);
    }

    public boolean selectURI(String string) {
        return FileChooserHelper.gtk_file_chooser_select_uri(this.getHandle(), string);
    }

    public void unselectURI(String string) {
        FileChooserHelper.gtk_file_chooser_unselect_uri(this.getHandle(), string);
    }

    public String[] getURIs() {
        return FileChooserHelper.gtk_file_chooser_get_uris(this.getHandle());
    }

    public boolean setCurrentFolderURI(String string) {
        return FileChooserHelper.gtk_file_chooser_set_current_folder_uri(this.getHandle(), string);
    }

    public String getCurrentFolderURI() {
        return FileChooserHelper.gtk_file_chooser_get_current_folder_uri(this.getHandle());
    }

    public void setPreviewWidget(Widget widget) {
        FileChooserHelper.gtk_file_chooser_set_preview_widget(this.getHandle(), widget.getHandle());
    }

    public Widget getPreviewWidget() {
        Handle handle = FileChooserHelper.gtk_file_chooser_get_preview_widget(this.getHandle());
        return Widget.getWidget(handle);
    }

    public void setUsePreviewLabel(boolean bl) {
        FileChooserHelper.gtk_file_chooser_set_use_preview_label(this.getHandle(), bl);
    }

    public boolean getUsePreviewLabel() {
        return FileChooserHelper.gtk_file_chooser_get_use_preview_label(this.getHandle());
    }

    public void setPreviewWidgetActive(boolean bl) {
        FileChooserHelper.gtk_file_chooser_set_preview_widget_active(this.getHandle(), bl);
    }

    public boolean getPreviewWidgetActive() {
        return FileChooserHelper.gtk_file_chooser_get_preview_widget_active(this.getHandle());
    }

    public String getPreviewFilename() {
        return FileChooserHelper.gtk_file_chooser_get_preview_filename(this.getHandle());
    }

    public String getPreviewURI() {
        return FileChooserHelper.gtk_file_chooser_get_preview_uri(this.getHandle());
    }

    public void setExtraWidget(Widget widget) {
        FileChooserHelper.gtk_file_chooser_set_extra_widget(this.getHandle(), widget.getHandle());
    }

    public Widget getExtraWidget() {
        Handle handle = FileChooserHelper.gtk_file_chooser_get_extra_widget(this.getHandle());
        return Widget.getWidget(handle);
    }

    public void addFilter(FileFilter fileFilter) {
        FileChooserHelper.gtk_file_chooser_add_filter(this.getHandle(), fileFilter.getHandle());
    }

    public void removeFilter(FileFilter fileFilter) {
        FileChooserHelper.gtk_file_chooser_remove_filter(this.getHandle(), fileFilter.getHandle());
    }

    public FileFilter[] listFilters() {
        Handle[] handleArray = FileChooserHelper.gtk_file_chooser_list_filters(this.getHandle());
        FileFilter[] fileFilterArray = new FileFilter[handleArray.length];
        for (int i = 0; i < handleArray.length; ++i) {
            fileFilterArray[i] = FileFilter.getFileFilter(handleArray[i]);
        }
        return fileFilterArray;
    }

    public void setFilter(FileFilter fileFilter) {
        FileChooserHelper.gtk_file_chooser_set_filter(this.getHandle(), fileFilter.getHandle());
    }

    public FileFilter getFilter() {
        Handle handle = FileChooserHelper.gtk_file_chooser_get_filter(this.getHandle());
        return FileFilter.getFileFilter(handle);
    }

    public void addShortcutFolder(String string) throws FileChooserException {
        FileChooserHelper.addShortcutFolder(this.getHandle(), string);
    }

    public void removeShortcutFolder(String string) throws FileChooserException {
        FileChooserHelper.removeShortcutFolder(this.getHandle(), string);
    }

    public String[] listShortcutFolders() {
        return FileChooserHelper.gtk_file_chooser_list_shortcut_folders(this.getHandle());
    }

    public void addShortcutURI(String string) throws FileChooserException {
        FileChooserHelper.addShortcutURI(this.getHandle(), string);
    }

    public void removeShortcutURI(String string) throws FileChooserException {
        FileChooserHelper.removeShortcutURI(this.getHandle(), string);
    }

    public String[] listShortcutURIs() {
        return FileChooserHelper.gtk_file_chooser_list_shortcut_folder_uris(this.getHandle());
    }

    public void setShowHidden(boolean bl) {
        FileChooserHelper.gtk_file_chooser_set_show_hidden(this.getHandle(), bl);
    }

    public boolean getShowHidden() {
        return FileChooserHelper.gtk_file_chooser_get_show_hidden(this.getHandle());
    }

    public void addListener(FileChooserListener fileChooserListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        FileChooserHelper.addListener(this.listeners, fileChooserListener, eventMap, this);
    }

    public void removeListener(FileChooserListener fileChooserListener) {
        FileChooserHelper.removeListener(this.listeners, fileChooserListener, eventMap, this);
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    private static void addEvents(EventMap eventMap) {
        FileChooserEvent.Type[] typeArray = FileChooserEvent.Type.getTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            eventMap.addEvent((EventType)typeArray[i], FileChooserWidget.class$("org.gnu.gtk.FileChooserWidget"));
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void handleCurrentFolderChanged() {
        FileChooserEvent fileChooserEvent = new FileChooserEvent((Object)this, FileChooserEvent.Type.CURRENT_FOLDER_CHANGED);
        FileChooserHelper.fireCurrentFolderChanged(this.listeners, fileChooserEvent);
    }

    private void handleFileActivated() {
        FileChooserEvent fileChooserEvent = new FileChooserEvent((Object)this, FileChooserEvent.Type.CURRENT_FOLDER_CHANGED);
        FileChooserHelper.fireFileActivated(this.listeners, fileChooserEvent);
    }

    private void handleSelectionChanged() {
        FileChooserEvent fileChooserEvent = new FileChooserEvent((Object)this, FileChooserEvent.Type.CURRENT_FOLDER_CHANGED);
        FileChooserHelper.fireSelectionChanged(this.listeners, fileChooserEvent);
    }

    private void handleUpdatePreview() {
        FileChooserEvent fileChooserEvent = new FileChooserEvent((Object)this, FileChooserEvent.Type.CURRENT_FOLDER_CHANGED);
        FileChooserHelper.fireUpdatePreview(this.listeners, fileChooserEvent);
    }

    protected static final native int gtk_file_chooser_widget_get_type();

    protected static final native Handle gtk_file_chooser_widget_new(int var0);

    static {
        FileChooserWidget.addEvents(eventMap);
    }
}

